package software.amazon.awscdk.services.simspaceweaver;

/**
 * Properties for defining a <code>CfnSimulation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.simspaceweaver.*;
 * CfnSimulationProps cfnSimulationProps = CfnSimulationProps.builder()
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .maximumDuration("maximumDuration")
 *         .schemaS3Location(S3LocationProperty.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 .build())
 *         .snapshotS3Location(S3LocationProperty.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.094Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_simspaceweaver.CfnSimulationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSimulationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSimulationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the simulation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management ( IAM ) role that the simulation assumes to perform actions.
     * <p>
     * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> . For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <em>AWS Identity and Access Management User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D).
     * <p>
     * The simulation stops when it reaches this limit. The maximum value is <code>14D</code> , or its equivalent in the other units. The default value is <code>14D</code> . A value equivalent to <code>0</code> makes the simulation immediately transition to <code>STOPPING</code> as soon as it reaches <code>STARTED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-maximumduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-maximumduration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaximumDuration() {
        return null;
    }

    /**
     * The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
     * <p>
     * For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
     * <p>
     * Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
     * <p>
     * If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-schemas3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-schemas3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaS3Location() {
        return null;
    }

    /**
     * The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
     * <p>
     * For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
     * <p>
     * Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
     * <p>
     * If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-snapshots3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-snapshots3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotS3Location() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSimulationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSimulationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSimulationProps> {
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.String maximumDuration;
        java.lang.Object schemaS3Location;
        java.lang.Object snapshotS3Location;

        /**
         * Sets the value of {@link CfnSimulationProps#getName}
         * @param name The name of the simulation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimulationProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the AWS Identity and Access Management ( IAM ) role that the simulation assumes to perform actions. This parameter is required.
         *                For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> . For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <em>AWS Identity and Access Management User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimulationProps#getMaximumDuration}
         * @param maximumDuration The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D).
         *                        The simulation stops when it reaches this limit. The maximum value is <code>14D</code> , or its equivalent in the other units. The default value is <code>14D</code> . A value equivalent to <code>0</code> makes the simulation immediately transition to <code>STOPPING</code> as soon as it reaches <code>STARTED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumDuration(java.lang.String maximumDuration) {
            this.maximumDuration = maximumDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimulationProps#getSchemaS3Location}
         * @param schemaS3Location The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
         *                         For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         *                         <p>
         *                         Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
         *                         <p>
         *                         If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaS3Location(software.amazon.awscdk.IResolvable schemaS3Location) {
            this.schemaS3Location = schemaS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimulationProps#getSchemaS3Location}
         * @param schemaS3Location The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
         *                         For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         *                         <p>
         *                         Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
         *                         <p>
         *                         If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaS3Location(software.amazon.awscdk.services.simspaceweaver.CfnSimulation.S3LocationProperty schemaS3Location) {
            this.schemaS3Location = schemaS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimulationProps#getSnapshotS3Location}
         * @param snapshotS3Location The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
         *                           For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         *                           <p>
         *                           Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
         *                           <p>
         *                           If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotS3Location(software.amazon.awscdk.IResolvable snapshotS3Location) {
            this.snapshotS3Location = snapshotS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimulationProps#getSnapshotS3Location}
         * @param snapshotS3Location The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
         *                           For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         *                           <p>
         *                           Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
         *                           <p>
         *                           If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotS3Location(software.amazon.awscdk.services.simspaceweaver.CfnSimulation.S3LocationProperty snapshotS3Location) {
            this.snapshotS3Location = snapshotS3Location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSimulationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSimulationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSimulationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSimulationProps {
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.String maximumDuration;
        private final java.lang.Object schemaS3Location;
        private final java.lang.Object snapshotS3Location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maximumDuration = software.amazon.jsii.Kernel.get(this, "maximumDuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaS3Location = software.amazon.jsii.Kernel.get(this, "schemaS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotS3Location = software.amazon.jsii.Kernel.get(this, "snapshotS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.maximumDuration = builder.maximumDuration;
            this.schemaS3Location = builder.schemaS3Location;
            this.snapshotS3Location = builder.snapshotS3Location;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getMaximumDuration() {
            return this.maximumDuration;
        }

        @Override
        public final java.lang.Object getSchemaS3Location() {
            return this.schemaS3Location;
        }

        @Override
        public final java.lang.Object getSnapshotS3Location() {
            return this.snapshotS3Location;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getMaximumDuration() != null) {
                data.set("maximumDuration", om.valueToTree(this.getMaximumDuration()));
            }
            if (this.getSchemaS3Location() != null) {
                data.set("schemaS3Location", om.valueToTree(this.getSchemaS3Location()));
            }
            if (this.getSnapshotS3Location() != null) {
                data.set("snapshotS3Location", om.valueToTree(this.getSnapshotS3Location()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_simspaceweaver.CfnSimulationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSimulationProps.Jsii$Proxy that = (CfnSimulationProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.maximumDuration != null ? !this.maximumDuration.equals(that.maximumDuration) : that.maximumDuration != null) return false;
            if (this.schemaS3Location != null ? !this.schemaS3Location.equals(that.schemaS3Location) : that.schemaS3Location != null) return false;
            return this.snapshotS3Location != null ? this.snapshotS3Location.equals(that.snapshotS3Location) : that.snapshotS3Location == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.maximumDuration != null ? this.maximumDuration.hashCode() : 0);
            result = 31 * result + (this.schemaS3Location != null ? this.schemaS3Location.hashCode() : 0);
            result = 31 * result + (this.snapshotS3Location != null ? this.snapshotS3Location.hashCode() : 0);
            return result;
        }
    }
}
