package software.amazon.awscdk.services.sns;

/**
 * Properties to associate SNS topics with a policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = new Topic(this, "Topic");
 * PolicyDocument policyDocument = PolicyDocument.Builder.create()
 *         .assignSids(true)
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("sns:Subscribe"))
 *                     .principals(List.of(new AnyPrincipal()))
 *                     .resources(List.of(topic.getTopicArn()))
 *                     .build()))
 *         .build();
 * TopicPolicy topicPolicy = TopicPolicy.Builder.create(this, "Policy")
 *         .topics(List.of(topic))
 *         .policyDocument(policyDocument)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.145Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.TopicPolicyProps")
@software.amazon.jsii.Jsii.Proxy(TopicPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TopicPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of topics this policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.sns.ITopic> getTopics();

    /**
     * Adds a statement to enforce encryption of data in transit when publishing to the topic.
     * <p>
     * For more information, see https://docs.aws.amazon.com/sns/latest/dg/sns-security-best-practices.html#enforce-encryption-data-in-transit.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnforceSSL() {
        return null;
    }

    /**
     * IAM policy document to apply to topic(s).
     * <p>
     * Default: empty policy document
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TopicPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TopicPolicyProps> {
        java.util.List<software.amazon.awscdk.services.sns.ITopic> topics;
        java.lang.Boolean enforceSsl;
        software.amazon.awscdk.services.iam.PolicyDocument policyDocument;

        /**
         * Sets the value of {@link TopicPolicyProps#getTopics}
         * @param topics The set of topics this policy applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder topics(java.util.List<? extends software.amazon.awscdk.services.sns.ITopic> topics) {
            this.topics = (java.util.List<software.amazon.awscdk.services.sns.ITopic>)topics;
            return this;
        }

        /**
         * Sets the value of {@link TopicPolicyProps#getEnforceSsl}
         * @param enforceSsl Adds a statement to enforce encryption of data in transit when publishing to the topic.
         *                   For more information, see https://docs.aws.amazon.com/sns/latest/dg/sns-security-best-practices.html#enforce-encryption-data-in-transit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceSsl(java.lang.Boolean enforceSsl) {
            this.enforceSsl = enforceSsl;
            return this;
        }

        /**
         * Sets the value of {@link TopicPolicyProps#getPolicyDocument}
         * @param policyDocument IAM policy document to apply to topic(s).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(software.amazon.awscdk.services.iam.PolicyDocument policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TopicPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TopicPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicPolicyProps {
        private final java.util.List<software.amazon.awscdk.services.sns.ITopic> topics;
        private final java.lang.Boolean enforceSsl;
        private final software.amazon.awscdk.services.iam.PolicyDocument policyDocument;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topics = software.amazon.jsii.Kernel.get(this, "topics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class)));
            this.enforceSsl = software.amazon.jsii.Kernel.get(this, "enforceSSL", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topics = (java.util.List<software.amazon.awscdk.services.sns.ITopic>)java.util.Objects.requireNonNull(builder.topics, "topics is required");
            this.enforceSsl = builder.enforceSsl;
            this.policyDocument = builder.policyDocument;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.sns.ITopic> getTopics() {
            return this.topics;
        }

        @Override
        public final java.lang.Boolean getEnforceSSL() {
            return this.enforceSsl;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topics", om.valueToTree(this.getTopics()));
            if (this.getEnforceSSL() != null) {
                data.set("enforceSSL", om.valueToTree(this.getEnforceSSL()));
            }
            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.TopicPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicPolicyProps.Jsii$Proxy that = (TopicPolicyProps.Jsii$Proxy) o;

            if (!topics.equals(that.topics)) return false;
            if (this.enforceSsl != null ? !this.enforceSsl.equals(that.enforceSsl) : that.enforceSsl != null) return false;
            return this.policyDocument != null ? this.policyDocument.equals(that.policyDocument) : that.policyDocument == null;
        }

        @Override
        public final int hashCode() {
            int result = this.topics.hashCode();
            result = 31 * result + (this.enforceSsl != null ? this.enforceSsl.hashCode() : 0);
            result = 31 * result + (this.policyDocument != null ? this.policyDocument.hashCode() : 0);
            return result;
        }
    }
}
