package software.amazon.awscdk.services.stepfunctions;

/**
 * Defines which category of execution history events are logged.
 * <p>
 * Default: ERROR
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * Chain definition = Chain.start(new Pass(this, "Pass"));
 * StateMachine.Builder.create(this, "MyStateMachine")
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .logs(LogOptions.builder()
 *                 .destination(logGroup)
 *                 .level(LogLevel.ALL)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.398Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.LogLevel")
public enum LogLevel {
    /**
     * No Logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OFF,
    /**
     * Log everything.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * Log all errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ERROR,
    /**
     * Log fatal errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FATAL,
}
