package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrModifyInstanceGroupByName.Builder.create(this, "Task")
 *         .clusterId("ClusterId")
 *         .instanceGroupName(JsonPath.stringAt("$.InstanceGroupName"))
 *         .instanceGroup(InstanceGroupModifyConfigProperty.builder()
 *                 .instanceCount(1)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.598Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceGroupByName")
public class EmrModifyInstanceGroupByName extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected EmrModifyInstanceGroupByName(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrModifyInstanceGroupByName(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmrModifyInstanceGroupByName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByNameProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
    /**
     * Modify the size or configurations of an instance group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * EmrModifyInstanceGroupByName.Builder.create(this, "Task")
     *         .clusterId("ClusterId")
     *         .instanceGroupName(JsonPath.stringAt("$.InstanceGroupName"))
     *         .instanceGroup(InstanceGroupModifyConfigProperty.builder()
     *                 .instanceCount(1)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupModifyConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupModifyConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceGroupModifyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceGroupModifyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of new or modified configurations to apply for an instance group.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * The EC2 InstanceIds to terminate.
         * <p>
         * After you terminate the instances, the instance group will not return to its original requested size.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEC2InstanceIdsToTerminate() {
            return null;
        }

        /**
         * Target size for the instance group.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * Policy for customizing shrink operations.
         * <p>
         * Default: - None
         * <p>
         * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty getShrinkPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceGroupModifyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceGroupModifyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceGroupModifyConfigProperty> {
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            java.util.List<java.lang.String> eC2InstanceIdsToTerminate;
            java.lang.Number instanceCount;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty shrinkPolicy;

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getConfigurations}
             * @param configurations A list of new or modified configurations to apply for an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getEC2InstanceIdsToTerminate}
             * @param eC2InstanceIdsToTerminate The EC2 InstanceIds to terminate.
             *                                  After you terminate the instances, the instance group will not return to its original requested size.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eC2InstanceIdsToTerminate(java.util.List<java.lang.String> eC2InstanceIdsToTerminate) {
                this.eC2InstanceIdsToTerminate = eC2InstanceIdsToTerminate;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getInstanceCount}
             * @param instanceCount Target size for the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getShrinkPolicy}
             * @param shrinkPolicy Policy for customizing shrink operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shrinkPolicy(software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty shrinkPolicy) {
                this.shrinkPolicy = shrinkPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceGroupModifyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceGroupModifyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceGroupModifyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceGroupModifyConfigProperty {
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final java.util.List<java.lang.String> eC2InstanceIdsToTerminate;
            private final java.lang.Number instanceCount;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty shrinkPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.eC2InstanceIdsToTerminate = software.amazon.jsii.Kernel.get(this, "eC2InstanceIdsToTerminate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shrinkPolicy = software.amazon.jsii.Kernel.get(this, "shrinkPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)builder.configurations;
                this.eC2InstanceIdsToTerminate = builder.eC2InstanceIdsToTerminate;
                this.instanceCount = builder.instanceCount;
                this.shrinkPolicy = builder.shrinkPolicy;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public final java.util.List<java.lang.String> getEC2InstanceIdsToTerminate() {
                return this.eC2InstanceIdsToTerminate;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty getShrinkPolicy() {
                return this.shrinkPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getEC2InstanceIdsToTerminate() != null) {
                    data.set("eC2InstanceIdsToTerminate", om.valueToTree(this.getEC2InstanceIdsToTerminate()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getShrinkPolicy() != null) {
                    data.set("shrinkPolicy", om.valueToTree(this.getShrinkPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceGroupModifyConfigProperty.Jsii$Proxy that = (InstanceGroupModifyConfigProperty.Jsii$Proxy) o;

                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.eC2InstanceIdsToTerminate != null ? !this.eC2InstanceIdsToTerminate.equals(that.eC2InstanceIdsToTerminate) : that.eC2InstanceIdsToTerminate != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                return this.shrinkPolicy != null ? this.shrinkPolicy.equals(that.shrinkPolicy) : that.shrinkPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurations != null ? this.configurations.hashCode() : 0;
                result = 31 * result + (this.eC2InstanceIdsToTerminate != null ? this.eC2InstanceIdsToTerminate.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.shrinkPolicy != null ? this.shrinkPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * InstanceResizePolicyProperty instanceResizePolicyProperty = InstanceResizePolicyProperty.builder()
     *         .instancesToProtect(List.of("instancesToProtect"))
     *         .instancesToTerminate(List.of("instancesToTerminate"))
     *         .instanceTerminationTimeout(Duration.minutes(30))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceResizePolicy.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceResizePolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceResizePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceResizePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specific list of instances to be protected when shrinking an instance group.
         * <p>
         * Default: - No instances will be protected when shrinking an instance group
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstancesToProtect() {
            return null;
        }

        /**
         * Specific list of instances to be terminated when shrinking an instance group.
         * <p>
         * Default: - No instances will be terminated when shrinking an instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstancesToTerminate() {
            return null;
        }

        /**
         * Decommissioning timeout override for the specific list of instances to be terminated.
         * <p>
         * Default: cdk.Duration.seconds
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getInstanceTerminationTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceResizePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceResizePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceResizePolicyProperty> {
            java.util.List<java.lang.String> instancesToProtect;
            java.util.List<java.lang.String> instancesToTerminate;
            software.amazon.awscdk.Duration instanceTerminationTimeout;

            /**
             * Sets the value of {@link InstanceResizePolicyProperty#getInstancesToProtect}
             * @param instancesToProtect Specific list of instances to be protected when shrinking an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancesToProtect(java.util.List<java.lang.String> instancesToProtect) {
                this.instancesToProtect = instancesToProtect;
                return this;
            }

            /**
             * Sets the value of {@link InstanceResizePolicyProperty#getInstancesToTerminate}
             * @param instancesToTerminate Specific list of instances to be terminated when shrinking an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancesToTerminate(java.util.List<java.lang.String> instancesToTerminate) {
                this.instancesToTerminate = instancesToTerminate;
                return this;
            }

            /**
             * Sets the value of {@link InstanceResizePolicyProperty#getInstanceTerminationTimeout}
             * @param instanceTerminationTimeout Decommissioning timeout override for the specific list of instances to be terminated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceTerminationTimeout(software.amazon.awscdk.Duration instanceTerminationTimeout) {
                this.instanceTerminationTimeout = instanceTerminationTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceResizePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceResizePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceResizePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceResizePolicyProperty {
            private final java.util.List<java.lang.String> instancesToProtect;
            private final java.util.List<java.lang.String> instancesToTerminate;
            private final software.amazon.awscdk.Duration instanceTerminationTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instancesToProtect = software.amazon.jsii.Kernel.get(this, "instancesToProtect", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instancesToTerminate = software.amazon.jsii.Kernel.get(this, "instancesToTerminate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceTerminationTimeout = software.amazon.jsii.Kernel.get(this, "instanceTerminationTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instancesToProtect = builder.instancesToProtect;
                this.instancesToTerminate = builder.instancesToTerminate;
                this.instanceTerminationTimeout = builder.instanceTerminationTimeout;
            }

            @Override
            public final java.util.List<java.lang.String> getInstancesToProtect() {
                return this.instancesToProtect;
            }

            @Override
            public final java.util.List<java.lang.String> getInstancesToTerminate() {
                return this.instancesToTerminate;
            }

            @Override
            public final software.amazon.awscdk.Duration getInstanceTerminationTimeout() {
                return this.instanceTerminationTimeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstancesToProtect() != null) {
                    data.set("instancesToProtect", om.valueToTree(this.getInstancesToProtect()));
                }
                if (this.getInstancesToTerminate() != null) {
                    data.set("instancesToTerminate", om.valueToTree(this.getInstancesToTerminate()));
                }
                if (this.getInstanceTerminationTimeout() != null) {
                    data.set("instanceTerminationTimeout", om.valueToTree(this.getInstanceTerminationTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceResizePolicyProperty.Jsii$Proxy that = (InstanceResizePolicyProperty.Jsii$Proxy) o;

                if (this.instancesToProtect != null ? !this.instancesToProtect.equals(that.instancesToProtect) : that.instancesToProtect != null) return false;
                if (this.instancesToTerminate != null ? !this.instancesToTerminate.equals(that.instancesToTerminate) : that.instancesToTerminate != null) return false;
                return this.instanceTerminationTimeout != null ? this.instanceTerminationTimeout.equals(that.instanceTerminationTimeout) : that.instanceTerminationTimeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instancesToProtect != null ? this.instancesToProtect.hashCode() : 0;
                result = 31 * result + (this.instancesToTerminate != null ? this.instancesToTerminate.hashCode() : 0);
                result = 31 * result + (this.instanceTerminationTimeout != null ? this.instanceTerminationTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Policy for customizing shrink operations.
     * <p>
     * Allows configuration of decommissioning timeout and targeted instance shrinking.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ShrinkPolicyProperty shrinkPolicyProperty = ShrinkPolicyProperty.builder()
     *         .decommissionTimeout(Duration.minutes(30))
     *         .instanceResizePolicy(InstanceResizePolicyProperty.builder()
     *                 .instancesToProtect(List.of("instancesToProtect"))
     *                 .instancesToTerminate(List.of("instancesToTerminate"))
     *                 .instanceTerminationTimeout(Duration.minutes(30))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ShrinkPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ShrinkPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The desired timeout for decommissioning an instance.
         * <p>
         * Overrides the default YARN decommissioning timeout.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDecommissionTimeout() {
            return null;
        }

        /**
         * Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty getInstanceResizePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ShrinkPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShrinkPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ShrinkPolicyProperty> {
            software.amazon.awscdk.Duration decommissionTimeout;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty instanceResizePolicy;

            /**
             * Sets the value of {@link ShrinkPolicyProperty#getDecommissionTimeout}
             * @param decommissionTimeout The desired timeout for decommissioning an instance.
             *                            Overrides the default YARN decommissioning timeout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decommissionTimeout(software.amazon.awscdk.Duration decommissionTimeout) {
                this.decommissionTimeout = decommissionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ShrinkPolicyProperty#getInstanceResizePolicy}
             * @param instanceResizePolicy Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceResizePolicy(software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty instanceResizePolicy) {
                this.instanceResizePolicy = instanceResizePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShrinkPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ShrinkPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ShrinkPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShrinkPolicyProperty {
            private final software.amazon.awscdk.Duration decommissionTimeout;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty instanceResizePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.decommissionTimeout = software.amazon.jsii.Kernel.get(this, "decommissionTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
                this.instanceResizePolicy = software.amazon.jsii.Kernel.get(this, "instanceResizePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.decommissionTimeout = builder.decommissionTimeout;
                this.instanceResizePolicy = builder.instanceResizePolicy;
            }

            @Override
            public final software.amazon.awscdk.Duration getDecommissionTimeout() {
                return this.decommissionTimeout;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty getInstanceResizePolicy() {
                return this.instanceResizePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDecommissionTimeout() != null) {
                    data.set("decommissionTimeout", om.valueToTree(this.getDecommissionTimeout()));
                }
                if (this.getInstanceResizePolicy() != null) {
                    data.set("instanceResizePolicy", om.valueToTree(this.getInstanceResizePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShrinkPolicyProperty.Jsii$Proxy that = (ShrinkPolicyProperty.Jsii$Proxy) o;

                if (this.decommissionTimeout != null ? !this.decommissionTimeout.equals(that.decommissionTimeout) : that.decommissionTimeout != null) return false;
                return this.instanceResizePolicy != null ? this.instanceResizePolicy.equals(that.instanceResizePolicy) : that.instanceResizePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.decommissionTimeout != null ? this.decommissionTimeout.hashCode() : 0;
                result = 31 * result + (this.instanceResizePolicy != null ? this.instanceResizePolicy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByNameProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByNameProps.Builder();
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Credentials for an IAM Role that the State Machine assumes for executing the task.
         * <p>
         * This enables cross-account resource invocations.
         * <p>
         * Default: - None (Task is executed using the State Machine's execution role)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html</a>
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * (deprecated) Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>heartbeatTimeout</code>
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(final software.amazon.awscdk.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeatTimeout Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns.
         * <p>
         * Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html</a>
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * Timeout for the task.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param taskTimeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        /**
         * (deprecated) Timeout for the task.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>taskTimeout</code>
         * @param timeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The ClusterId to update.
         * <p>
         * @return {@code this}
         * @param clusterId The ClusterId to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterId(final java.lang.String clusterId) {
            this.props.clusterId(clusterId);
            return this;
        }

        /**
         * The JSON that you want to provide to your ModifyInstanceGroup call as input.
         * <p>
         * This uses the same syntax as the ModifyInstanceGroups API.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ModifyInstanceGroups.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ModifyInstanceGroups.html</a>
         * @param instanceGroup The JSON that you want to provide to your ModifyInstanceGroup call as input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroup(final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty instanceGroup) {
            this.props.instanceGroup(instanceGroup);
            return this;
        }

        /**
         * The InstanceGroupName to update.
         * <p>
         * @return {@code this}
         * @param instanceGroupName The InstanceGroupName to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroupName(final java.lang.String instanceGroupName) {
            this.props.instanceGroupName(instanceGroupName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
