package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Constructs <code>IS3Location</code> objects.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTrainingJob.Builder.create(this, "TrainSagemaker")
 *         .trainingJobName(JsonPath.stringAt("$.JobName"))
 *         .algorithmSpecification(AlgorithmSpecification.builder()
 *                 .algorithmName("BlazingText")
 *                 .trainingInputMode(InputMode.FILE)
 *                 .build())
 *         .inputDataConfig(List.of(Channel.builder()
 *                 .channelName("train")
 *                 .dataSource(DataSource.builder()
 *                         .s3DataSource(S3DataSource.builder()
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .s3Location(S3Location.fromJsonExpression("$.S3Bucket"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .outputDataConfig(OutputDataConfig.builder()
 *                 .s3OutputLocation(S3Location.fromBucket(Bucket.fromBucketName(this, "Bucket", "amzn-s3-demo-bucket"), "myoutputpath"))
 *                 .build())
 *         .resourceConfig(ResourceConfig.builder()
 *                 .instanceCount(1)
 *                 .instanceType(new InstanceType(JsonPath.stringAt("$.InstanceType")))
 *                 .volumeSize(Size.gibibytes(50))
 *                 .build()) // optional: default is 1 instance of EC2 `M4.XLarge` with `10GB` volume
 *         .stoppingCondition(StoppingCondition.builder()
 *                 .maxRuntime(Duration.hours(2))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.651Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.S3Location")
public abstract class S3Location extends software.amazon.jsii.JsiiObject {

    protected S3Location(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Location(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected S3Location() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * An <code>IS3Location</code> built with a determined bucket and key prefix.
     * <p>
     * @param bucket is the bucket where the objects are to be stored. This parameter is required.
     * @param keyPrefix is the key prefix used by the location. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3Location fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String keyPrefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(keyPrefix, "keyPrefix is required") });
    }

    /**
     * An <code>IS3Location</code> determined fully by a JSON Path from the task input.
     * <p>
     * Due to the dynamic nature of those locations, the IAM grants that will be set by <code>grantRead</code> and <code>grantWrite</code>
     * apply to the <code>*</code> resource.
     * <p>
     * @param expression the JSON expression resolving to an S3 location URI. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3Location fromJsonExpression(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class, "fromJsonExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * Called when the S3Location is bound to a StepFunctions task.
     * <p>
     * @param task This parameter is required.
     * @param opts This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ISageMakerTask task, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationBindOptions opts);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.tasks.S3Location {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the S3Location is bound to a StepFunctions task.
         * <p>
         * @param task This parameter is required.
         * @param opts This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ISageMakerTask task, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationBindOptions opts) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3LocationConfig.class), new Object[] { java.util.Objects.requireNonNull(task, "task is required"), java.util.Objects.requireNonNull(opts, "opts is required") });
        }
    }
}
