package software.amazon.awscdk;

/**
 * A synthesizer that uses conventional asset locations, but not conventional deployment roles.
 * <p>
 * Instead of assuming the bootstrapped deployment roles, all stack operations will be performed
 * using the CLI's current credentials.
 * <p>
 * <ul>
 * <li>This synthesizer does not support deploying to accounts to which the CLI does not have
 * credentials. It also does not support deploying using <strong>CDK Pipelines</strong>. For either of those
 * features, use <code>DefaultStackSynthesizer</code>.</li>
 * <li>This synthesizer requires an S3 bucket and ECR repository with well-known names. To
 * not depend on those, use <code>LegacyStackSynthesizer</code>.</li>
 * </ul>
 * <p>
 * Be aware that your CLI credentials must be valid for the duration of the
 * entire deployment. If you are using session credentials, make sure the
 * session lifetime is long enough.
 * <p>
 * By default, expects the environment to have been bootstrapped with just the staging resources
 * of the Bootstrap Stack V2 (also known as "modern bootstrap stack"). You can override
 * the default names using the synthesizer's construction properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CliCredentialsStackSynthesizer cliCredentialsStackSynthesizer = CliCredentialsStackSynthesizer.Builder.create()
 *         .bucketPrefix("bucketPrefix")
 *         .dockerTagPrefix("dockerTagPrefix")
 *         .fileAssetsBucketName("fileAssetsBucketName")
 *         .imageAssetsRepositoryName("imageAssetsRepositoryName")
 *         .qualifier("qualifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:48.266Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CliCredentialsStackSynthesizer")
public class CliCredentialsStackSynthesizer extends software.amazon.awscdk.StackSynthesizer implements software.amazon.awscdk.IReusableStackSynthesizer, software.amazon.awscdk.IBoundStackSynthesizer {

    protected CliCredentialsStackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CliCredentialsStackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CliCredentialsStackSynthesizer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CliCredentialsStackSynthesizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CliCredentialsStackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Produce a bound Stack Synthesizer for the given stack.
     * <p>
     * This method may be called more than once on the same object.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IBoundStackSynthesizer reusableBind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        return software.amazon.jsii.Kernel.call(this, "reusableBind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IBoundStackSynthesizer.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * The qualifier used to bootstrap this stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBootstrapQualifier() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.CliCredentialsStackSynthesizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.CliCredentialsStackSynthesizer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.CliCredentialsStackSynthesizerProps.Builder props;

        private Builder() {
        }

        /**
         * bucketPrefix to use while storing S3 Assets.
         * <p>
         * Default: - DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX
         * <p>
         * @return {@code this}
         * @param bucketPrefix bucketPrefix to use while storing S3 Assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(final java.lang.String bucketPrefix) {
            this.props().bucketPrefix(bucketPrefix);
            return this;
        }

        /**
         * A prefix to use while tagging and uploading Docker images to ECR.
         * <p>
         * This does not add any separators - the source hash will be appended to
         * this string directly.
         * <p>
         * Default: - DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX
         * <p>
         * @return {@code this}
         * @param dockerTagPrefix A prefix to use while tagging and uploading Docker images to ECR. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerTagPrefix(final java.lang.String dockerTagPrefix) {
            this.props().dockerTagPrefix(dockerTagPrefix);
            return this;
        }

        /**
         * Name of the S3 bucket to hold file assets.
         * <p>
         * You must supply this if you have given a non-standard name to the staging bucket.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
         * <p>
         * @return {@code this}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetsBucketName(final java.lang.String fileAssetsBucketName) {
            this.props().fileAssetsBucketName(fileAssetsBucketName);
            return this;
        }

        /**
         * Name of the ECR repository to hold Docker Image assets.
         * <p>
         * You must supply this if you have given a non-standard name to the ECR repository.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
         * <p>
         * @return {@code this}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetsRepositoryName(final java.lang.String imageAssetsRepositoryName) {
            this.props().imageAssetsRepositoryName(imageAssetsRepositoryName);
            return this;
        }

        /**
         * Qualifier to disambiguate multiple environments in the same account.
         * <p>
         * You can use this and leave the other naming properties empty if you have deployed
         * the bootstrap environment with standard names but only different qualifiers.
         * <p>
         * Default: - Value of context key '@aws-cdk/core:bootstrapQualifier' if set, otherwise `DefaultStackSynthesizer.DEFAULT_QUALIFIER`
         * <p>
         * @return {@code this}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(final java.lang.String qualifier) {
            this.props().qualifier(qualifier);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.CliCredentialsStackSynthesizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.CliCredentialsStackSynthesizer build() {
            return new software.amazon.awscdk.CliCredentialsStackSynthesizer(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.CliCredentialsStackSynthesizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.CliCredentialsStackSynthesizerProps.Builder();
            }
            return this.props;
        }
    }
}
