package software.amazon.awscdk.pipelines;

/**
 * Construction properties for a <code>ShellStep</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline codePipeline;
 * Artifact sourceArtifact = new Artifact("MySourceArtifact");
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .codePipeline(codePipeline)
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineFileSet.fromArtifact(sourceArtifact))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:04.742Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ShellStepProps")
@software.amazon.jsii.Jsii.Proxy(ShellStepProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ShellStepProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Commands to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCommands();

    /**
     * Additional FileSets to put in other directories.
     * <p>
     * Specifies a mapping from directory name to FileSets. During the
     * script execution, the FileSets will be available in the directories
     * indicated.
     * <p>
     * The directory names may be relative. For example, you can put
     * the main input and an additional input side-by-side with the
     * following configuration:
     * <p>
     * <blockquote><pre>
     * ShellStep script = ShellStep.Builder.create("MainScript")
     *         .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
     *         .input(CodePipelineSource.gitHub("org/source1", "main"))
     *         .additionalInputs(Map.of(
     *                 "../siblingdir", CodePipelineSource.gitHub("org/source2", "main")))
     *         .build();
     * </pre></blockquote>
     * <p>
     * Default: - No additional inputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer> getAdditionalInputs() {
        return null;
    }

    /**
     * Environment variables to set.
     * <p>
     * Default: - No environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * Set environment variables based on Stack Outputs.
     * <p>
     * <code>ShellStep</code>s following stack or stage deployments may
     * access the <code>CfnOutput</code>s of those stacks to get access to
     * --for example--automatically generated resource names or
     * endpoint URLs.
     * <p>
     * Default: - No environment variables created from stack outputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput> getEnvFromCfnOutputs() {
        return null;
    }

    /**
     * FileSet to run these scripts on.
     * <p>
     * The files in the FileSet will be placed in the working directory when
     * the script is executed. Use <code>additionalInputs</code> to download file sets
     * to other directories as well.
     * <p>
     * Default: - No input specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.IFileSetProducer getInput() {
        return null;
    }

    /**
     * Installation commands to run before the regular commands.
     * <p>
     * For deployment engines that support it, install commands will be classified
     * differently in the job history from the regular <code>commands</code>.
     * <p>
     * Default: - No installation commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstallCommands() {
        return null;
    }

    /**
     * The directory that will contain the primary output fileset.
     * <p>
     * After running the script, the contents of the given directory
     * will be treated as the primary output of this Step.
     * <p>
     * Default: - No primary output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryOutputDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ShellStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ShellStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ShellStepProps> {
        java.util.List<java.lang.String> commands;
        java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs;
        java.util.Map<java.lang.String, java.lang.String> env;
        java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput> envFromCfnOutputs;
        software.amazon.awscdk.pipelines.IFileSetProducer input;
        java.util.List<java.lang.String> installCommands;
        java.lang.String primaryOutputDirectory;

        /**
         * Sets the value of {@link ShellStepProps#getCommands}
         * @param commands Commands to run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(java.util.List<java.lang.String> commands) {
            this.commands = commands;
            return this;
        }

        /**
         * Sets the value of {@link ShellStepProps#getAdditionalInputs}
         * @param additionalInputs Additional FileSets to put in other directories.
         *                         Specifies a mapping from directory name to FileSets. During the
         *                         script execution, the FileSets will be available in the directories
         *                         indicated.
         *                         <p>
         *                         The directory names may be relative. For example, you can put
         *                         the main input and an additional input side-by-side with the
         *                         following configuration:
         *                         <p>
         *                         <blockquote><pre>
         *                         ShellStep script = ShellStep.Builder.create("MainScript")
         *                                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
         *                                 .input(CodePipelineSource.gitHub("org/source1", "main"))
         *                                 .additionalInputs(Map.of(
         *                                         "../siblingdir", CodePipelineSource.gitHub("org/source2", "main")))
         *                                 .build();
         *                         </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder additionalInputs(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs) {
            this.additionalInputs = (java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer>)additionalInputs;
            return this;
        }

        /**
         * Sets the value of {@link ShellStepProps#getEnv}
         * @param env Environment variables to set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link ShellStepProps#getEnvFromCfnOutputs}
         * @param envFromCfnOutputs Set environment variables based on Stack Outputs.
         *                          <code>ShellStep</code>s following stack or stage deployments may
         *                          access the <code>CfnOutput</code>s of those stacks to get access to
         *                          --for example--automatically generated resource names or
         *                          endpoint URLs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder envFromCfnOutputs(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.CfnOutput> envFromCfnOutputs) {
            this.envFromCfnOutputs = (java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput>)envFromCfnOutputs;
            return this;
        }

        /**
         * Sets the value of {@link ShellStepProps#getInput}
         * @param input FileSet to run these scripts on.
         *              The files in the FileSet will be placed in the working directory when
         *              the script is executed. Use <code>additionalInputs</code> to download file sets
         *              to other directories as well.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.pipelines.IFileSetProducer input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link ShellStepProps#getInstallCommands}
         * @param installCommands Installation commands to run before the regular commands.
         *                        For deployment engines that support it, install commands will be classified
         *                        differently in the job history from the regular <code>commands</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installCommands(java.util.List<java.lang.String> installCommands) {
            this.installCommands = installCommands;
            return this;
        }

        /**
         * Sets the value of {@link ShellStepProps#getPrimaryOutputDirectory}
         * @param primaryOutputDirectory The directory that will contain the primary output fileset.
         *                               After running the script, the contents of the given directory
         *                               will be treated as the primary output of this Step.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryOutputDirectory(java.lang.String primaryOutputDirectory) {
            this.primaryOutputDirectory = primaryOutputDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ShellStepProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ShellStepProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ShellStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShellStepProps {
        private final java.util.List<java.lang.String> commands;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput> envFromCfnOutputs;
        private final software.amazon.awscdk.pipelines.IFileSetProducer input;
        private final java.util.List<java.lang.String> installCommands;
        private final java.lang.String primaryOutputDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.commands = software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.additionalInputs = software.amazon.jsii.Kernel.get(this, "additionalInputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class)));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.envFromCfnOutputs = software.amazon.jsii.Kernel.get(this, "envFromCfnOutputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnOutput.class)));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class));
            this.installCommands = software.amazon.jsii.Kernel.get(this, "installCommands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.primaryOutputDirectory = software.amazon.jsii.Kernel.get(this, "primaryOutputDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.commands = java.util.Objects.requireNonNull(builder.commands, "commands is required");
            this.additionalInputs = (java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer>)builder.additionalInputs;
            this.env = builder.env;
            this.envFromCfnOutputs = (java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput>)builder.envFromCfnOutputs;
            this.input = builder.input;
            this.installCommands = builder.installCommands;
            this.primaryOutputDirectory = builder.primaryOutputDirectory;
        }

        @Override
        public final java.util.List<java.lang.String> getCommands() {
            return this.commands;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer> getAdditionalInputs() {
            return this.additionalInputs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput> getEnvFromCfnOutputs() {
            return this.envFromCfnOutputs;
        }

        @Override
        public final software.amazon.awscdk.pipelines.IFileSetProducer getInput() {
            return this.input;
        }

        @Override
        public final java.util.List<java.lang.String> getInstallCommands() {
            return this.installCommands;
        }

        @Override
        public final java.lang.String getPrimaryOutputDirectory() {
            return this.primaryOutputDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("commands", om.valueToTree(this.getCommands()));
            if (this.getAdditionalInputs() != null) {
                data.set("additionalInputs", om.valueToTree(this.getAdditionalInputs()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvFromCfnOutputs() != null) {
                data.set("envFromCfnOutputs", om.valueToTree(this.getEnvFromCfnOutputs()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getInstallCommands() != null) {
                data.set("installCommands", om.valueToTree(this.getInstallCommands()));
            }
            if (this.getPrimaryOutputDirectory() != null) {
                data.set("primaryOutputDirectory", om.valueToTree(this.getPrimaryOutputDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.ShellStepProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ShellStepProps.Jsii$Proxy that = (ShellStepProps.Jsii$Proxy) o;

            if (!commands.equals(that.commands)) return false;
            if (this.additionalInputs != null ? !this.additionalInputs.equals(that.additionalInputs) : that.additionalInputs != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.envFromCfnOutputs != null ? !this.envFromCfnOutputs.equals(that.envFromCfnOutputs) : that.envFromCfnOutputs != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.installCommands != null ? !this.installCommands.equals(that.installCommands) : that.installCommands != null) return false;
            return this.primaryOutputDirectory != null ? this.primaryOutputDirectory.equals(that.primaryOutputDirectory) : that.primaryOutputDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.commands.hashCode();
            result = 31 * result + (this.additionalInputs != null ? this.additionalInputs.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.envFromCfnOutputs != null ? this.envFromCfnOutputs.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.installCommands != null ? this.installCommands.hashCode() : 0);
            result = 31 * result + (this.primaryOutputDirectory != null ? this.primaryOutputDirectory.hashCode() : 0);
            return result;
        }
    }
}
