package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties to initialize a new Route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi;
 * IHttpRouteAuthorizer httpRouteAuthorizer;
 * HttpRouteIntegration httpRouteIntegration;
 * HttpRouteKey httpRouteKey;
 * HttpRouteProps httpRouteProps = HttpRouteProps.builder()
 *         .httpApi(httpApi)
 *         .integration(httpRouteIntegration)
 *         .routeKey(httpRouteKey)
 *         // the properties below are optional
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizer(httpRouteAuthorizer)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:48.912Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpRouteProps")
@software.amazon.jsii.Jsii.Proxy(HttpRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpRouteProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.BatchHttpRouteOptions {

    /**
     * the API the route is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi();

    /**
     * The key to this route.
     * <p>
     * This is a combination of an HTTP method and an HTTP path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteKey getRouteKey();

    /**
     * The list of OIDC scopes to include in the authorization.
     * <p>
     * These scopes will be merged with the scopes from the attached authorizer
     * <p>
     * Default: - no additional authorization scopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return null;
    }

    /**
     * Authorizer for a WebSocket API or an HTTP API.
     * <p>
     * Default: - No authorizer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer getAuthorizer() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpRouteProps> {
        software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        software.amazon.awscdk.services.apigatewayv2.HttpRouteKey routeKey;
        java.util.List<java.lang.String> authorizationScopes;
        software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer authorizer;
        software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration;

        /**
         * Sets the value of {@link HttpRouteProps#getHttpApi}
         * @param httpApi the API the route is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpApi(software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            this.httpApi = httpApi;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteProps#getRouteKey}
         * @param routeKey The key to this route. This parameter is required.
         *                 This is a combination of an HTTP method and an HTTP path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeKey(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteProps#getAuthorizationScopes}
         * @param authorizationScopes The list of OIDC scopes to include in the authorization.
         *                            These scopes will be merged with the scopes from the attached authorizer
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteProps#getAuthorizer}
         * @param authorizer Authorizer for a WebSocket API or an HTTP API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteProps#getIntegration}
         * @param integration The integration to be configured on this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteProps {
        private final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        private final software.amazon.awscdk.services.apigatewayv2.HttpRouteKey routeKey;
        private final java.util.List<java.lang.String> authorizationScopes;
        private final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer authorizer;
        private final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpApi = software.amazon.jsii.Kernel.get(this, "httpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class));
            this.routeKey = software.amazon.jsii.Kernel.get(this, "routeKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteKey.class));
            this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer.class));
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpApi = java.util.Objects.requireNonNull(builder.httpApi, "httpApi is required");
            this.routeKey = java.util.Objects.requireNonNull(builder.routeKey, "routeKey is required");
            this.authorizationScopes = builder.authorizationScopes;
            this.authorizer = builder.authorizer;
            this.integration = java.util.Objects.requireNonNull(builder.integration, "integration is required");
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi() {
            return this.httpApi;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpRouteKey getRouteKey() {
            return this.routeKey;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration getIntegration() {
            return this.integration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpApi", om.valueToTree(this.getHttpApi()));
            data.set("routeKey", om.valueToTree(this.getRouteKey()));
            if (this.getAuthorizationScopes() != null) {
                data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
            }
            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }
            data.set("integration", om.valueToTree(this.getIntegration()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.HttpRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpRouteProps.Jsii$Proxy that = (HttpRouteProps.Jsii$Proxy) o;

            if (!httpApi.equals(that.httpApi)) return false;
            if (!routeKey.equals(that.routeKey)) return false;
            if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
            if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
            return this.integration.equals(that.integration);
        }

        @Override
        public final int hashCode() {
            int result = this.httpApi.hashCode();
            result = 31 * result + (this.routeKey.hashCode());
            result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            result = 31 * result + (this.integration.hashCode());
            return result;
        }
    }
}
