package software.amazon.awscdk.services.appconfig;

/**
 * Defines a parameter for an extension.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new LambdaDestination(fn))
 *                     .build()))
 *         .parameters(List.of(Parameter.required("testParam", "true"), Parameter.notRequired("testNotRequiredParam")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.076Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.Parameter")
public class Parameter extends software.amazon.jsii.JsiiObject {

    protected Parameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Parameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * An optional parameter for an extension.
     * <p>
     * @param name The name of the parameter. This parameter is required.
     * @param value The value of the parameter.
     * @param description A description for the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Parameter notRequired(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String value, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Parameter.class, "notRequired", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), value, description });
    }

    /**
     * An optional parameter for an extension.
     * <p>
     * @param name The name of the parameter. This parameter is required.
     * @param value The value of the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Parameter notRequired(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Parameter.class, "notRequired", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), value });
    }

    /**
     * An optional parameter for an extension.
     * <p>
     * @param name The name of the parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Parameter notRequired(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Parameter.class, "notRequired", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * A required parameter for an extension.
     * <p>
     * @param name The name of the parameter. This parameter is required.
     * @param value The value of the parameter. This parameter is required.
     * @param description A description for the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Parameter required(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Parameter.class, "required", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required"), description });
    }

    /**
     * A required parameter for an extension.
     * <p>
     * @param name The name of the parameter. This parameter is required.
     * @param value The value of the parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Parameter required(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Parameter.class, "required", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A boolean that indicates if the parameter is required or optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsRequired() {
        return software.amazon.jsii.Kernel.get(this, "isRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The name of the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The value of the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
