package software.amazon.awscdk.services.appintegrations;

/**
 * Properties for defining a <code>CfnDataIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appintegrations.*;
 * Object filters;
 * Object objectConfiguration;
 * CfnDataIntegrationProps cfnDataIntegrationProps = CfnDataIntegrationProps.builder()
 *         .kmsKey("kmsKey")
 *         .name("name")
 *         .sourceUri("sourceUri")
 *         // the properties below are optional
 *         .description("description")
 *         .fileConfiguration(FileConfigurationProperty.builder()
 *                 .folders(List.of("folders"))
 *                 // the properties below are optional
 *                 .filters(filters)
 *                 .build())
 *         .objectConfiguration(objectConfiguration)
 *         .scheduleConfig(ScheduleConfigProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 // the properties below are optional
 *                 .firstExecutionFrom("firstExecutionFrom")
 *                 .object("object")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.174Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appintegrations.CfnDataIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The KMS key for the DataIntegration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-kmskey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKmsKey();

    /**
     * The name of the DataIntegration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The URI of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-sourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-sourceuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceUri();

    /**
     * A description of the DataIntegration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The configuration for what files should be pulled from the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-fileconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-fileconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFileConfiguration() {
        return null;
    }

    /**
     * The configuration for what data should be pulled from the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-objectconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-objectconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getObjectConfiguration() {
        return null;
    }

    /**
     * The name of the data and how often it should be pulled from the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-scheduleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-scheduleconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScheduleConfig() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appintegrations-dataintegration.html#cfn-appintegrations-dataintegration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataIntegrationProps> {
        java.lang.String kmsKey;
        java.lang.String name;
        java.lang.String sourceUri;
        java.lang.String description;
        java.lang.Object fileConfiguration;
        java.lang.Object objectConfiguration;
        java.lang.Object scheduleConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getKmsKey}
         * @param kmsKey The KMS key for the DataIntegration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(java.lang.String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getName}
         * @param name The name of the DataIntegration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getSourceUri}
         * @param sourceUri The URI of the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceUri(java.lang.String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getDescription}
         * @param description A description of the DataIntegration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getFileConfiguration}
         * @param fileConfiguration The configuration for what files should be pulled from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileConfiguration(software.amazon.awscdk.IResolvable fileConfiguration) {
            this.fileConfiguration = fileConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getFileConfiguration}
         * @param fileConfiguration The configuration for what files should be pulled from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileConfiguration(software.amazon.awscdk.services.appintegrations.CfnDataIntegration.FileConfigurationProperty fileConfiguration) {
            this.fileConfiguration = fileConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getObjectConfiguration}
         * @param objectConfiguration The configuration for what data should be pulled from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectConfiguration(java.lang.Object objectConfiguration) {
            this.objectConfiguration = objectConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getScheduleConfig}
         * @param scheduleConfig The name of the data and how often it should be pulled from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleConfig(software.amazon.awscdk.IResolvable scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getScheduleConfig}
         * @param scheduleConfig The name of the data and how often it should be pulled from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleConfig(software.amazon.awscdk.services.appintegrations.CfnDataIntegration.ScheduleConfigProperty scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataIntegrationProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataIntegrationProps {
        private final java.lang.String kmsKey;
        private final java.lang.String name;
        private final java.lang.String sourceUri;
        private final java.lang.String description;
        private final java.lang.Object fileConfiguration;
        private final java.lang.Object objectConfiguration;
        private final java.lang.Object scheduleConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceUri = software.amazon.jsii.Kernel.get(this, "sourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileConfiguration = software.amazon.jsii.Kernel.get(this, "fileConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.objectConfiguration = software.amazon.jsii.Kernel.get(this, "objectConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scheduleConfig = software.amazon.jsii.Kernel.get(this, "scheduleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.kmsKey = java.util.Objects.requireNonNull(builder.kmsKey, "kmsKey is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.sourceUri = java.util.Objects.requireNonNull(builder.sourceUri, "sourceUri is required");
            this.description = builder.description;
            this.fileConfiguration = builder.fileConfiguration;
            this.objectConfiguration = builder.objectConfiguration;
            this.scheduleConfig = builder.scheduleConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSourceUri() {
            return this.sourceUri;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getFileConfiguration() {
            return this.fileConfiguration;
        }

        @Override
        public final java.lang.Object getObjectConfiguration() {
            return this.objectConfiguration;
        }

        @Override
        public final java.lang.Object getScheduleConfig() {
            return this.scheduleConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("sourceUri", om.valueToTree(this.getSourceUri()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFileConfiguration() != null) {
                data.set("fileConfiguration", om.valueToTree(this.getFileConfiguration()));
            }
            if (this.getObjectConfiguration() != null) {
                data.set("objectConfiguration", om.valueToTree(this.getObjectConfiguration()));
            }
            if (this.getScheduleConfig() != null) {
                data.set("scheduleConfig", om.valueToTree(this.getScheduleConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appintegrations.CfnDataIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataIntegrationProps.Jsii$Proxy that = (CfnDataIntegrationProps.Jsii$Proxy) o;

            if (!kmsKey.equals(that.kmsKey)) return false;
            if (!name.equals(that.name)) return false;
            if (!sourceUri.equals(that.sourceUri)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.fileConfiguration != null ? !this.fileConfiguration.equals(that.fileConfiguration) : that.fileConfiguration != null) return false;
            if (this.objectConfiguration != null ? !this.objectConfiguration.equals(that.objectConfiguration) : that.objectConfiguration != null) return false;
            if (this.scheduleConfig != null ? !this.scheduleConfig.equals(that.scheduleConfig) : that.scheduleConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.kmsKey.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.sourceUri.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.fileConfiguration != null ? this.fileConfiguration.hashCode() : 0);
            result = 31 * result + (this.objectConfiguration != null ? this.objectConfiguration.hashCode() : 0);
            result = 31 * result + (this.scheduleConfig != null ? this.scheduleConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
