package software.amazon.awscdk.services.applicationinsights;

/**
 * Properties for defining a <code>CfnApplication</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationinsights.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .resourceGroupName("resourceGroupName")
 *         // the properties below are optional
 *         .attachMissingPermission(false)
 *         .autoConfigurationEnabled(false)
 *         .componentMonitoringSettings(List.of(ComponentMonitoringSettingProperty.builder()
 *                 .componentConfigurationMode("componentConfigurationMode")
 *                 .tier("tier")
 *                 // the properties below are optional
 *                 .componentArn("componentArn")
 *                 .componentName("componentName")
 *                 .customComponentConfiguration(ComponentConfigurationProperty.builder()
 *                         .configurationDetails(ConfigurationDetailsProperty.builder()
 *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                         .alarmMetricName("alarmMetricName")
 *                                         .build()))
 *                                 .alarms(List.of(AlarmProperty.builder()
 *                                         .alarmName("alarmName")
 *                                         // the properties below are optional
 *                                         .severity("severity")
 *                                         .build()))
 *                                 .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
 *                                         .agreeToInstallHanadbClient(false)
 *                                         .hanaPort("hanaPort")
 *                                         .hanaSecretName("hanaSecretName")
 *                                         .hanasid("hanasid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
 *                                         .hostPort("hostPort")
 *                                         .jmxurl("jmxurl")
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .logs(List.of(LogProperty.builder()
 *                                         .logType("logType")
 *                                         // the properties below are optional
 *                                         .encoding("encoding")
 *                                         .logGroupName("logGroupName")
 *                                         .logPath("logPath")
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
 *                                         .instanceNumbers(List.of("instanceNumbers"))
 *                                         .sapsid("sapsid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .processes(List.of(ProcessProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .processName("processName")
 *                                         .build()))
 *                                 .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .sqlSecretName("sqlSecretName")
 *                                         .build())
 *                                 .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                         .eventLevels(List.of("eventLevels"))
 *                                         .eventName("eventName")
 *                                         .logGroupName("logGroupName")
 *                                         // the properties below are optional
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .build())
 *                         .subComponentTypeConfigurations(List.of(SubComponentTypeConfigurationProperty.builder()
 *                                 .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .logs(List.of(LogProperty.builder()
 *                                                 .logType("logType")
 *                                                 // the properties below are optional
 *                                                 .encoding("encoding")
 *                                                 .logGroupName("logGroupName")
 *                                                 .logPath("logPath")
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .processes(List.of(ProcessProperty.builder()
 *                                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                         .alarmMetricName("alarmMetricName")
 *                                                         .build()))
 *                                                 .processName("processName")
 *                                                 .build()))
 *                                         .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                                 .eventLevels(List.of("eventLevels"))
 *                                                 .eventName("eventName")
 *                                                 .logGroupName("logGroupName")
 *                                                 // the properties below are optional
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .build())
 *                                 .subComponentType("subComponentType")
 *                                 .build()))
 *                         .build())
 *                 .defaultOverwriteComponentConfiguration(ComponentConfigurationProperty.builder()
 *                         .configurationDetails(ConfigurationDetailsProperty.builder()
 *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                         .alarmMetricName("alarmMetricName")
 *                                         .build()))
 *                                 .alarms(List.of(AlarmProperty.builder()
 *                                         .alarmName("alarmName")
 *                                         // the properties below are optional
 *                                         .severity("severity")
 *                                         .build()))
 *                                 .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
 *                                         .agreeToInstallHanadbClient(false)
 *                                         .hanaPort("hanaPort")
 *                                         .hanaSecretName("hanaSecretName")
 *                                         .hanasid("hanasid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
 *                                         .hostPort("hostPort")
 *                                         .jmxurl("jmxurl")
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .logs(List.of(LogProperty.builder()
 *                                         .logType("logType")
 *                                         // the properties below are optional
 *                                         .encoding("encoding")
 *                                         .logGroupName("logGroupName")
 *                                         .logPath("logPath")
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
 *                                         .instanceNumbers(List.of("instanceNumbers"))
 *                                         .sapsid("sapsid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .processes(List.of(ProcessProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .processName("processName")
 *                                         .build()))
 *                                 .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .sqlSecretName("sqlSecretName")
 *                                         .build())
 *                                 .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                         .eventLevels(List.of("eventLevels"))
 *                                         .eventName("eventName")
 *                                         .logGroupName("logGroupName")
 *                                         // the properties below are optional
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .build())
 *                         .subComponentTypeConfigurations(List.of(SubComponentTypeConfigurationProperty.builder()
 *                                 .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .logs(List.of(LogProperty.builder()
 *                                                 .logType("logType")
 *                                                 // the properties below are optional
 *                                                 .encoding("encoding")
 *                                                 .logGroupName("logGroupName")
 *                                                 .logPath("logPath")
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .processes(List.of(ProcessProperty.builder()
 *                                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                         .alarmMetricName("alarmMetricName")
 *                                                         .build()))
 *                                                 .processName("processName")
 *                                                 .build()))
 *                                         .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                                 .eventLevels(List.of("eventLevels"))
 *                                                 .eventName("eventName")
 *                                                 .logGroupName("logGroupName")
 *                                                 // the properties below are optional
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .build())
 *                                 .subComponentType("subComponentType")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .customComponents(List.of(CustomComponentProperty.builder()
 *                 .componentName("componentName")
 *                 .resourceList(List.of("resourceList"))
 *                 .build()))
 *         .cweMonitorEnabled(false)
 *         .groupingType("groupingType")
 *         .logPatternSets(List.of(LogPatternSetProperty.builder()
 *                 .logPatterns(List.of(LogPatternProperty.builder()
 *                         .pattern("pattern")
 *                         .patternName("patternName")
 *                         .rank(123)
 *                         .build()))
 *                 .patternSetName("patternSetName")
 *                 .build()))
 *         .opsCenterEnabled(false)
 *         .opsItemSnsTopicArn("opsItemSnsTopicArn")
 *         .snsNotificationArn("snsNotificationArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.278Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the resource group used for the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceGroupName();

    /**
     * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-attachmissingpermission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-attachmissingpermission</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttachMissingPermission() {
        return null;
    }

    /**
     * If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoConfigurationEnabled() {
        return null;
    }

    /**
     * The monitoring settings of the components.
     * <p>
     * Not required to set up default monitoring for all components. To set up default monitoring for all components, set <code>AutoConfigurationEnabled</code> to <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComponentMonitoringSettings() {
        return null;
    }

    /**
     * Describes a custom component by grouping similar standalone instances to monitor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomComponents() {
        return null;
    }

    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCweMonitorEnabled() {
        return null;
    }

    /**
     * Application Insights can create applications based on a resource group or on an account.
     * <p>
     * To create an account-based application using all of the resources in the account, set this parameter to <code>ACCOUNT_BASED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-groupingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-groupingtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupingType() {
        return null;
    }

    /**
     * The log pattern sets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogPatternSets() {
        return null;
    }

    /**
     * Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpsCenterEnabled() {
        return null;
    }

    /**
     * The SNS topic provided to Application Insights that is associated with the created OpsItems to receive SNS notifications for opsItem updates.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOpsItemSnsTopicArn() {
        return null;
    }

    /**
     * The SNS topic ARN that is associated with SNS notifications for updates or issues.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-snsnotificationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-snsnotificationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnsNotificationArn() {
        return null;
    }

    /**
     * An array of <code>Tags</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String resourceGroupName;
        java.lang.Object attachMissingPermission;
        java.lang.Object autoConfigurationEnabled;
        java.lang.Object componentMonitoringSettings;
        java.lang.Object customComponents;
        java.lang.Object cweMonitorEnabled;
        java.lang.String groupingType;
        java.lang.Object logPatternSets;
        java.lang.Object opsCenterEnabled;
        java.lang.String opsItemSnsTopicArn;
        java.lang.String snsNotificationArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnApplicationProps#getResourceGroupName}
         * @param resourceGroupName The name of the resource group used for the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceGroupName(java.lang.String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAttachMissingPermission}
         * @param attachMissingPermission If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachMissingPermission(java.lang.Boolean attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAttachMissingPermission}
         * @param attachMissingPermission If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachMissingPermission(software.amazon.awscdk.IResolvable attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoConfigurationEnabled}
         * @param autoConfigurationEnabled If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoConfigurationEnabled(java.lang.Boolean autoConfigurationEnabled) {
            this.autoConfigurationEnabled = autoConfigurationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoConfigurationEnabled}
         * @param autoConfigurationEnabled If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoConfigurationEnabled(software.amazon.awscdk.IResolvable autoConfigurationEnabled) {
            this.autoConfigurationEnabled = autoConfigurationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getComponentMonitoringSettings}
         * @param componentMonitoringSettings The monitoring settings of the components.
         *                                    Not required to set up default monitoring for all components. To set up default monitoring for all components, set <code>AutoConfigurationEnabled</code> to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentMonitoringSettings(software.amazon.awscdk.IResolvable componentMonitoringSettings) {
            this.componentMonitoringSettings = componentMonitoringSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getComponentMonitoringSettings}
         * @param componentMonitoringSettings The monitoring settings of the components.
         *                                    Not required to set up default monitoring for all components. To set up default monitoring for all components, set <code>AutoConfigurationEnabled</code> to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentMonitoringSettings(java.util.List<? extends java.lang.Object> componentMonitoringSettings) {
            this.componentMonitoringSettings = componentMonitoringSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getCustomComponents}
         * @param customComponents Describes a custom component by grouping similar standalone instances to monitor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customComponents(software.amazon.awscdk.IResolvable customComponents) {
            this.customComponents = customComponents;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getCustomComponents}
         * @param customComponents Describes a custom component by grouping similar standalone instances to monitor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customComponents(java.util.List<? extends java.lang.Object> customComponents) {
            this.customComponents = customComponents;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getCweMonitorEnabled}
         * @param cweMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cweMonitorEnabled(java.lang.Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getCweMonitorEnabled}
         * @param cweMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cweMonitorEnabled(software.amazon.awscdk.IResolvable cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getGroupingType}
         * @param groupingType Application Insights can create applications based on a resource group or on an account.
         *                     To create an account-based application using all of the resources in the account, set this parameter to <code>ACCOUNT_BASED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingType(java.lang.String groupingType) {
            this.groupingType = groupingType;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getLogPatternSets}
         * @param logPatternSets The log pattern sets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPatternSets(software.amazon.awscdk.IResolvable logPatternSets) {
            this.logPatternSets = logPatternSets;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getLogPatternSets}
         * @param logPatternSets The log pattern sets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPatternSets(java.util.List<? extends java.lang.Object> logPatternSets) {
            this.logPatternSets = logPatternSets;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getOpsCenterEnabled}
         * @param opsCenterEnabled Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder opsCenterEnabled(java.lang.Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getOpsCenterEnabled}
         * @param opsCenterEnabled Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder opsCenterEnabled(software.amazon.awscdk.IResolvable opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getOpsItemSnsTopicArn}
         * @param opsItemSnsTopicArn The SNS topic provided to Application Insights that is associated with the created OpsItems to receive SNS notifications for opsItem updates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder opsItemSnsTopicArn(java.lang.String opsItemSnsTopicArn) {
            this.opsItemSnsTopicArn = opsItemSnsTopicArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getSnsNotificationArn}
         * @param snsNotificationArn The SNS topic ARN that is associated with SNS notifications for updates or issues.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsNotificationArn(java.lang.String snsNotificationArn) {
            this.snsNotificationArn = snsNotificationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags An array of <code>Tags</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String resourceGroupName;
        private final java.lang.Object attachMissingPermission;
        private final java.lang.Object autoConfigurationEnabled;
        private final java.lang.Object componentMonitoringSettings;
        private final java.lang.Object customComponents;
        private final java.lang.Object cweMonitorEnabled;
        private final java.lang.String groupingType;
        private final java.lang.Object logPatternSets;
        private final java.lang.Object opsCenterEnabled;
        private final java.lang.String opsItemSnsTopicArn;
        private final java.lang.String snsNotificationArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceGroupName = software.amazon.jsii.Kernel.get(this, "resourceGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attachMissingPermission = software.amazon.jsii.Kernel.get(this, "attachMissingPermission", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoConfigurationEnabled = software.amazon.jsii.Kernel.get(this, "autoConfigurationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.componentMonitoringSettings = software.amazon.jsii.Kernel.get(this, "componentMonitoringSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customComponents = software.amazon.jsii.Kernel.get(this, "customComponents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cweMonitorEnabled = software.amazon.jsii.Kernel.get(this, "cweMonitorEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.groupingType = software.amazon.jsii.Kernel.get(this, "groupingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logPatternSets = software.amazon.jsii.Kernel.get(this, "logPatternSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.opsCenterEnabled = software.amazon.jsii.Kernel.get(this, "opsCenterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.opsItemSnsTopicArn = software.amazon.jsii.Kernel.get(this, "opsItemSnsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snsNotificationArn = software.amazon.jsii.Kernel.get(this, "snsNotificationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceGroupName = java.util.Objects.requireNonNull(builder.resourceGroupName, "resourceGroupName is required");
            this.attachMissingPermission = builder.attachMissingPermission;
            this.autoConfigurationEnabled = builder.autoConfigurationEnabled;
            this.componentMonitoringSettings = builder.componentMonitoringSettings;
            this.customComponents = builder.customComponents;
            this.cweMonitorEnabled = builder.cweMonitorEnabled;
            this.groupingType = builder.groupingType;
            this.logPatternSets = builder.logPatternSets;
            this.opsCenterEnabled = builder.opsCenterEnabled;
            this.opsItemSnsTopicArn = builder.opsItemSnsTopicArn;
            this.snsNotificationArn = builder.snsNotificationArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getResourceGroupName() {
            return this.resourceGroupName;
        }

        @Override
        public final java.lang.Object getAttachMissingPermission() {
            return this.attachMissingPermission;
        }

        @Override
        public final java.lang.Object getAutoConfigurationEnabled() {
            return this.autoConfigurationEnabled;
        }

        @Override
        public final java.lang.Object getComponentMonitoringSettings() {
            return this.componentMonitoringSettings;
        }

        @Override
        public final java.lang.Object getCustomComponents() {
            return this.customComponents;
        }

        @Override
        public final java.lang.Object getCweMonitorEnabled() {
            return this.cweMonitorEnabled;
        }

        @Override
        public final java.lang.String getGroupingType() {
            return this.groupingType;
        }

        @Override
        public final java.lang.Object getLogPatternSets() {
            return this.logPatternSets;
        }

        @Override
        public final java.lang.Object getOpsCenterEnabled() {
            return this.opsCenterEnabled;
        }

        @Override
        public final java.lang.String getOpsItemSnsTopicArn() {
            return this.opsItemSnsTopicArn;
        }

        @Override
        public final java.lang.String getSnsNotificationArn() {
            return this.snsNotificationArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceGroupName", om.valueToTree(this.getResourceGroupName()));
            if (this.getAttachMissingPermission() != null) {
                data.set("attachMissingPermission", om.valueToTree(this.getAttachMissingPermission()));
            }
            if (this.getAutoConfigurationEnabled() != null) {
                data.set("autoConfigurationEnabled", om.valueToTree(this.getAutoConfigurationEnabled()));
            }
            if (this.getComponentMonitoringSettings() != null) {
                data.set("componentMonitoringSettings", om.valueToTree(this.getComponentMonitoringSettings()));
            }
            if (this.getCustomComponents() != null) {
                data.set("customComponents", om.valueToTree(this.getCustomComponents()));
            }
            if (this.getCweMonitorEnabled() != null) {
                data.set("cweMonitorEnabled", om.valueToTree(this.getCweMonitorEnabled()));
            }
            if (this.getGroupingType() != null) {
                data.set("groupingType", om.valueToTree(this.getGroupingType()));
            }
            if (this.getLogPatternSets() != null) {
                data.set("logPatternSets", om.valueToTree(this.getLogPatternSets()));
            }
            if (this.getOpsCenterEnabled() != null) {
                data.set("opsCenterEnabled", om.valueToTree(this.getOpsCenterEnabled()));
            }
            if (this.getOpsItemSnsTopicArn() != null) {
                data.set("opsItemSnsTopicArn", om.valueToTree(this.getOpsItemSnsTopicArn()));
            }
            if (this.getSnsNotificationArn() != null) {
                data.set("snsNotificationArn", om.valueToTree(this.getSnsNotificationArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!resourceGroupName.equals(that.resourceGroupName)) return false;
            if (this.attachMissingPermission != null ? !this.attachMissingPermission.equals(that.attachMissingPermission) : that.attachMissingPermission != null) return false;
            if (this.autoConfigurationEnabled != null ? !this.autoConfigurationEnabled.equals(that.autoConfigurationEnabled) : that.autoConfigurationEnabled != null) return false;
            if (this.componentMonitoringSettings != null ? !this.componentMonitoringSettings.equals(that.componentMonitoringSettings) : that.componentMonitoringSettings != null) return false;
            if (this.customComponents != null ? !this.customComponents.equals(that.customComponents) : that.customComponents != null) return false;
            if (this.cweMonitorEnabled != null ? !this.cweMonitorEnabled.equals(that.cweMonitorEnabled) : that.cweMonitorEnabled != null) return false;
            if (this.groupingType != null ? !this.groupingType.equals(that.groupingType) : that.groupingType != null) return false;
            if (this.logPatternSets != null ? !this.logPatternSets.equals(that.logPatternSets) : that.logPatternSets != null) return false;
            if (this.opsCenterEnabled != null ? !this.opsCenterEnabled.equals(that.opsCenterEnabled) : that.opsCenterEnabled != null) return false;
            if (this.opsItemSnsTopicArn != null ? !this.opsItemSnsTopicArn.equals(that.opsItemSnsTopicArn) : that.opsItemSnsTopicArn != null) return false;
            if (this.snsNotificationArn != null ? !this.snsNotificationArn.equals(that.snsNotificationArn) : that.snsNotificationArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceGroupName.hashCode();
            result = 31 * result + (this.attachMissingPermission != null ? this.attachMissingPermission.hashCode() : 0);
            result = 31 * result + (this.autoConfigurationEnabled != null ? this.autoConfigurationEnabled.hashCode() : 0);
            result = 31 * result + (this.componentMonitoringSettings != null ? this.componentMonitoringSettings.hashCode() : 0);
            result = 31 * result + (this.customComponents != null ? this.customComponents.hashCode() : 0);
            result = 31 * result + (this.cweMonitorEnabled != null ? this.cweMonitorEnabled.hashCode() : 0);
            result = 31 * result + (this.groupingType != null ? this.groupingType.hashCode() : 0);
            result = 31 * result + (this.logPatternSets != null ? this.logPatternSets.hashCode() : 0);
            result = 31 * result + (this.opsCenterEnabled != null ? this.opsCenterEnabled.hashCode() : 0);
            result = 31 * result + (this.opsItemSnsTopicArn != null ? this.opsItemSnsTopicArn.hashCode() : 0);
            result = 31 * result + (this.snsNotificationArn != null ? this.snsNotificationArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
