package software.amazon.awscdk.services.appmesh;

/**
 * Options used for creating the Health Check object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * HealthCheckBindOptions healthCheckBindOptions = HealthCheckBindOptions.builder()
 *         .defaultPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.451Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HealthCheckBindOptions")
@software.amazon.jsii.Jsii.Proxy(HealthCheckBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HealthCheckBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Port for Health Check interface.
     * <p>
     * Default: - no default port is provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HealthCheckBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HealthCheckBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HealthCheckBindOptions> {
        java.lang.Number defaultPort;

        /**
         * Sets the value of {@link HealthCheckBindOptions#getDefaultPort}
         * @param defaultPort Port for Health Check interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(java.lang.Number defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthCheckBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HealthCheckBindOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HealthCheckBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckBindOptions {
        private final java.lang.Number defaultPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultPort = software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultPort = builder.defaultPort;
        }

        @Override
        public final java.lang.Number getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefaultPort() != null) {
                data.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.HealthCheckBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HealthCheckBindOptions.Jsii$Proxy that = (HealthCheckBindOptions.Jsii$Proxy) o;

            return this.defaultPort != null ? this.defaultPort.equals(that.defaultPort) : that.defaultPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultPort != null ? this.defaultPort.hashCode() : 0;
            return result;
        }
    }
}
