package software.amazon.awscdk.services.appmesh;

/**
 * The criterion for determining a request match for this GatewayRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualGateway gateway;
 * VirtualService virtualService;
 * gateway.addGatewayRoute("gateway-route-http-2", GatewayRouteBaseProps.builder()
 *         .routeSpec(GatewayRouteSpec.http(HttpGatewayRouteSpecOptions.builder()
 *                 .routeTarget(virtualService)
 *                 .match(HttpGatewayRouteMatch.builder()
 *                         // This rewrites the path from '/test' to '/rewrittenPath'.
 *                         .path(HttpGatewayRoutePathMatch.exactly("/test", "/rewrittenPath"))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.454Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpGatewayRouteMatch")
@software.amazon.jsii.Jsii.Proxy(HttpGatewayRouteMatch.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpGatewayRouteMatch extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the client request headers to match on.
     * <p>
     * All specified headers
     * must match for the gateway route to match.
     * <p>
     * Default: - do not match on headers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getHeaders() {
        return null;
    }

    /**
     * The gateway route host name to be matched on.
     * <p>
     * Default: - do not match on host name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch getHostname() {
        return null;
    }

    /**
     * The method to match on.
     * <p>
     * Default: - do not match on method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpRouteMethod getMethod() {
        return null;
    }

    /**
     * Specify how to match requests based on the 'path' part of their URL.
     * <p>
     * Default: - matches requests with any path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch getPath() {
        return null;
    }

    /**
     * The port number to match on.
     * <p>
     * Default: - no default port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The query parameters to match on.
     * <p>
     * All specified query parameters must match for the route to match.
     * <p>
     * Default: - do not match on query parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> getQueryParameters() {
        return null;
    }

    /**
     * When <code>true</code>, rewrites the original request received at the Virtual Gateway to the destination Virtual Service name.
     * <p>
     * When <code>false</code>, retains the original hostname from the request.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRewriteRequestHostname() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpGatewayRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpGatewayRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRouteMatch> {
        java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> headers;
        software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch hostname;
        software.amazon.awscdk.services.appmesh.HttpRouteMethod method;
        software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch path;
        java.lang.Number port;
        java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> queryParameters;
        java.lang.Boolean rewriteRequestHostname;

        /**
         * Sets the value of {@link HttpGatewayRouteMatch#getHeaders}
         * @param headers Specifies the client request headers to match on.
         *                All specified headers
         *                must match for the gateway route to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder headers(java.util.List<? extends software.amazon.awscdk.services.appmesh.HeaderMatch> headers) {
            this.headers = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)headers;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRouteMatch#getHostname}
         * @param hostname The gateway route host name to be matched on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRouteMatch#getMethod}
         * @param method The method to match on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.appmesh.HttpRouteMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRouteMatch#getPath}
         * @param path Specify how to match requests based on the 'path' part of their URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRouteMatch#getPort}
         * @param port The port number to match on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRouteMatch#getQueryParameters}
         * @param queryParameters The query parameters to match on.
         *                        All specified query parameters must match for the route to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder queryParameters(java.util.List<? extends software.amazon.awscdk.services.appmesh.QueryParameterMatch> queryParameters) {
            this.queryParameters = (java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch>)queryParameters;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRouteMatch#getRewriteRequestHostname}
         * @param rewriteRequestHostname When <code>true</code>, rewrites the original request received at the Virtual Gateway to the destination Virtual Service name.
         *                               When <code>false</code>, retains the original hostname from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rewriteRequestHostname(java.lang.Boolean rewriteRequestHostname) {
            this.rewriteRequestHostname = rewriteRequestHostname;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpGatewayRouteMatch}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpGatewayRouteMatch build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpGatewayRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRouteMatch {
        private final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> headers;
        private final software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch hostname;
        private final software.amazon.awscdk.services.appmesh.HttpRouteMethod method;
        private final software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch path;
        private final java.lang.Number port;
        private final java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> queryParameters;
        private final java.lang.Boolean rewriteRequestHostname;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class)));
            this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch.class));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRouteMethod.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.QueryParameterMatch.class)));
            this.rewriteRequestHostname = software.amazon.jsii.Kernel.get(this, "rewriteRequestHostname", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.headers = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)builder.headers;
            this.hostname = builder.hostname;
            this.method = builder.method;
            this.path = builder.path;
            this.port = builder.port;
            this.queryParameters = (java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch>)builder.queryParameters;
            this.rewriteRequestHostname = builder.rewriteRequestHostname;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getHeaders() {
            return this.headers;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch getHostname() {
            return this.hostname;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HttpRouteMethod getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch getPath() {
            return this.path;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        public final java.lang.Boolean getRewriteRequestHostname() {
            return this.rewriteRequestHostname;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHeaders() != null) {
                data.set("headers", om.valueToTree(this.getHeaders()));
            }
            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getQueryParameters() != null) {
                data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
            }
            if (this.getRewriteRequestHostname() != null) {
                data.set("rewriteRequestHostname", om.valueToTree(this.getRewriteRequestHostname()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.HttpGatewayRouteMatch"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpGatewayRouteMatch.Jsii$Proxy that = (HttpGatewayRouteMatch.Jsii$Proxy) o;

            if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.queryParameters != null ? !this.queryParameters.equals(that.queryParameters) : that.queryParameters != null) return false;
            return this.rewriteRequestHostname != null ? this.rewriteRequestHostname.equals(that.rewriteRequestHostname) : that.rewriteRequestHostname == null;
        }

        @Override
        public final int hashCode() {
            int result = this.headers != null ? this.headers.hashCode() : 0;
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
            result = 31 * result + (this.rewriteRequestHostname != null ? this.rewriteRequestHostname.hashCode() : 0);
            return result;
        }
    }
}
