package software.amazon.awscdk.services.appmesh;

/**
 * Represents TLS properties for listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // A Virtual Node with listener TLS from an ACM provided certificate
 * Certificate cert;
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node"))
 *         .listeners(List.of(VirtualNodeListener.grpc(GrpcVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.acm(cert))
 *                         .build())
 *                 .build())))
 *         .build();
 * // A Virtual Gateway with listener TLS from a customer provided file certificate
 * VirtualGateway gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.grpc(GrpcGatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.file("path/to/certChain", "path/to/privateKey"))
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway")
 *         .build();
 * // A Virtual Gateway with listener TLS from a SDS provided certificate
 * VirtualGateway gateway2 = VirtualGateway.Builder.create(this, "gateway2")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.http2(Http2GatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.sds("secrete_certificate"))
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway2")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.481Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.ListenerTlsOptions")
@software.amazon.jsii.Jsii.Proxy(ListenerTlsOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ListenerTlsOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Represents TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsCertificate getCertificate();

    /**
     * The TLS mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsMode getMode();

    /**
     * Represents a listener's TLS validation context.
     * <p>
     * The client certificate will only be validated if the client provides it, enabling mutual TLS.
     * <p>
     * Default: - client TLS certificate is not required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.MutualTlsValidation getMutualTlsValidation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ListenerTlsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ListenerTlsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsOptions> {
        software.amazon.awscdk.services.appmesh.TlsCertificate certificate;
        software.amazon.awscdk.services.appmesh.TlsMode mode;
        software.amazon.awscdk.services.appmesh.MutualTlsValidation mutualTlsValidation;

        /**
         * Sets the value of {@link ListenerTlsOptions#getCertificate}
         * @param certificate Represents TLS certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.appmesh.TlsCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link ListenerTlsOptions#getMode}
         * @param mode The TLS mode. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(software.amazon.awscdk.services.appmesh.TlsMode mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link ListenerTlsOptions#getMutualTlsValidation}
         * @param mutualTlsValidation Represents a listener's TLS validation context.
         *                            The client certificate will only be validated if the client provides it, enabling mutual TLS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsValidation(software.amazon.awscdk.services.appmesh.MutualTlsValidation mutualTlsValidation) {
            this.mutualTlsValidation = mutualTlsValidation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ListenerTlsOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ListenerTlsOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ListenerTlsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsOptions {
        private final software.amazon.awscdk.services.appmesh.TlsCertificate certificate;
        private final software.amazon.awscdk.services.appmesh.TlsMode mode;
        private final software.amazon.awscdk.services.appmesh.MutualTlsValidation mutualTlsValidation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsCertificate.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsMode.class));
            this.mutualTlsValidation = software.amazon.jsii.Kernel.get(this, "mutualTlsValidation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MutualTlsValidation.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = java.util.Objects.requireNonNull(builder.certificate, "certificate is required");
            this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
            this.mutualTlsValidation = builder.mutualTlsValidation;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.TlsCertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.TlsMode getMode() {
            return this.mode;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.MutualTlsValidation getMutualTlsValidation() {
            return this.mutualTlsValidation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificate", om.valueToTree(this.getCertificate()));
            data.set("mode", om.valueToTree(this.getMode()));
            if (this.getMutualTlsValidation() != null) {
                data.set("mutualTlsValidation", om.valueToTree(this.getMutualTlsValidation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.ListenerTlsOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ListenerTlsOptions.Jsii$Proxy that = (ListenerTlsOptions.Jsii$Proxy) o;

            if (!certificate.equals(that.certificate)) return false;
            if (!mode.equals(that.mode)) return false;
            return this.mutualTlsValidation != null ? this.mutualTlsValidation.equals(that.mutualTlsValidation) : that.mutualTlsValidation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificate.hashCode();
            result = 31 * result + (this.mode.hashCode());
            result = 31 * result + (this.mutualTlsValidation != null ? this.mutualTlsValidation.hashCode() : 0);
            return result;
        }
    }
}
