package software.amazon.awscdk.services.appsync;

/**
 * enum with all possible values for AppSync authorization type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.appsync.*;
 * IGraphqlApi api = GraphqlApi.fromGraphqlApiAttributes(this, "ImportedAPI", GraphqlApiAttributes.builder()
 *         .graphqlApiId("&lt;api-id&gt;")
 *         .graphqlApiArn("&lt;api-arn&gt;")
 *         .graphQLEndpointArn("&lt;api-endpoint-arn&gt;")
 *         .visibility(Visibility.GLOBAL)
 *         .modes(List.of(AuthorizationType.IAM))
 *         .build());
 * Rule rule = Rule.Builder.create(this, "Rule").schedule(Schedule.rate(Duration.minutes(1))).build();
 * Role role = Role.Builder.create(this, "Role").assumedBy(new ServicePrincipal("events.amazonaws.com")).build();
 * // allow EventBridge to use the `publish` mutation
 * api.grantMutation(role, "publish");
 * rule.addTarget(AppSync.Builder.create(api)
 *         .graphQLOperation("mutation Publish($message: String!){ publish(message: $message) { message } }")
 *         .variables(RuleTargetInput.fromObject(Map.of(
 *                 "message", "hello world")))
 *         .eventRole(role)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AuthorizationType")
public enum AuthorizationType {
    /**
     * API Key authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API_KEY,
    /**
     * AWS IAM authorization type.
     * <p>
     * Can be used with Cognito Identity Pool federated credentials
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IAM,
    /**
     * Cognito User Pool authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    USER_POOL,
    /**
     * OpenID Connect authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OIDC,
    /**
     * Lambda authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
}
