package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnApi</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnApiProps cfnApiProps = CfnApiProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .eventConfig(EventConfigProperty.builder()
 *                 .authProviders(List.of(AuthProviderProperty.builder()
 *                         .authType("authType")
 *                         // the properties below are optional
 *                         .cognitoConfig(CognitoConfigProperty.builder()
 *                                 .awsRegion("awsRegion")
 *                                 .userPoolId("userPoolId")
 *                                 // the properties below are optional
 *                                 .appIdClientRegex("appIdClientRegex")
 *                                 .build())
 *                         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                                 .authorizerUri("authorizerUri")
 *                                 // the properties below are optional
 *                                 .authorizerResultTtlInSeconds(123)
 *                                 .identityValidationExpression("identityValidationExpression")
 *                                 .build())
 *                         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                                 .issuer("issuer")
 *                                 // the properties below are optional
 *                                 .authTtl(123)
 *                                 .clientId("clientId")
 *                                 .iatTtl(123)
 *                                 .build())
 *                         .build()))
 *                 .connectionAuthModes(List.of(AuthModeProperty.builder()
 *                         .authType("authType")
 *                         .build()))
 *                 .defaultPublishAuthModes(List.of(AuthModeProperty.builder()
 *                         .authType("authType")
 *                         .build()))
 *                 .defaultSubscribeAuthModes(List.of(AuthModeProperty.builder()
 *                         .authType("authType")
 *                         .build()))
 *                 // the properties below are optional
 *                 .logConfig(EventLogConfigProperty.builder()
 *                         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .build())
 *         .ownerContact("ownerContact")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.653Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the <code>Api</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-eventconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-eventconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventConfig() {
        return null;
    }

    /**
     * The owner contact information for an API resource.
     * <p>
     * This field accepts any string input with a length of 0 - 256 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-ownercontact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-ownercontact</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerContact() {
        return null;
    }

    /**
     * A set of tags (key-value pairs) for this API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApiProps> {
        java.lang.String name;
        java.lang.Object eventConfig;
        java.lang.String ownerContact;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnApiProps#getName}
         * @param name The name of the <code>Api</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getEventConfig}
         * @param eventConfig Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventConfig(software.amazon.awscdk.IResolvable eventConfig) {
            this.eventConfig = eventConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getEventConfig}
         * @param eventConfig Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventConfig(software.amazon.awscdk.services.appsync.CfnApi.EventConfigProperty eventConfig) {
            this.eventConfig = eventConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getOwnerContact}
         * @param ownerContact The owner contact information for an API resource.
         *                     This field accepts any string input with a length of 0 - 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerContact(java.lang.String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getTags}
         * @param tags A set of tags (key-value pairs) for this API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApiProps {
        private final java.lang.String name;
        private final java.lang.Object eventConfig;
        private final java.lang.String ownerContact;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventConfig = software.amazon.jsii.Kernel.get(this, "eventConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ownerContact = software.amazon.jsii.Kernel.get(this, "ownerContact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.eventConfig = builder.eventConfig;
            this.ownerContact = builder.ownerContact;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getEventConfig() {
            return this.eventConfig;
        }

        @Override
        public final java.lang.String getOwnerContact() {
            return this.ownerContact;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getEventConfig() != null) {
                data.set("eventConfig", om.valueToTree(this.getEventConfig()));
            }
            if (this.getOwnerContact() != null) {
                data.set("ownerContact", om.valueToTree(this.getOwnerContact()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApiProps.Jsii$Proxy that = (CfnApiProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.eventConfig != null ? !this.eventConfig.equals(that.eventConfig) : that.eventConfig != null) return false;
            if (this.ownerContact != null ? !this.ownerContact.equals(that.ownerContact) : that.ownerContact != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.eventConfig != null ? this.eventConfig.hashCode() : 0);
            result = 31 * result + (this.ownerContact != null ? this.ownerContact.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
