package software.amazon.awscdk.services.appsync;

/**
 * An AppSync Event API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * AppSyncAuthProvider apiKeyProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.API_KEY)
 *         .build();
 * EventApi api = EventApi.Builder.create(this, "api")
 *         .apiName("Api")
 *         .ownerContact("OwnerContact")
 *         .authorizationConfig(EventApiAuthConfig.builder()
 *                 .authProviders(List.of(apiKeyProvider))
 *                 .connectionAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultPublishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultSubscribeAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .build())
 *         .logConfig(AppSyncLogConfig.builder()
 *                 .fieldLogLevel(AppSyncFieldLogLevel.INFO)
 *                 .retention(RetentionDays.ONE_WEEK)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.708Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.EventApi")
public class EventApi extends software.amazon.awscdk.services.appsync.EventApiBase {

    protected EventApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a Event API through this function.
     * <p>
     * @param scope scope. This parameter is required.
     * @param id id. This parameter is required.
     * @param attrs Event API Attributes of an API. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IEventApi fromEventApiAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventApiAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.EventApi.class, "fromEventApiAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IEventApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * the ARN of the API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiArn() {
        return software.amazon.jsii.Kernel.get(this, "apiArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * an unique AWS AppSync Event API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the configured API keys, if present.
     * <p>
     * Default: - no api key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.CfnApiKey> getApiKeys() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "apiKeys", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CfnApiKey.class))));
    }

    /**
     * The AppSyncDomainName of the associated custom domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppSyncDomainName() {
        return software.amazon.jsii.Kernel.get(this, "appSyncDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Authorization Types for this Event Api.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getAuthProviderTypes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "authProviderTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class))));
    }

    /**
     * The connection auth modes for this Event Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getConnectionModeTypes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "connectionModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class))));
    }

    /**
     * The HTTP Endpoint of the associated custom domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomHttpEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "customHttpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Realtime Endpoint of the associated custom domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomRealtimeEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "customRealtimeEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default publish auth modes for this Event Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getDefaultPublishModeTypes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "defaultPublishModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class))));
    }

    /**
     * The default subscribe auth modes for this Event Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getDefaultSubscribeModeTypes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "defaultSubscribeModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class))));
    }

    /**
     * the domain name of the Api's HTTP endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHttpDns() {
        return software.amazon.jsii.Kernel.get(this, "httpDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the CloudWatch Log Group for this API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * the domain name of the Api's real-time endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRealtimeDns() {
        return software.amazon.jsii.Kernel.get(this, "realtimeDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.EventApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.EventApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.EventApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.EventApiProps.Builder();
        }

        /**
         * the name of the Event API.
         * <p>
         * @return {@code this}
         * @param apiName the name of the Event API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiName(final java.lang.String apiName) {
            this.props.apiName(apiName);
            return this;
        }

        /**
         * Optional authorization configuration.
         * <p>
         * Default: - API Key authorization
         * <p>
         * @return {@code this}
         * @param authorizationConfig Optional authorization configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(final software.amazon.awscdk.services.appsync.EventApiAuthConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        /**
         * The domain name configuration for the Event API.
         * <p>
         * The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
         * enable custom domain URL
         * <p>
         * Default: - no domain name
         * <p>
         * @return {@code this}
         * @param domainName The domain name configuration for the Event API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final software.amazon.awscdk.services.appsync.AppSyncDomainOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Logging configuration for this api.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param logConfig Logging configuration for this api. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.services.appsync.AppSyncLogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        /**
         * The owner contact information for an API resource.
         * <p>
         * This field accepts any string input with a length of 0 - 256 characters.
         * <p>
         * Default: - No owner contact.
         * <p>
         * @return {@code this}
         * @param ownerContact The owner contact information for an API resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerContact(final java.lang.String ownerContact) {
            this.props.ownerContact(ownerContact);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.EventApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.EventApi build() {
            return new software.amazon.awscdk.services.appsync.EventApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
