package software.amazon.awscdk.services.appsync;

/**
 * Interface for Event API.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.735Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.IEventApi")
@software.amazon.jsii.Jsii.Proxy(IEventApi.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEventApi extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.IApi {

    /**
     * The Authorization Types for this Event Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getAuthProviderTypes();

    /**
     * The domain name of the Api's HTTP endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpDns();

    /**
     * The domain name of the Api's real-time endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRealtimeDns();

    /**
     * add a new channel namespace.
     * <p>
     * @return the channel namespace
     * @param id the id of the channel namespace. This parameter is required.
     * @param options the options for the channel namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ChannelNamespace addChannelNamespace(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ChannelNamespaceOptions options);

    /**
     * add a new channel namespace.
     * <p>
     * @return the channel namespace
     * @param id the id of the channel namespace. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ChannelNamespace addChannelNamespace(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Adds an IAM policy statement associated with this Event API to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/EventApiId/...). This parameter is required.
     * @param actions The actions that should be granted to the principal (i.e. appsync:EventPublish ). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncEventResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions);

    /**
     * Adds an IAM policy statement for EventConnect access to this EventApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Adds an IAM policy statement for EventPublish access to this EventApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublish(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Adds an IAM policy statement to publish and subscribe to this API for an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublishAndSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Adds an IAM policy statement for EventSubscribe access to this EventApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appsync.IEventApi.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of the AWS AppSync Api.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getApiArn() {
            return software.amazon.jsii.Kernel.get(this, "apiArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The unique identifier for the AWS AppSync Api generated by the service.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
            return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Authorization Types for this Event Api.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getAuthProviderTypes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "authProviderTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class))));
        }

        /**
         * The domain name of the Api's HTTP endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getHttpDns() {
            return software.amazon.jsii.Kernel.get(this, "httpDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The domain name of the Api's real-time endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getRealtimeDns() {
            return software.amazon.jsii.Kernel.get(this, "realtimeDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * add a new channel namespace.
         * <p>
         * @return the channel namespace
         * @param id the id of the channel namespace. This parameter is required.
         * @param options the options for the channel namespace.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ChannelNamespace addChannelNamespace(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ChannelNamespaceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addChannelNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ChannelNamespace.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * add a new channel namespace.
         * <p>
         * @return the channel namespace
         * @param id the id of the channel namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ChannelNamespace addChannelNamespace(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "addChannelNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ChannelNamespace.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Adds an IAM policy statement associated with this Event API to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/EventApiId/...). This parameter is required.
         * @param actions The actions that should be granted to the principal (i.e. appsync:EventPublish ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncEventResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(resources, "resources is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for EventConnect access to this EventApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an IAM policy statement for EventPublish access to this EventApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublish(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPublish", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an IAM policy statement to publish and subscribe to this API for an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublishAndSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPublishAndSubscribe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an IAM policy statement for EventSubscribe access to this EventApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantSubscribe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEventApi}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEventApi, software.amazon.awscdk.services.appsync.IApi.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of the AWS AppSync Api.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getApiArn() {
            return software.amazon.jsii.Kernel.get(this, "apiArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The unique identifier for the AWS AppSync Api generated by the service.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
            return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Authorization Types for this Event Api.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getAuthProviderTypes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "authProviderTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class))));
        }

        /**
         * The domain name of the Api's HTTP endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getHttpDns() {
            return software.amazon.jsii.Kernel.get(this, "httpDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The domain name of the Api's real-time endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getRealtimeDns() {
            return software.amazon.jsii.Kernel.get(this, "realtimeDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * add a new channel namespace.
         * <p>
         * @return the channel namespace
         * @param id the id of the channel namespace. This parameter is required.
         * @param options the options for the channel namespace.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ChannelNamespace addChannelNamespace(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ChannelNamespaceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addChannelNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ChannelNamespace.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Adds an IAM policy statement associated with this Event API to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/EventApiId/...). This parameter is required.
         * @param actions The actions that should be granted to the principal (i.e. appsync:EventPublish ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncEventResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(resources, "resources is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for EventConnect access to this EventApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an IAM policy statement for EventPublish access to this EventApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublish(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPublish", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an IAM policy statement to publish and subscribe to this API for an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublishAndSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPublishAndSubscribe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an IAM policy statement for EventSubscribe access to this EventApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantSubscribe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }
}
