package software.amazon.awscdk.services.appsync;

/**
 * Interface for GraphQL.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.737Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.IGraphqlApi")
@software.amazon.jsii.Jsii.Proxy(IGraphqlApi.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IGraphqlApi extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource {

    /**
     * an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * the ARN of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * The GraphQL endpoint ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGraphQLEndpointArn();

    /**
     * The Authorization Types for this GraphQL Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> getModes();

    /**
     * the visibility of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Visibility getVisibility();

    /**
     * add a new DynamoDB data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param table The DynamoDB table backing this data source. This parameter is required.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.DynamoDbDataSource addDynamoDbDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable table, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * add a new DynamoDB data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param table The DynamoDB table backing this data source. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.DynamoDbDataSource addDynamoDbDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable table);

    /**
     * (deprecated) add a new elasticsearch data source to this API.
     * <p>
     * @deprecated <ul>
     * <li>use <code>addOpenSearchDataSource</code></li>
     * </ul>
     * @param id The data source's id. This parameter is required.
     * @param domain The elasticsearch domain for this data source. This parameter is required.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ElasticsearchDataSource addElasticsearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.IDomain domain, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * (deprecated) add a new elasticsearch data source to this API.
     * <p>
     * @deprecated <ul>
     * <li>use <code>addOpenSearchDataSource</code></li>
     * </ul>
     * @param id The data source's id. This parameter is required.
     * @param domain The elasticsearch domain for this data source. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ElasticsearchDataSource addElasticsearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.IDomain domain);

    /**
     * Add an EventBridge data source to this api.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param eventBus The EventBridge EventBus on which to put events. This parameter is required.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventBridgeDataSource addEventBridgeDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus eventBus, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * Add an EventBridge data source to this api.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param eventBus The EventBridge EventBus on which to put events. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventBridgeDataSource addEventBridgeDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus eventBus);

    /**
     * add a new http data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param endpoint The http endpoint. This parameter is required.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.HttpDataSource addHttpDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String endpoint, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.HttpDataSourceOptions options);

    /**
     * add a new http data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param endpoint The http endpoint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.HttpDataSource addHttpDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String endpoint);

    /**
     * add a new Lambda data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param lambdaFunction The Lambda function to call to interact with this data source. This parameter is required.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.LambdaDataSource addLambdaDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * add a new Lambda data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param lambdaFunction The Lambda function to call to interact with this data source. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.LambdaDataSource addLambdaDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction);

    /**
     * add a new dummy data source to this API.
     * <p>
     * Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.NoneDataSource addNoneDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * add a new dummy data source to this API.
     * <p>
     * Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     * <p>
     * @param id The data source's id. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.NoneDataSource addNoneDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Add a new OpenSearch data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param domain The OpenSearch domain for this data source. This parameter is required.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.OpenSearchDataSource addOpenSearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain domain, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * Add a new OpenSearch data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param domain The OpenSearch domain for this data source. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.OpenSearchDataSource addOpenSearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain domain);

    /**
     * add a new Rds data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param serverlessCluster The serverless cluster to interact with this data source. This parameter is required.
     * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
     * @param databaseName The optional name of the database to use within the cluster.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * add a new Rds data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param serverlessCluster The serverless cluster to interact with this data source. This parameter is required.
     * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
     * @param databaseName The optional name of the database to use within the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName);

    /**
     * add a new Rds data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param serverlessCluster The serverless cluster to interact with this data source. This parameter is required.
     * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore);

    /**
     * add a new Rds Serverless V2 data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param serverlessCluster The serverless V2 cluster to interact with this data source. This parameter is required.
     * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
     * @param databaseName The optional name of the database to use within the cluster.
     * @param options The optional configuration for this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSourceV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options);

    /**
     * add a new Rds Serverless V2 data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param serverlessCluster The serverless V2 cluster to interact with this data source. This parameter is required.
     * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
     * @param databaseName The optional name of the database to use within the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSourceV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName);

    /**
     * add a new Rds Serverless V2 data source to this API.
     * <p>
     * @param id The data source's id. This parameter is required.
     * @param serverlessCluster The serverless V2 cluster to interact with this data source. This parameter is required.
     * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSourceV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore);

    /**
     * Add schema dependency if not imported.
     * <p>
     * @param construct the dependee. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean addSchemaDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource construct);

    /**
     * creates a new resolver for this datasource and API using the given properties.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Resolver createResolver(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ExtendedResolverProps props);

    /**
     * Adds an IAM policy statement associated with this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/GraphQLId/...). This parameter is required.
     * @param actions The actions that should be granted to the principal (i.e. appsync:graphql ). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions);

    /**
     * Adds an IAM policy statement for Mutation access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Mutations (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantMutation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields);

    /**
     * Adds an IAM policy statement for Query access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Queries (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields);

    /**
     * Adds an IAM policy statement for Subscription access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Subscriptions (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appsync.IGraphqlApi.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
            return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * the ARN of the API.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getArn() {
            return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The GraphQL endpoint ARN.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getGraphQLEndpointArn() {
            return software.amazon.jsii.Kernel.get(this, "graphQLEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Authorization Types for this GraphQL Api.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> getModes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class))));
        }

        /**
         * the visibility of the API.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Visibility getVisibility() {
            return software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Visibility.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * add a new DynamoDB data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param table The DynamoDB table backing this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.DynamoDbDataSource addDynamoDbDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable table, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addDynamoDbDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.DynamoDbDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(table, "table is required"), options });
        }

        /**
         * add a new DynamoDB data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param table The DynamoDB table backing this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.DynamoDbDataSource addDynamoDbDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable table) {
            return software.amazon.jsii.Kernel.call(this, "addDynamoDbDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.DynamoDbDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(table, "table is required") });
        }

        /**
         * (deprecated) add a new elasticsearch data source to this API.
         * <p>
         * @deprecated <ul>
         * <li>use <code>addOpenSearchDataSource</code></li>
         * </ul>
         * @param id The data source's id. This parameter is required.
         * @param domain The elasticsearch domain for this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ElasticsearchDataSource addElasticsearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.IDomain domain, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addElasticsearchDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ElasticsearchDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(domain, "domain is required"), options });
        }

        /**
         * (deprecated) add a new elasticsearch data source to this API.
         * <p>
         * @deprecated <ul>
         * <li>use <code>addOpenSearchDataSource</code></li>
         * </ul>
         * @param id The data source's id. This parameter is required.
         * @param domain The elasticsearch domain for this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ElasticsearchDataSource addElasticsearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.IDomain domain) {
            return software.amazon.jsii.Kernel.call(this, "addElasticsearchDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ElasticsearchDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(domain, "domain is required") });
        }

        /**
         * Add an EventBridge data source to this api.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param eventBus The EventBridge EventBus on which to put events. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventBridgeDataSource addEventBridgeDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus eventBus, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addEventBridgeDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.EventBridgeDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(eventBus, "eventBus is required"), options });
        }

        /**
         * Add an EventBridge data source to this api.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param eventBus The EventBridge EventBus on which to put events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventBridgeDataSource addEventBridgeDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus eventBus) {
            return software.amazon.jsii.Kernel.call(this, "addEventBridgeDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.EventBridgeDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(eventBus, "eventBus is required") });
        }

        /**
         * add a new http data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param endpoint The http endpoint. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.HttpDataSource addHttpDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String endpoint, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.HttpDataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addHttpDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.HttpDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(endpoint, "endpoint is required"), options });
        }

        /**
         * add a new http data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param endpoint The http endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.HttpDataSource addHttpDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String endpoint) {
            return software.amazon.jsii.Kernel.call(this, "addHttpDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.HttpDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(endpoint, "endpoint is required") });
        }

        /**
         * add a new Lambda data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param lambdaFunction The Lambda function to call to interact with this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.LambdaDataSource addLambdaDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addLambdaDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.LambdaDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), options });
        }

        /**
         * add a new Lambda data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param lambdaFunction The Lambda function to call to interact with this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.LambdaDataSource addLambdaDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            return software.amazon.jsii.Kernel.call(this, "addLambdaDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.LambdaDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required") });
        }

        /**
         * add a new dummy data source to this API.
         * <p>
         * Useful for pipeline resolvers
         * and for backend changes that don't require a data source.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.NoneDataSource addNoneDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addNoneDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.NoneDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * add a new dummy data source to this API.
         * <p>
         * Useful for pipeline resolvers
         * and for backend changes that don't require a data source.
         * <p>
         * @param id The data source's id. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.NoneDataSource addNoneDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "addNoneDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.NoneDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Add a new OpenSearch data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param domain The OpenSearch domain for this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.OpenSearchDataSource addOpenSearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain domain, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addOpenSearchDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.OpenSearchDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(domain, "domain is required"), options });
        }

        /**
         * Add a new OpenSearch data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param domain The OpenSearch domain for this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.OpenSearchDataSource addOpenSearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain domain) {
            return software.amazon.jsii.Kernel.call(this, "addOpenSearchDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.OpenSearchDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(domain, "domain is required") });
        }

        /**
         * add a new Rds data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         * @param databaseName The optional name of the database to use within the cluster.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required"), databaseName, options });
        }

        /**
         * add a new Rds data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         * @param databaseName The optional name of the database to use within the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required"), databaseName });
        }

        /**
         * add a new Rds data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required") });
        }

        /**
         * add a new Rds Serverless V2 data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless V2 cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         * @param databaseName The optional name of the database to use within the cluster.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSourceV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSourceV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required"), databaseName, options });
        }

        /**
         * add a new Rds Serverless V2 data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless V2 cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         * @param databaseName The optional name of the database to use within the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSourceV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSourceV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required"), databaseName });
        }

        /**
         * add a new Rds Serverless V2 data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless V2 cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSourceV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSourceV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required") });
        }

        /**
         * Add schema dependency if not imported.
         * <p>
         * @param construct the dependee. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean addSchemaDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource construct) {
            return software.amazon.jsii.Kernel.call(this, "addSchemaDependency", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
        }

        /**
         * creates a new resolver for this datasource and API using the given properties.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Resolver createResolver(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ExtendedResolverProps props) {
            return software.amazon.jsii.Kernel.call(this, "createResolver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Resolver.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Adds an IAM policy statement associated with this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/GraphQLId/...). This parameter is required.
         * @param actions The actions that should be granted to the principal (i.e. appsync:graphql ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(resources, "resources is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for Mutation access to this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param fields The fields to grant access to that are Mutations (leave blank for all). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantMutation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
            return software.amazon.jsii.Kernel.call(this, "grantMutation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for Query access to this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param fields The fields to grant access to that are Queries (leave blank for all). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
            return software.amazon.jsii.Kernel.call(this, "grantQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for Subscription access to this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param fields The fields to grant access to that are Subscriptions (leave blank for all). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
            return software.amazon.jsii.Kernel.call(this, "grantSubscription", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
        }
    }

    /**
     * Internal default implementation for {@link IGraphqlApi}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IGraphqlApi, software.amazon.awscdk.IResource.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
            return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * the ARN of the API.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getArn() {
            return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The GraphQL endpoint ARN.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getGraphQLEndpointArn() {
            return software.amazon.jsii.Kernel.get(this, "graphQLEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Authorization Types for this GraphQL Api.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> getModes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class))));
        }

        /**
         * the visibility of the API.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Visibility getVisibility() {
            return software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Visibility.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * add a new DynamoDB data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param table The DynamoDB table backing this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.DynamoDbDataSource addDynamoDbDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable table, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addDynamoDbDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.DynamoDbDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(table, "table is required"), options });
        }

        /**
         * (deprecated) add a new elasticsearch data source to this API.
         * <p>
         * @deprecated <ul>
         * <li>use <code>addOpenSearchDataSource</code></li>
         * </ul>
         * @param id The data source's id. This parameter is required.
         * @param domain The elasticsearch domain for this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ElasticsearchDataSource addElasticsearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.IDomain domain, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addElasticsearchDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ElasticsearchDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(domain, "domain is required"), options });
        }

        /**
         * Add an EventBridge data source to this api.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param eventBus The EventBridge EventBus on which to put events. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventBridgeDataSource addEventBridgeDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus eventBus, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addEventBridgeDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.EventBridgeDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(eventBus, "eventBus is required"), options });
        }

        /**
         * add a new http data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param endpoint The http endpoint. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.HttpDataSource addHttpDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String endpoint, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.HttpDataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addHttpDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.HttpDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(endpoint, "endpoint is required"), options });
        }

        /**
         * add a new Lambda data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param lambdaFunction The Lambda function to call to interact with this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.LambdaDataSource addLambdaDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addLambdaDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.LambdaDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), options });
        }

        /**
         * add a new dummy data source to this API.
         * <p>
         * Useful for pipeline resolvers
         * and for backend changes that don't require a data source.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.NoneDataSource addNoneDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addNoneDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.NoneDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Add a new OpenSearch data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param domain The OpenSearch domain for this data source. This parameter is required.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.OpenSearchDataSource addOpenSearchDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain domain, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addOpenSearchDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.OpenSearchDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(domain, "domain is required"), options });
        }

        /**
         * add a new Rds data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         * @param databaseName The optional name of the database to use within the cluster.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required"), databaseName, options });
        }

        /**
         * add a new Rds Serverless V2 data source to this API.
         * <p>
         * @param id The data source's id. This parameter is required.
         * @param serverlessCluster The serverless V2 cluster to interact with this data source. This parameter is required.
         * @param secretStore The secret store that contains the username and password for the serverless cluster. This parameter is required.
         * @param databaseName The optional name of the database to use within the cluster.
         * @param options The optional configuration for this data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RdsDataSource addRdsDataSourceV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster serverlessCluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secretStore, final @org.jetbrains.annotations.Nullable java.lang.String databaseName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DataSourceOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addRdsDataSourceV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RdsDataSource.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), java.util.Objects.requireNonNull(secretStore, "secretStore is required"), databaseName, options });
        }

        /**
         * Add schema dependency if not imported.
         * <p>
         * @param construct the dependee. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.Boolean addSchemaDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource construct) {
            return software.amazon.jsii.Kernel.call(this, "addSchemaDependency", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
        }

        /**
         * creates a new resolver for this datasource and API using the given properties.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Resolver createResolver(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ExtendedResolverProps props) {
            return software.amazon.jsii.Kernel.call(this, "createResolver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Resolver.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Adds an IAM policy statement associated with this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/GraphQLId/...). This parameter is required.
         * @param actions The actions that should be granted to the principal (i.e. appsync:graphql ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(resources, "resources is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for Mutation access to this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param fields The fields to grant access to that are Mutations (leave blank for all). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantMutation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
            return software.amazon.jsii.Kernel.call(this, "grantMutation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for Query access to this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param fields The fields to grant access to that are Queries (leave blank for all). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
            return software.amazon.jsii.Kernel.call(this, "grantQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
        }

        /**
         * Adds an IAM policy statement for Subscription access to this GraphQLApi to an IAM principal's policy.
         * <p>
         * @param grantee The principal. This parameter is required.
         * @param fields The fields to grant access to that are Subscriptions (leave blank for all). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
            return software.amazon.jsii.Kernel.call(this, "grantSubscription", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
        }
    }
}
