package software.amazon.awscdk.services.appsync;

/**
 * An AppSync resolver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction appsyncFunction;
 * Resolver pipelineResolver = Resolver.Builder.create(this, "pipeline")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .typeName("typeName")
 *         .fieldName("fieldName")
 *         .requestMappingTemplate(MappingTemplate.fromFile("beforeRequest.vtl"))
 *         .pipelineConfig(List.of(appsyncFunction))
 *         .responseMappingTemplate(MappingTemplate.fromFile("afterResponse.vtl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.767Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.Resolver")
public class Resolver extends software.constructs.Construct {

    protected Resolver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Resolver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Resolver(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * the ARN of the resolver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.Resolver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.Resolver> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.ResolverProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.ResolverProps.Builder();
        }

        /**
         * name of the GraphQL field in the given type this resolver is attached to.
         * <p>
         * @return {@code this}
         * @param fieldName name of the GraphQL field in the given type this resolver is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldName(final java.lang.String fieldName) {
            this.props.fieldName(fieldName);
            return this;
        }

        /**
         * name of the GraphQL type this resolver is attached to.
         * <p>
         * @return {@code this}
         * @param typeName name of the GraphQL type this resolver is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(final java.lang.String typeName) {
            this.props.typeName(typeName);
            return this;
        }

        /**
         * The caching configuration for this resolver.
         * <p>
         * Default: - No caching configuration
         * <p>
         * @return {@code this}
         * @param cachingConfig The caching configuration for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingConfig(final software.amazon.awscdk.services.appsync.CachingConfig cachingConfig) {
            this.props.cachingConfig(cachingConfig);
            return this;
        }

        /**
         * The function code.
         * <p>
         * Default: - no code is used
         * <p>
         * @return {@code this}
         * @param code The function code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.appsync.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * The maximum number of elements per batch, when using batch invoke.
         * <p>
         * Default: - No max batch size
         * <p>
         * @return {@code this}
         * @param maxBatchSize The maximum number of elements per batch, when using batch invoke. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(final java.lang.Number maxBatchSize) {
            this.props.maxBatchSize(maxBatchSize);
            return this;
        }

        /**
         * configuration of the pipeline resolver.
         * <p>
         * Default: - no pipeline resolver configuration
         * An empty array | undefined sets resolver to be of kind, unit
         * <p>
         * @return {@code this}
         * @param pipelineConfig configuration of the pipeline resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineConfig(final java.util.List<? extends software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig) {
            this.props.pipelineConfig(pipelineConfig);
            return this;
        }

        /**
         * The request mapping template for this resolver.
         * <p>
         * Default: - No mapping template
         * <p>
         * @return {@code this}
         * @param requestMappingTemplate The request mapping template for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.props.requestMappingTemplate(requestMappingTemplate);
            return this;
        }

        /**
         * The response mapping template for this resolver.
         * <p>
         * Default: - No mapping template
         * <p>
         * @return {@code this}
         * @param responseMappingTemplate The response mapping template for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.props.responseMappingTemplate(responseMappingTemplate);
            return this;
        }

        /**
         * The functions runtime.
         * <p>
         * Default: - no function runtime, VTL mapping templates used
         * <p>
         * @return {@code this}
         * @param runtime The functions runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.amazon.awscdk.services.appsync.FunctionRuntime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * The data source this resolver is using.
         * <p>
         * Default: - No datasource
         * <p>
         * @return {@code this}
         * @param dataSource The data source this resolver is using. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(final software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.props.dataSource(dataSource);
            return this;
        }

        /**
         * The API this resolver is attached to.
         * <p>
         * @return {@code this}
         * @param api The API this resolver is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.Resolver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.Resolver build() {
            return new software.amazon.awscdk.services.appsync.Resolver(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
