package software.amazon.awscdk.services.appsync;

/**
 * Factory class for attribute value assignments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "Api")
 *         .name("demo")
 *         .definition(Definition.fromFile(join(__dirname, "schema.graphql")))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder()
 *                         .authorizationType(AuthorizationType.IAM)
 *                         .build())
 *                 .build())
 *         .xrayEnabled(true)
 *         .build();
 * Table demoTable = Table.Builder.create(this, "DemoTable")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * DynamoDbDataSource demoDS = api.addDynamoDbDataSource("demoDataSource", demoTable);
 * // Resolver for the Query "getDemos" that scans the DynamoDb table and returns the entire list.
 * // Resolver Mapping Template Reference:
 * // https://docs.aws.amazon.com/appsync/latest/devguide/resolver-mapping-template-reference-dynamodb.html
 * demoDS.createResolver("QueryGetDemosResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemos")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable())
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * // Resolver for the Mutation "addDemo" that puts the item into the DynamoDb table.
 * demoDS.createResolver("MutationAddDemoResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemo")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbPutItem(PrimaryKey.partition("id").auto(), Values.projecting("input")))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultItem())
 *         .build());
 * //To enable DynamoDB read consistency with the `MappingTemplate`:
 * demoDS.createResolver("QueryGetDemosConsistentResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemosConsistent")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable(true))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:49.774Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.Values")
public class Values extends software.amazon.jsii.JsiiObject {

    protected Values(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Values(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Values() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Allows assigning a value to the specified attribute.
     * <p>
     * @param attr This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AttributeValuesStep attribute(final @org.jetbrains.annotations.NotNull java.lang.String attr) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Values.class, "attribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AttributeValuesStep.class), new Object[] { java.util.Objects.requireNonNull(attr, "attr is required") });
    }

    /**
     * Treats the specified object as a map of assignments, where the property names represent attribute names.
     * <p>
     * It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     * <p>
     * @param arg
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AttributeValues projecting(final @org.jetbrains.annotations.Nullable java.lang.String arg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Values.class, "projecting", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AttributeValues.class), new Object[] { arg });
    }

    /**
     * Treats the specified object as a map of assignments, where the property names represent attribute names.
     * <p>
     * It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AttributeValues projecting() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Values.class, "projecting", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AttributeValues.class));
    }
}
