package software.amazon.awscdk.services.batch;

/**
 * A JobDefinition that uses Eks orchestration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn = EksJobDefinition.Builder.create(this, "eksf2")
 *         .container(EksContainerDefinition.Builder.create(this, "container")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .volumes(List.of(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *                         .name("myEmptyDirVolume")
 *                         .mountPath("/mount/path")
 *                         .medium(EmptyDirMediumType.MEMORY)
 *                         .readonly(true)
 *                         .sizeLimit(Size.mebibytes(2048))
 *                         .build())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:50.260Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EksJobDefinition")
public class EksJobDefinition extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IEksJobDefinition, software.amazon.awscdk.services.batch.IJobDefinition {

    protected EksJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EksJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EksJobDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an EksJobDefinition by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param eksJobDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IEksJobDefinition fromEksJobDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String eksJobDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EksJobDefinition.class, "fromEksJobDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IEksJobDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(eksJobDefinitionArn, "eksJobDefinitionArn is required") });
    }

    /**
     * Add a RetryStrategy to this JobDefinition.
     * <p>
     * @param strategy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addRetryStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.RetryStrategy strategy) {
        software.amazon.jsii.Kernel.call(this, "addRetryStrategy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(strategy, "strategy is required") });
    }

    /**
     * The container this Job Definition will run.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksContainerDefinition getContainer() {
        return software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksContainerDefinition.class));
    }

    /**
     * The ARN of this job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines the retry behavior for this job.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class))));
    }

    /**
     * The DNS Policy of the pod used by this Job Definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.DnsPolicy getDnsPolicy() {
        return software.amazon.jsii.Kernel.get(this, "dnsPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.DnsPolicy.class));
    }

    /**
     * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The number of times to retry a job.
     * <p>
     * The job is retried on failure the same number of attempts as the value.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The priority of this Job.
     * <p>
     * Only used in Fairshare Scheduling
     * to decide which job to run first when there are multiple jobs
     * with the same share identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The name of the service account that's used to run the container.
     * <p>
     * service accounts are Kubernetes method of identification and authentication,
     * roughly analogous to IAM users.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceAccount() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes,
     * Batch terminates your jobs if they aren't finished.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * If specified, the Pod used by this Job Definition will use the host's network IP address.
     * <p>
     * Otherwise, the Kubernetes pod networking model is enabled.
     * Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getUseHostNetwork() {
        return software.amazon.jsii.Kernel.get(this, "useHostNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.EksJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.EksJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.EksJobDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.EksJobDefinitionProps.Builder();
        }

        /**
         * The name of this job definition.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param jobDefinitionName The name of this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters">https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters</a>
         * @param parameters The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The number of times to retry a job.
         * <p>
         * The job is retried on failure the same number of attempts as the value.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param retryAttempts The number of times to retry a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Defines the retry behavior for this job.
         * <p>
         * Default: - no `RetryStrategy`
         * <p>
         * @return {@code this}
         * @param retryStrategies Defines the retry behavior for this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategies(final java.util.List<? extends software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies) {
            this.props.retryStrategies(retryStrategies);
            return this;
        }

        /**
         * The priority of this Job.
         * <p>
         * Only used in Fairshare Scheduling
         * to decide which job to run first when there are multiple jobs
         * with the same share identifier.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param schedulingPriority The priority of this Job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(final java.lang.Number schedulingPriority) {
            this.props.schedulingPriority(schedulingPriority);
            return this;
        }

        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes,
         * Batch terminates your jobs if they aren't finished.
         * <p>
         * Default: - no timeout
         * <p>
         * @return {@code this}
         * @param timeout The timeout time for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The container this Job Definition will run.
         * <p>
         * @return {@code this}
         * @param container The container this Job Definition will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder container(final software.amazon.awscdk.services.batch.EksContainerDefinition container) {
            this.props.container(container);
            return this;
        }

        /**
         * The DNS Policy of the pod used by this Job Definition.
         * <p>
         * Default: `DnsPolicy.CLUSTER_FIRST`
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy</a>
         * @param dnsPolicy The DNS Policy of the pod used by this Job Definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsPolicy(final software.amazon.awscdk.services.batch.DnsPolicy dnsPolicy) {
            this.props.dnsPolicy(dnsPolicy);
            return this;
        }

        /**
         * The name of the service account that's used to run the container.
         * <p>
         * service accounts are Kubernetes method of identification and authentication,
         * roughly analogous to IAM users.
         * <p>
         * Default: - the default service account of the container
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html</a>
         * @param serviceAccount The name of the service account that's used to run the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final java.lang.String serviceAccount) {
            this.props.serviceAccount(serviceAccount);
            return this;
        }

        /**
         * If specified, the Pod used by this Job Definition will use the host's network IP address.
         * <p>
         * Otherwise, the Kubernetes pod networking model is enabled.
         * Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking</a>
         * @param useHostNetwork If specified, the Pod used by this Job Definition will use the host's network IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useHostNetwork(final java.lang.Boolean useHostNetwork) {
            this.props.useHostNetwork(useHostNetwork);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.EksJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.EksJobDefinition build() {
            return new software.amazon.awscdk.services.batch.EksJobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
