package software.amazon.awscdk.services.batch;

/**
 * Options to configure an EksVolume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * EksVolumeOptions eksVolumeOptions = EksVolumeOptions.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .mountPath("mountPath")
 *         .readonly(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:50.262Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EksVolumeOptions")
@software.amazon.jsii.Jsii.Proxy(EksVolumeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EksVolumeOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of this volume.
     * <p>
     * The name must be a valid DNS subdomain name.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The path on the container where the volume is mounted.
     * <p>
     * Default: - the volume is not mounted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMountPath() {
        return null;
    }

    /**
     * If specified, the container has readonly access to the volume.
     * <p>
     * Otherwise, the container has read/write access.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonly() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EksVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EksVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EksVolumeOptions> {
        java.lang.String name;
        java.lang.String mountPath;
        java.lang.Boolean readonly;

        /**
         * Sets the value of {@link EksVolumeOptions#getName}
         * @param name The name of this volume. This parameter is required.
         *             The name must be a valid DNS subdomain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EksVolumeOptions#getMountPath}
         * @param mountPath The path on the container where the volume is mounted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountPath(java.lang.String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        /**
         * Sets the value of {@link EksVolumeOptions#getReadonly}
         * @param readonly If specified, the container has readonly access to the volume.
         *                 Otherwise, the container has read/write access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(java.lang.Boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EksVolumeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EksVolumeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EksVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksVolumeOptions {
        private final java.lang.String name;
        private final java.lang.String mountPath;
        private final java.lang.Boolean readonly;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mountPath = software.amazon.jsii.Kernel.get(this, "mountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readonly = software.amazon.jsii.Kernel.get(this, "readonly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.mountPath = builder.mountPath;
            this.readonly = builder.readonly;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getMountPath() {
            return this.mountPath;
        }

        @Override
        public final java.lang.Boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getMountPath() != null) {
                data.set("mountPath", om.valueToTree(this.getMountPath()));
            }
            if (this.getReadonly() != null) {
                data.set("readonly", om.valueToTree(this.getReadonly()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EksVolumeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EksVolumeOptions.Jsii$Proxy that = (EksVolumeOptions.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) return false;
            return this.readonly != null ? this.readonly.equals(that.readonly) : that.readonly == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.mountPath != null ? this.mountPath.hashCode() : 0);
            result = 31 * result + (this.readonly != null ? this.readonly.hashCode() : 0);
            return result;
        }
    }
}
