package software.amazon.awscdk.services.batch;

/**
 * What medium the volume will live in.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn = EksJobDefinition.Builder.create(this, "eksf2")
 *         .container(EksContainerDefinition.Builder.create(this, "container")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .volumes(List.of(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *                         .name("myEmptyDirVolume")
 *                         .mountPath("/mount/path")
 *                         .medium(EmptyDirMediumType.MEMORY)
 *                         .readonly(true)
 *                         .sizeLimit(Size.mebibytes(2048))
 *                         .build())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:50.263Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EmptyDirMediumType")
public enum EmptyDirMediumType {
    /**
     * Use the disk storage of the node.
     * <p>
     * Items written here will survive node reboots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISK,
    /**
     * Use the <code>tmpfs</code> volume that is backed by RAM of the node.
     * <p>
     * Items written here will <em>not</em> survive node reboots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY,
}
