package software.amazon.awscdk.services.batch;

/**
 * Props for a FargateComputeEnvironment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * FargateComputeEnvironment sharedComputeEnv = FargateComputeEnvironment.Builder.create(this, "spotEnv")
 *         .vpc(vpc)
 *         .spot(true)
 *         .build();
 * JobQueue lowPriorityQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .priority(1)
 *         .build();
 * JobQueue highPriorityQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .priority(10)
 *         .build();
 * lowPriorityQueue.addComputeEnvironment(sharedComputeEnv, 1);
 * highPriorityQueue.addComputeEnvironment(sharedComputeEnv, 1);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:50.267Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.FargateComputeEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(FargateComputeEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FargateComputeEnvironmentProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.ManagedComputeEnvironmentProps {

    /**
     * @return a {@link Builder} of {@link FargateComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FargateComputeEnvironmentProps> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Number maxvCpus;
        java.lang.Boolean replaceComputeEnvironment;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.lang.Boolean spot;
        java.lang.Boolean terminateOnUpdate;
        software.amazon.awscdk.Duration updateTimeout;
        java.lang.Boolean updateToLatestImageVersion;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        java.lang.String computeEnvironmentName;
        java.lang.Boolean enabled;
        software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getVpc}
         * @param vpc VPC in which this Compute Environment will launch Instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getMaxvCpus}
         * @param maxvCpus The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to. Each vCPU is equivalent to 1024 CPU shares.
         *                 <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
         *                 <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
         *                 The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
         *                 or <code>instanceClasses</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxvCpus(java.lang.Number maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getReplaceComputeEnvironment}
         * @param replaceComputeEnvironment Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
         *                                  To enable more properties to be updated,
         *                                  set this property to <code>false</code>. When changing the value of this property to false,
         *                                  do not change any other properties at the same time.
         *                                  If other properties are changed at the same time,
         *                                  and the change needs to be rolled back but it can't,
         *                                  it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
         *                                  You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
         *                                  However, if you can continue to roll it back,
         *                                  you can return the stack to its original settings and then try to update it again.
         *                                  <p>
         *                                  The properties which require a replacement of the Compute Environment are:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(java.lang.Boolean replaceComputeEnvironment) {
            this.replaceComputeEnvironment = replaceComputeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getSecurityGroups}
         * @param securityGroups The security groups this Compute Environment will launch instances in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getSpot}
         * @param spot Whether or not to use spot instances.
         *             Spot instances are less expensive EC2 instances that can be
         *             reclaimed by EC2 at any time; your job will be given two minutes
         *             of notice before reclamation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spot(java.lang.Boolean spot) {
            this.spot = spot;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getTerminateOnUpdate}
         * @param terminateOnUpdate Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
         *                          If this is enabled, any terminated jobs may be retried, depending on the job's
         *                          retry policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateOnUpdate(java.lang.Boolean terminateOnUpdate) {
            this.terminateOnUpdate = terminateOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getUpdateTimeout}
         * @param updateTimeout Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
         *                      If so,
         *                      when an infrastructure update is triggered, any running jobs
         *                      will be allowed to run until <code>updateTimeout</code> has expired.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateTimeout(software.amazon.awscdk.Duration updateTimeout) {
            this.updateTimeout = updateTimeout;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getUpdateToLatestImageVersion}
         * @param updateToLatestImageVersion Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
         *                                   If you specify a specific AMI, this property will be ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateToLatestImageVersion(java.lang.Boolean updateToLatestImageVersion) {
            this.updateToLatestImageVersion = updateToLatestImageVersion;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getVpcSubnets}
         * @param vpcSubnets The VPC Subnets this Compute Environment will launch instances in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getComputeEnvironmentName}
         * @param computeEnvironmentName The name of the ComputeEnvironment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(java.lang.String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getEnabled}
         * @param enabled Whether or not this ComputeEnvironment can accept jobs from a Queue.
         *                Enabled ComputeEnvironments can accept jobs from a Queue and
         *                can scale instances up or down.
         *                Disabled ComputeEnvironments cannot accept jobs from a Queue or
         *                scale instances up or down.
         *                <p>
         *                If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         *                Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         *                be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         *                <p>
         *                To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link FargateComputeEnvironmentProps#getServiceRole}
         * @param serviceRole The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateComputeEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FargateComputeEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FargateComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateComputeEnvironmentProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Number maxvCpus;
        private final java.lang.Boolean replaceComputeEnvironment;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.Boolean spot;
        private final java.lang.Boolean terminateOnUpdate;
        private final software.amazon.awscdk.Duration updateTimeout;
        private final java.lang.Boolean updateToLatestImageVersion;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final java.lang.String computeEnvironmentName;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.maxvCpus = software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.replaceComputeEnvironment = software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.spot = software.amazon.jsii.Kernel.get(this, "spot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.terminateOnUpdate = software.amazon.jsii.Kernel.get(this, "terminateOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.updateTimeout = software.amazon.jsii.Kernel.get(this, "updateTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.updateToLatestImageVersion = software.amazon.jsii.Kernel.get(this, "updateToLatestImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.computeEnvironmentName = software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.maxvCpus = builder.maxvCpus;
            this.replaceComputeEnvironment = builder.replaceComputeEnvironment;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.spot = builder.spot;
            this.terminateOnUpdate = builder.terminateOnUpdate;
            this.updateTimeout = builder.updateTimeout;
            this.updateToLatestImageVersion = builder.updateToLatestImageVersion;
            this.vpcSubnets = builder.vpcSubnets;
            this.computeEnvironmentName = builder.computeEnvironmentName;
            this.enabled = builder.enabled;
            this.serviceRole = builder.serviceRole;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Number getMaxvCpus() {
            return this.maxvCpus;
        }

        @Override
        public final java.lang.Boolean getReplaceComputeEnvironment() {
            return this.replaceComputeEnvironment;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Boolean getSpot() {
            return this.spot;
        }

        @Override
        public final java.lang.Boolean getTerminateOnUpdate() {
            return this.terminateOnUpdate;
        }

        @Override
        public final software.amazon.awscdk.Duration getUpdateTimeout() {
            return this.updateTimeout;
        }

        @Override
        public final java.lang.Boolean getUpdateToLatestImageVersion() {
            return this.updateToLatestImageVersion;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final java.lang.String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getMaxvCpus() != null) {
                data.set("maxvCpus", om.valueToTree(this.getMaxvCpus()));
            }
            if (this.getReplaceComputeEnvironment() != null) {
                data.set("replaceComputeEnvironment", om.valueToTree(this.getReplaceComputeEnvironment()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSpot() != null) {
                data.set("spot", om.valueToTree(this.getSpot()));
            }
            if (this.getTerminateOnUpdate() != null) {
                data.set("terminateOnUpdate", om.valueToTree(this.getTerminateOnUpdate()));
            }
            if (this.getUpdateTimeout() != null) {
                data.set("updateTimeout", om.valueToTree(this.getUpdateTimeout()));
            }
            if (this.getUpdateToLatestImageVersion() != null) {
                data.set("updateToLatestImageVersion", om.valueToTree(this.getUpdateToLatestImageVersion()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getComputeEnvironmentName() != null) {
                data.set("computeEnvironmentName", om.valueToTree(this.getComputeEnvironmentName()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.FargateComputeEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateComputeEnvironmentProps.Jsii$Proxy that = (FargateComputeEnvironmentProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.maxvCpus != null ? !this.maxvCpus.equals(that.maxvCpus) : that.maxvCpus != null) return false;
            if (this.replaceComputeEnvironment != null ? !this.replaceComputeEnvironment.equals(that.replaceComputeEnvironment) : that.replaceComputeEnvironment != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.spot != null ? !this.spot.equals(that.spot) : that.spot != null) return false;
            if (this.terminateOnUpdate != null ? !this.terminateOnUpdate.equals(that.terminateOnUpdate) : that.terminateOnUpdate != null) return false;
            if (this.updateTimeout != null ? !this.updateTimeout.equals(that.updateTimeout) : that.updateTimeout != null) return false;
            if (this.updateToLatestImageVersion != null ? !this.updateToLatestImageVersion.equals(that.updateToLatestImageVersion) : that.updateToLatestImageVersion != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            if (this.computeEnvironmentName != null ? !this.computeEnvironmentName.equals(that.computeEnvironmentName) : that.computeEnvironmentName != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.serviceRole != null ? this.serviceRole.equals(that.serviceRole) : that.serviceRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.maxvCpus != null ? this.maxvCpus.hashCode() : 0);
            result = 31 * result + (this.replaceComputeEnvironment != null ? this.replaceComputeEnvironment.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.spot != null ? this.spot.hashCode() : 0);
            result = 31 * result + (this.terminateOnUpdate != null ? this.terminateOnUpdate.hashCode() : 0);
            result = 31 * result + (this.updateTimeout != null ? this.updateTimeout.hashCode() : 0);
            result = 31 * result + (this.updateToLatestImageVersion != null ? this.updateToLatestImageVersion.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.computeEnvironmentName != null ? this.computeEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            return result;
        }
    }
}
