package software.amazon.awscdk.services.cleanrooms;

/**
 * Properties for defining a <code>CfnConfiguredTable</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnConfiguredTableProps cfnConfiguredTableProps = CfnConfiguredTableProps.builder()
 *         .allowedColumns(List.of("allowedColumns"))
 *         .analysisMethod("analysisMethod")
 *         .name("name")
 *         .tableReference(TableReferenceProperty.builder()
 *                 .athena(AthenaTableReferenceProperty.builder()
 *                         .databaseName("databaseName")
 *                         .tableName("tableName")
 *                         .workGroup("workGroup")
 *                         // the properties below are optional
 *                         .outputLocation("outputLocation")
 *                         .build())
 *                 .glue(GlueTableReferenceProperty.builder()
 *                         .databaseName("databaseName")
 *                         .tableName("tableName")
 *                         .build())
 *                 .snowflake(SnowflakeTableReferenceProperty.builder()
 *                         .accountIdentifier("accountIdentifier")
 *                         .databaseName("databaseName")
 *                         .schemaName("schemaName")
 *                         .secretArn("secretArn")
 *                         .tableName("tableName")
 *                         .tableSchema(SnowflakeTableSchemaProperty.builder()
 *                                 .v1(List.of(SnowflakeTableSchemaV1Property.builder()
 *                                         .columnName("columnName")
 *                                         .columnType("columnType")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .analysisRules(List.of(AnalysisRuleProperty.builder()
 *                 .policy(ConfiguredTableAnalysisRulePolicyProperty.builder()
 *                         .v1(ConfiguredTableAnalysisRulePolicyV1Property.builder()
 *                                 .aggregation(AnalysisRuleAggregationProperty.builder()
 *                                         .aggregateColumns(List.of(AggregateColumnProperty.builder()
 *                                                 .columnNames(List.of("columnNames"))
 *                                                 .function("function")
 *                                                 .build()))
 *                                         .dimensionColumns(List.of("dimensionColumns"))
 *                                         .joinColumns(List.of("joinColumns"))
 *                                         .outputConstraints(List.of(AggregationConstraintProperty.builder()
 *                                                 .columnName("columnName")
 *                                                 .minimum(123)
 *                                                 .type("type")
 *                                                 .build()))
 *                                         .scalarFunctions(List.of("scalarFunctions"))
 *                                         // the properties below are optional
 *                                         .additionalAnalyses("additionalAnalyses")
 *                                         .allowedJoinOperators(List.of("allowedJoinOperators"))
 *                                         .joinRequired("joinRequired")
 *                                         .build())
 *                                 .custom(AnalysisRuleCustomProperty.builder()
 *                                         .allowedAnalyses(List.of("allowedAnalyses"))
 *                                         // the properties below are optional
 *                                         .additionalAnalyses("additionalAnalyses")
 *                                         .allowedAnalysisProviders(List.of("allowedAnalysisProviders"))
 *                                         .differentialPrivacy(DifferentialPrivacyProperty.builder()
 *                                                 .columns(List.of(DifferentialPrivacyColumnProperty.builder()
 *                                                         .name("name")
 *                                                         .build()))
 *                                                 .build())
 *                                         .disallowedOutputColumns(List.of("disallowedOutputColumns"))
 *                                         .build())
 *                                 .list(AnalysisRuleListProperty.builder()
 *                                         .joinColumns(List.of("joinColumns"))
 *                                         .listColumns(List.of("listColumns"))
 *                                         // the properties below are optional
 *                                         .additionalAnalyses("additionalAnalyses")
 *                                         .allowedJoinOperators(List.of("allowedJoinOperators"))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build()))
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:50.684Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfiguredTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfiguredTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The columns within the underlying AWS Glue table that can be utilized within collaborations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-allowedcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-allowedcolumns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedColumns();

    /**
     * The analysis method for the configured table.
     * <p>
     * The only valid value is currently <code>DIRECT_QUERY</code>.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysismethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysismethod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAnalysisMethod();

    /**
     * A name for the configured table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The table that this configured table represents.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTableReference();

    /**
     * The analysis rule that was created for the configured table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAnalysisRules() {
        return null;
    }

    /**
     * A description for the configured table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfiguredTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfiguredTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfiguredTableProps> {
        java.util.List<java.lang.String> allowedColumns;
        java.lang.String analysisMethod;
        java.lang.String name;
        java.lang.Object tableReference;
        java.lang.Object analysisRules;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getAllowedColumns}
         * @param allowedColumns The columns within the underlying AWS Glue table that can be utilized within collaborations. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedColumns(java.util.List<java.lang.String> allowedColumns) {
            this.allowedColumns = allowedColumns;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getAnalysisMethod}
         * @param analysisMethod The analysis method for the configured table. This parameter is required.
         *                       The only valid value is currently <code>DIRECT_QUERY</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisMethod(java.lang.String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getName}
         * @param name A name for the configured table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getTableReference}
         * @param tableReference The table that this configured table represents. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableReference(software.amazon.awscdk.IResolvable tableReference) {
            this.tableReference = tableReference;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getTableReference}
         * @param tableReference The table that this configured table represents. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableReference(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.TableReferenceProperty tableReference) {
            this.tableReference = tableReference;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getAnalysisRules}
         * @param analysisRules The analysis rule that was created for the configured table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisRules(software.amazon.awscdk.IResolvable analysisRules) {
            this.analysisRules = analysisRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getAnalysisRules}
         * @param analysisRules The analysis rule that was created for the configured table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisRules(java.util.List<? extends java.lang.Object> analysisRules) {
            this.analysisRules = analysisRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getDescription}
         * @param description A description for the configured table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfiguredTableProps#getTags}
         * @param tags An optional label that you can assign to a resource when you create it.
         *             Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfiguredTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfiguredTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfiguredTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfiguredTableProps {
        private final java.util.List<java.lang.String> allowedColumns;
        private final java.lang.String analysisMethod;
        private final java.lang.String name;
        private final java.lang.Object tableReference;
        private final java.lang.Object analysisRules;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedColumns = software.amazon.jsii.Kernel.get(this, "allowedColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.analysisMethod = software.amazon.jsii.Kernel.get(this, "analysisMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableReference = software.amazon.jsii.Kernel.get(this, "tableReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.analysisRules = software.amazon.jsii.Kernel.get(this, "analysisRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedColumns = java.util.Objects.requireNonNull(builder.allowedColumns, "allowedColumns is required");
            this.analysisMethod = java.util.Objects.requireNonNull(builder.analysisMethod, "analysisMethod is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.tableReference = java.util.Objects.requireNonNull(builder.tableReference, "tableReference is required");
            this.analysisRules = builder.analysisRules;
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedColumns() {
            return this.allowedColumns;
        }

        @Override
        public final java.lang.String getAnalysisMethod() {
            return this.analysisMethod;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getTableReference() {
            return this.tableReference;
        }

        @Override
        public final java.lang.Object getAnalysisRules() {
            return this.analysisRules;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowedColumns", om.valueToTree(this.getAllowedColumns()));
            data.set("analysisMethod", om.valueToTree(this.getAnalysisMethod()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("tableReference", om.valueToTree(this.getTableReference()));
            if (this.getAnalysisRules() != null) {
                data.set("analysisRules", om.valueToTree(this.getAnalysisRules()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfiguredTableProps.Jsii$Proxy that = (CfnConfiguredTableProps.Jsii$Proxy) o;

            if (!allowedColumns.equals(that.allowedColumns)) return false;
            if (!analysisMethod.equals(that.analysisMethod)) return false;
            if (!name.equals(that.name)) return false;
            if (!tableReference.equals(that.tableReference)) return false;
            if (this.analysisRules != null ? !this.analysisRules.equals(that.analysisRules) : that.analysisRules != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedColumns.hashCode();
            result = 31 * result + (this.analysisMethod.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.tableReference.hashCode());
            result = 31 * result + (this.analysisRules != null ? this.analysisRules.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
