package software.amazon.awscdk.services.cloudfront;

/**
 * Options for how CloudFront signs requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * S3OriginAccessControl oac = S3OriginAccessControl.Builder.create(this, "MyOAC")
 *         .signing(Signing.SIGV4_NO_OVERRIDE)
 *         .build();
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessControl(oac)
 *         .build());
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:50.978Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.Signing")
public class Signing extends software.amazon.jsii.JsiiObject {

    protected Signing(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Signing(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        NEVER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.Signing.class, "NEVER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Signing.class));
        SIGV4_ALWAYS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.Signing.class, "SIGV4_ALWAYS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Signing.class));
        SIGV4_NO_OVERRIDE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.Signing.class, "SIGV4_NO_OVERRIDE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Signing.class));
    }

    /**
     * @param protocol This parameter is required.
     * @param behavior This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Signing(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.SigningProtocol protocol, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.SigningBehavior behavior) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(protocol, "protocol is required"), java.util.Objects.requireNonNull(behavior, "behavior is required") });
    }

    /**
     * Do not sign any origin requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.Signing NEVER;

    /**
     * Sign all origin requests using the AWS Signature Version 4 signing protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.Signing SIGV4_ALWAYS;

    /**
     * Sign only if the viewer request doesn't contain the Authorization header using the AWS Signature Version 4 signing protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.Signing SIGV4_NO_OVERRIDE;

    /**
     * Which requests CloudFront signs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.SigningBehavior getBehavior() {
        return software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.SigningBehavior.class));
    }

    /**
     * The signing protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.SigningProtocol getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.SigningProtocol.class));
    }
}
