package software.amazon.awscdk.services.codedeploy;

/**
 * Represents the configuration specific to linear traffic shifting.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * LinearTrafficRoutingConfig linearTrafficRoutingConfig = LinearTrafficRoutingConfig.builder()
 *         .linearInterval(123)
 *         .linearPercentage(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:51.459Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.LinearTrafficRoutingConfig")
@software.amazon.jsii.Jsii.Proxy(LinearTrafficRoutingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LinearTrafficRoutingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getLinearInterval();

    /**
     * The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code> deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getLinearPercentage();

    /**
     * @return a {@link Builder} of {@link LinearTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LinearTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LinearTrafficRoutingConfig> {
        java.lang.Number linearInterval;
        java.lang.Number linearPercentage;

        /**
         * Sets the value of {@link LinearTrafficRoutingConfig#getLinearInterval}
         * @param linearInterval The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linearInterval(java.lang.Number linearInterval) {
            this.linearInterval = linearInterval;
            return this;
        }

        /**
         * Sets the value of {@link LinearTrafficRoutingConfig#getLinearPercentage}
         * @param linearPercentage The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code> deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linearPercentage(java.lang.Number linearPercentage) {
            this.linearPercentage = linearPercentage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LinearTrafficRoutingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LinearTrafficRoutingConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LinearTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinearTrafficRoutingConfig {
        private final java.lang.Number linearInterval;
        private final java.lang.Number linearPercentage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.linearInterval = software.amazon.jsii.Kernel.get(this, "linearInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.linearPercentage = software.amazon.jsii.Kernel.get(this, "linearPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.linearInterval = java.util.Objects.requireNonNull(builder.linearInterval, "linearInterval is required");
            this.linearPercentage = java.util.Objects.requireNonNull(builder.linearPercentage, "linearPercentage is required");
        }

        @Override
        public final java.lang.Number getLinearInterval() {
            return this.linearInterval;
        }

        @Override
        public final java.lang.Number getLinearPercentage() {
            return this.linearPercentage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("linearInterval", om.valueToTree(this.getLinearInterval()));
            data.set("linearPercentage", om.valueToTree(this.getLinearPercentage()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.LinearTrafficRoutingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LinearTrafficRoutingConfig.Jsii$Proxy that = (LinearTrafficRoutingConfig.Jsii$Proxy) o;

            if (!linearInterval.equals(that.linearInterval)) return false;
            return this.linearPercentage.equals(that.linearPercentage);
        }

        @Override
        public final int hashCode() {
            int result = this.linearInterval.hashCode();
            result = 31 * result + (this.linearPercentage.hashCode());
            return result;
        }
    }
}
