package software.amazon.awscdk.services.codedeploy;

/**
 * Define a traffic routing config of type 'TimeBasedCanary'.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaDeploymentConfig config = LambdaDeploymentConfig.Builder.create(this, "CustomConfig")
 *         .trafficRouting(TimeBasedCanaryTrafficRouting.Builder.create()
 *                 .interval(Duration.minutes(15))
 *                 .percentage(5)
 *                 .build())
 *         .deploymentConfigName("MyDeploymentConfig")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:51.465Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.TimeBasedCanaryTrafficRouting")
public class TimeBasedCanaryTrafficRouting extends software.amazon.awscdk.services.codedeploy.TrafficRouting {

    protected TimeBasedCanaryTrafficRouting(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TimeBasedCanaryTrafficRouting(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TimeBasedCanaryTrafficRouting(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRoutingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return a TrafficRoutingConfig of type <code>TimeBasedCanary</code>.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TrafficRoutingConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.TrafficRoutingConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * The amount of time between additional traffic shifts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getInterval() {
        return software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * The percentage to increase traffic on each traffic shift.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPercentage() {
        return software.amazon.jsii.Kernel.get(this, "percentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRouting}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRouting> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRoutingProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRoutingProps.Builder();
        }

        /**
         * The amount of time between traffic shifts.
         * <p>
         * @return {@code this}
         * @param interval The amount of time between traffic shifts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(final software.amazon.awscdk.Duration interval) {
            this.props.interval(interval);
            return this;
        }

        /**
         * The percentage to increase traffic on each traffic shift.
         * <p>
         * @return {@code this}
         * @param percentage The percentage to increase traffic on each traffic shift. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder percentage(final java.lang.Number percentage) {
            this.props.percentage(percentage);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRouting}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRouting build() {
            return new software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRouting(
                this.props.build()
            );
        }
    }
}
