package software.amazon.awscdk.services.codepipeline;

/**
 * Properties for defining a <code>CfnCustomActionType</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * CfnCustomActionTypeProps cfnCustomActionTypeProps = CfnCustomActionTypeProps.builder()
 *         .category("category")
 *         .inputArtifactDetails(ArtifactDetailsProperty.builder()
 *                 .maximumCount(123)
 *                 .minimumCount(123)
 *                 .build())
 *         .outputArtifactDetails(ArtifactDetailsProperty.builder()
 *                 .maximumCount(123)
 *                 .minimumCount(123)
 *                 .build())
 *         .provider("provider")
 *         .version("version")
 *         // the properties below are optional
 *         .configurationProperties(List.of(ConfigurationPropertiesProperty.builder()
 *                 .key(false)
 *                 .name("name")
 *                 .required(false)
 *                 .secret(false)
 *                 // the properties below are optional
 *                 .description("description")
 *                 .queryable(false)
 *                 .type("type")
 *                 .build()))
 *         .settings(SettingsProperty.builder()
 *                 .entityUrlTemplate("entityUrlTemplate")
 *                 .executionUrlTemplate("executionUrlTemplate")
 *                 .revisionUrlTemplate("revisionUrlTemplate")
 *                 .thirdPartyConfigurationUrl("thirdPartyConfigurationUrl")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:51.504Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnCustomActionTypeProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomActionTypeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomActionTypeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The category of the custom action, such as a build action or a test action.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCategory();

    /**
     * The details of the input artifact for the action, such as its commit ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInputArtifactDetails();

    /**
     * The details of the output artifact of the action, such as its commit ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOutputArtifactDetails();

    /**
     * The provider of the service used in the custom action, such as CodeDeploy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProvider();

    /**
     * The version identifier of the custom action.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersion();

    /**
     * The configuration properties for the custom action.
     * <p>
     * <blockquote>
     * <p>
     * You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationProperties() {
        return null;
    }

    /**
     * URLs that provide users information about this custom action.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return null;
    }

    /**
     * The tags for the custom action.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomActionTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomActionTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomActionTypeProps> {
        java.lang.String category;
        java.lang.Object inputArtifactDetails;
        java.lang.Object outputArtifactDetails;
        java.lang.String provider;
        java.lang.String version;
        java.lang.Object configurationProperties;
        java.lang.Object settings;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getCategory}
         * @param category The category of the custom action, such as a build action or a test action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(java.lang.String category) {
            this.category = category;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getInputArtifactDetails}
         * @param inputArtifactDetails The details of the input artifact for the action, such as its commit ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifactDetails(software.amazon.awscdk.IResolvable inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getInputArtifactDetails}
         * @param inputArtifactDetails The details of the input artifact for the action, such as its commit ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifactDetails(software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getOutputArtifactDetails}
         * @param outputArtifactDetails The details of the output artifact of the action, such as its commit ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputArtifactDetails(software.amazon.awscdk.IResolvable outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getOutputArtifactDetails}
         * @param outputArtifactDetails The details of the output artifact of the action, such as its commit ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputArtifactDetails(software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getProvider}
         * @param provider The provider of the service used in the custom action, such as CodeDeploy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getVersion}
         * @param version The version identifier of the custom action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getConfigurationProperties}
         * @param configurationProperties The configuration properties for the custom action.
         *                                <blockquote>
         *                                <p>
         *                                You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a> .
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationProperties(software.amazon.awscdk.IResolvable configurationProperties) {
            this.configurationProperties = configurationProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getConfigurationProperties}
         * @param configurationProperties The configuration properties for the custom action.
         *                                <blockquote>
         *                                <p>
         *                                You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a> .
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationProperties(java.util.List<? extends java.lang.Object> configurationProperties) {
            this.configurationProperties = configurationProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getSettings}
         * @param settings URLs that provide users information about this custom action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(software.amazon.awscdk.IResolvable settings) {
            this.settings = settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getSettings}
         * @param settings URLs that provide users information about this custom action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(software.amazon.awscdk.services.codepipeline.CfnCustomActionType.SettingsProperty settings) {
            this.settings = settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomActionTypeProps#getTags}
         * @param tags The tags for the custom action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomActionTypeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomActionTypeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomActionTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomActionTypeProps {
        private final java.lang.String category;
        private final java.lang.Object inputArtifactDetails;
        private final java.lang.Object outputArtifactDetails;
        private final java.lang.String provider;
        private final java.lang.String version;
        private final java.lang.Object configurationProperties;
        private final java.lang.Object settings;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputArtifactDetails = software.amazon.jsii.Kernel.get(this, "inputArtifactDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outputArtifactDetails = software.amazon.jsii.Kernel.get(this, "outputArtifactDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationProperties = software.amazon.jsii.Kernel.get(this, "configurationProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.settings = software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
            this.inputArtifactDetails = java.util.Objects.requireNonNull(builder.inputArtifactDetails, "inputArtifactDetails is required");
            this.outputArtifactDetails = java.util.Objects.requireNonNull(builder.outputArtifactDetails, "outputArtifactDetails is required");
            this.provider = java.util.Objects.requireNonNull(builder.provider, "provider is required");
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.configurationProperties = builder.configurationProperties;
            this.settings = builder.settings;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCategory() {
            return this.category;
        }

        @Override
        public final java.lang.Object getInputArtifactDetails() {
            return this.inputArtifactDetails;
        }

        @Override
        public final java.lang.Object getOutputArtifactDetails() {
            return this.outputArtifactDetails;
        }

        @Override
        public final java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.Object getConfigurationProperties() {
            return this.configurationProperties;
        }

        @Override
        public final java.lang.Object getSettings() {
            return this.settings;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("category", om.valueToTree(this.getCategory()));
            data.set("inputArtifactDetails", om.valueToTree(this.getInputArtifactDetails()));
            data.set("outputArtifactDetails", om.valueToTree(this.getOutputArtifactDetails()));
            data.set("provider", om.valueToTree(this.getProvider()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getConfigurationProperties() != null) {
                data.set("configurationProperties", om.valueToTree(this.getConfigurationProperties()));
            }
            if (this.getSettings() != null) {
                data.set("settings", om.valueToTree(this.getSettings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnCustomActionTypeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomActionTypeProps.Jsii$Proxy that = (CfnCustomActionTypeProps.Jsii$Proxy) o;

            if (!category.equals(that.category)) return false;
            if (!inputArtifactDetails.equals(that.inputArtifactDetails)) return false;
            if (!outputArtifactDetails.equals(that.outputArtifactDetails)) return false;
            if (!provider.equals(that.provider)) return false;
            if (!version.equals(that.version)) return false;
            if (this.configurationProperties != null ? !this.configurationProperties.equals(that.configurationProperties) : that.configurationProperties != null) return false;
            if (this.settings != null ? !this.settings.equals(that.settings) : that.settings != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.category.hashCode();
            result = 31 * result + (this.inputArtifactDetails.hashCode());
            result = 31 * result + (this.outputArtifactDetails.hashCode());
            result = 31 * result + (this.provider.hashCode());
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.configurationProperties != null ? this.configurationProperties.hashCode() : 0);
            result = 31 * result + (this.settings != null ? this.settings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
