package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 * <p>
 * <strong>Note</strong>: this class is still experimental, and may have breaking changes in the future!
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact cdkBuildOutput = new Artifact();
 * ServiceCatalogDeployActionBeta1 serviceCatalogDeployAction = ServiceCatalogDeployActionBeta1.Builder.create()
 *         .actionName("ServiceCatalogDeploy")
 *         .templatePath(cdkBuildOutput.atPath("Sample.template.json"))
 *         .productVersionName("Version - " + Date.getNow().getToString())
 *         .productVersionDescription("This is a version from the pipeline with a new description.")
 *         .productId("prod-XXXXXXXX")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:51.660Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.ServiceCatalogDeployActionBeta1")
public class ServiceCatalogDeployActionBeta1 extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected ServiceCatalogDeployActionBeta1(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceCatalogDeployActionBeta1(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServiceCatalogDeployActionBeta1(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param _scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1Props.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1Props.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The identifier of the product in the Service Catalog.
         * <p>
         * This product must already exist.
         * <p>
         * @return {@code this}
         * @param productId The identifier of the product in the Service Catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(final java.lang.String productId) {
            this.props.productId(productId);
            return this;
        }

        /**
         * The name of the version of the Service Catalog product to be deployed.
         * <p>
         * @return {@code this}
         * @param productVersionName The name of the version of the Service Catalog product to be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productVersionName(final java.lang.String productVersionName) {
            this.props.productVersionName(productVersionName);
            return this;
        }

        /**
         * The path to the cloudformation artifact.
         * <p>
         * @return {@code this}
         * @param templatePath The path to the cloudformation artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templatePath(final software.amazon.awscdk.services.codepipeline.ArtifactPath templatePath) {
            this.props.templatePath(templatePath);
            return this;
        }

        /**
         * The optional description of this version of the Service Catalog product.
         * <p>
         * Default: ''
         * <p>
         * @return {@code this}
         * @param productVersionDescription The optional description of this version of the Service Catalog product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productVersionDescription(final java.lang.String productVersionDescription) {
            this.props.productVersionDescription(productVersionDescription);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1 build() {
            return new software.amazon.awscdk.services.codepipeline.actions.ServiceCatalogDeployActionBeta1(
                this.props.build()
            );
        }
    }
}
