package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Where Stack Instances will be created from the StackSet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline pipeline;
 * Artifact sourceOutput;
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("DeployStackSets")
 *         .actions(List.of(
 *             // First, update the StackSet itself with the newest template
 *             CloudFormationDeployStackSetAction.Builder.create()
 *                     .actionName("UpdateStackSet")
 *                     .runOrder(1)
 *                     .stackSetName("MyStackSet")
 *                     .template(StackSetTemplate.fromArtifactPath(sourceOutput.atPath("template.yaml")))
 *                     // Change this to 'StackSetDeploymentModel.organizations()' if you want to deploy to OUs
 *                     .deploymentModel(StackSetDeploymentModel.selfManaged())
 *                     // This deploys to a set of accounts
 *                     .stackInstances(StackInstances.inAccounts(List.of("111111111111"), List.of("us-east-1", "eu-west-1")))
 *                     .build(),
 *             // Afterwards, update/create additional instances in other accounts
 *             CloudFormationDeployStackInstancesAction.Builder.create()
 *                     .actionName("AddMoreInstances")
 *                     .runOrder(2)
 *                     .stackSetName("MyStackSet")
 *                     .stackInstances(StackInstances.inAccounts(List.of("222222222222", "333333333333"), List.of("us-east-1", "eu-west-1")))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:51.661Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.StackInstances")
public abstract class StackInstances extends software.amazon.jsii.JsiiObject {

    protected StackInstances(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StackInstances(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected StackInstances() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create stack instances in a set of accounts or organizational units taken from the pipeline artifacts, and a set of regions  The file must be a JSON file containing a list of strings.
     * <p>
     * For example:
     * <p>
     * <blockquote><pre>
     * [
     *   "111111111111",
     *   "222222222222",
     *   "333333333333"
     * ]
     * </pre></blockquote>
     * <p>
     * Stack Instances will be created in every combination of region and account, or region and
     * Organizational Units (OUs).
     * <p>
     * If this is set of Organizational Units, you must have selected <code>StackSetDeploymentModel.organizations()</code>
     * as deployment model.
     * <p>
     * @param artifactPath This parameter is required.
     * @param regions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackInstances fromArtifactPath(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ArtifactPath artifactPath, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> regions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class, "fromArtifactPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class), new Object[] { java.util.Objects.requireNonNull(artifactPath, "artifactPath is required"), java.util.Objects.requireNonNull(regions, "regions is required") });
    }

    /**
     * Create stack instances in a set of accounts and regions passed as literal lists.
     * <p>
     * Stack Instances will be created in every combination of region and account.
     * <p>
     * <blockquote>
     * <p>
     * NOTE: <code>StackInstances.inAccounts()</code> and <code>StackInstances.inOrganizationalUnits()</code>
     * have exactly the same behavior, and you can use them interchangeably if you want.
     * The only difference between them is that your code clearly indicates what entity
     * it's working with.
     * <p>
     * </blockquote>
     * <p>
     * @param accounts This parameter is required.
     * @param regions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackInstances inAccounts(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> accounts, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> regions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class, "inAccounts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class), new Object[] { java.util.Objects.requireNonNull(accounts, "accounts is required"), java.util.Objects.requireNonNull(regions, "regions is required") });
    }

    /**
     * Create stack instances in all accounts in a set of Organizational Units (OUs) and regions passed as literal lists.
     * <p>
     * If you want to deploy to Organization Units, you must choose have created the StackSet
     * with <code>deploymentModel: DeploymentModel.organizations()</code>.
     * <p>
     * Stack Instances will be created in every combination of region and account.
     * <p>
     * <blockquote>
     * <p>
     * NOTE: <code>StackInstances.inAccounts()</code> and <code>StackInstances.inOrganizationalUnits()</code>
     * have exactly the same behavior, and you can use them interchangeably if you want.
     * The only difference between them is that your code clearly indicates what entity
     * it's working with.
     * <p>
     * </blockquote>
     * <p>
     * @param ous This parameter is required.
     * @param regions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackInstances inOrganizationalUnits(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> ous, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> regions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class, "inOrganizationalUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class), new Object[] { java.util.Objects.requireNonNull(ous, "ous is required"), java.util.Objects.requireNonNull(regions, "regions is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codepipeline.actions.StackInstances {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
