package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Base parameters for the StackSet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StackSetParameters parameters = StackSetParameters.fromLiteral(Map.of(
 *         "BucketName", "my-bucket",
 *         "Asset1", "true"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:51.663Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.StackSetParameters")
public abstract class StackSetParameters extends software.amazon.jsii.JsiiObject {

    protected StackSetParameters(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StackSetParameters(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected StackSetParameters() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Read the parameters from a JSON file from one of the pipeline's artifacts.
     * <p>
     * The file needs to contain a list of <code>{ ParameterKey, ParameterValue, UsePreviousValue }</code> objects, like
     * this:
     * <p>
     * <blockquote><pre>
     * [
     *     {
     *         "ParameterKey": "BucketName",
     *         "ParameterValue": "my-bucket"
     *     },
     *     {
     *         "ParameterKey": "Asset1",
     *         "ParameterValue": "true"
     *     },
     *     {
     *         "ParameterKey": "Asset2",
     *         "UsePreviousValue": true
     *     }
     * ]
     * </pre></blockquote>
     * <p>
     * You must specify all template parameters. Parameters you don't specify will revert
     * to their <code>Default</code> values as specified in the template.
     * <p>
     * For of parameters you want to retain their existing values
     * without specifying what those values are, set <code>UsePreviousValue: true</code>.
     * Use of this feature is discouraged. CDK is for
     * specifying desired-state infrastructure, and use of this feature makes the
     * parameter values unmanaged.
     * <p>
     * @param artifactPath This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackSetParameters fromArtifactPath(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ArtifactPath artifactPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class, "fromArtifactPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class), new Object[] { java.util.Objects.requireNonNull(artifactPath, "artifactPath is required") });
    }

    /**
     * A list of template parameters for your stack set.
     * <p>
     * You must specify all template parameters. Parameters you don't specify will revert
     * to their <code>Default</code> values as specified in the template.
     * <p>
     * Specify the names of parameters you want to retain their existing values,
     * without specifying what those values are, in an array in the second
     * argument to this function. Use of this feature is discouraged. CDK is for
     * specifying desired-state infrastructure, and use of this feature makes the
     * parameter values unmanaged.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * StackSetParameters parameters = StackSetParameters.fromLiteral(Map.of(
     *         "BucketName", "my-bucket",
     *         "Asset1", "true"));
     * </pre></blockquote>
     * <p>
     * @param parameters This parameter is required.
     * @param usePreviousValues
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackSetParameters fromLiteral(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> parameters, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> usePreviousValues) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class, "fromLiteral", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class), new Object[] { java.util.Objects.requireNonNull(parameters, "parameters is required"), usePreviousValues });
    }

    /**
     * A list of template parameters for your stack set.
     * <p>
     * You must specify all template parameters. Parameters you don't specify will revert
     * to their <code>Default</code> values as specified in the template.
     * <p>
     * Specify the names of parameters you want to retain their existing values,
     * without specifying what those values are, in an array in the second
     * argument to this function. Use of this feature is discouraged. CDK is for
     * specifying desired-state infrastructure, and use of this feature makes the
     * parameter values unmanaged.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * StackSetParameters parameters = StackSetParameters.fromLiteral(Map.of(
     *         "BucketName", "my-bucket",
     *         "Asset1", "true"));
     * </pre></blockquote>
     * <p>
     * @param parameters This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackSetParameters fromLiteral(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> parameters) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class, "fromLiteral", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class), new Object[] { java.util.Objects.requireNonNull(parameters, "parameters is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codepipeline.actions.StackSetParameters {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
