package software.amazon.awscdk.services.customerprofiles;

/**
 * Specifies an Amazon Connect Customer Profiles Integration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnIntegration cfnIntegration = CfnIntegration.Builder.create(this, "MyCfnIntegration")
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .eventTriggerNames(List.of("eventTriggerNames"))
 *         .flowDefinition(FlowDefinitionProperty.builder()
 *                 .flowName("flowName")
 *                 .kmsArn("kmsArn")
 *                 .sourceFlowConfig(SourceFlowConfigProperty.builder()
 *                         .connectorType("connectorType")
 *                         .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
 *                                 .marketo(MarketoSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         .build())
 *                                 .s3(S3SourcePropertiesProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         // the properties below are optional
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .build())
 *                                 .salesforce(SalesforceSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         // the properties below are optional
 *                                         .enableDynamicFieldUpdate(false)
 *                                         .includeDeletedRecords(false)
 *                                         .build())
 *                                 .serviceNow(ServiceNowSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         .build())
 *                                 .zendesk(ZendeskSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .connectorProfileName("connectorProfileName")
 *                         .incrementalPullConfig(IncrementalPullConfigProperty.builder()
 *                                 .datetimeTypeFieldName("datetimeTypeFieldName")
 *                                 .build())
 *                         .build())
 *                 .tasks(List.of(TaskProperty.builder()
 *                         .sourceFields(List.of("sourceFields"))
 *                         .taskType("taskType")
 *                         // the properties below are optional
 *                         .connectorOperator(ConnectorOperatorProperty.builder()
 *                                 .marketo("marketo")
 *                                 .s3("s3")
 *                                 .salesforce("salesforce")
 *                                 .serviceNow("serviceNow")
 *                                 .zendesk("zendesk")
 *                                 .build())
 *                         .destinationField("destinationField")
 *                         .taskProperties(List.of(TaskPropertiesMapProperty.builder()
 *                                 .operatorPropertyKey("operatorPropertyKey")
 *                                 .property("property")
 *                                 .build()))
 *                         .build()))
 *                 .triggerConfig(TriggerConfigProperty.builder()
 *                         .triggerType("triggerType")
 *                         // the properties below are optional
 *                         .triggerProperties(TriggerPropertiesProperty.builder()
 *                                 .scheduled(ScheduledTriggerPropertiesProperty.builder()
 *                                         .scheduleExpression("scheduleExpression")
 *                                         // the properties below are optional
 *                                         .dataPullMode("dataPullMode")
 *                                         .firstExecutionFrom(123)
 *                                         .scheduleEndTime(123)
 *                                         .scheduleOffset(123)
 *                                         .scheduleStartTime(123)
 *                                         .timezone("timezone")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build())
 *         .objectTypeName("objectTypeName")
 *         .objectTypeNames(List.of(ObjectTypeMappingProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .uri("uri")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:52.165Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration")
public class CfnIntegration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.customerprofiles.CfnIntegration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.customerprofiles.CfnIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The timestamp of when the integration was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the integration was most recently edited.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The unique name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * A list of unique names for active event triggers associated with the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEventTriggerNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "eventTriggerNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of unique names for active event triggers associated with the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTriggerNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "eventTriggerNames", value);
    }

    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFlowDefinition() {
        return software.amazon.jsii.Kernel.get(this, "flowDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "flowDefinition", value);
    }

    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.customerprofiles.CfnIntegration.FlowDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "flowDefinition", value);
    }

    /**
     * The name of the profile object type mapping to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getObjectTypeName() {
        return software.amazon.jsii.Kernel.get(this, "objectTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the profile object type mapping to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectTypeName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "objectTypeName", value);
    }

    /**
     * The object type mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getObjectTypeNames() {
        return software.amazon.jsii.Kernel.get(this, "objectTypeNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The object type mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectTypeNames(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "objectTypeNames", value);
    }

    /**
     * The object type mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectTypeNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.customerprofiles.CfnIntegration.ObjectTypeMappingProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.customerprofiles.CfnIntegration.ObjectTypeMappingProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "objectTypeNames", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The URI of the S3 bucket or any other type of data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUri() {
        return software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URI of the S3 bucket or any other type of data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "uri", value);
    }
    /**
     * The operation to be performed on the provided source fields.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ConnectorOperatorProperty connectorOperatorProperty = ConnectorOperatorProperty.builder()
     *         .marketo("marketo")
     *         .s3("s3")
     *         .salesforce("salesforce")
     *         .serviceNow("serviceNow")
     *         .zendesk("zendesk")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.ConnectorOperatorProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorOperatorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorOperatorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operation to be performed on the provided Marketo source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-marketo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-marketo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarketo() {
            return null;
        }

        /**
         * The operation to be performed on the provided Amazon S3 source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3() {
            return null;
        }

        /**
         * The operation to be performed on the provided Salesforce source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-salesforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-salesforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSalesforce() {
            return null;
        }

        /**
         * The operation to be performed on the provided ServiceNow source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-servicenow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-servicenow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceNow() {
            return null;
        }

        /**
         * The operation to be performed on the provided Zendesk source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-zendesk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-zendesk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorOperatorProperty> {
            java.lang.String marketo;
            java.lang.String s3;
            java.lang.String salesforce;
            java.lang.String serviceNow;
            java.lang.String zendesk;

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getMarketo}
             * @param marketo The operation to be performed on the provided Marketo source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(java.lang.String marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getS3}
             * @param s3 The operation to be performed on the provided Amazon S3 source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(java.lang.String s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSalesforce}
             * @param salesforce The operation to be performed on the provided Salesforce source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(java.lang.String salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getServiceNow}
             * @param serviceNow The operation to be performed on the provided ServiceNow source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(java.lang.String serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getZendesk}
             * @param zendesk The operation to be performed on the provided Zendesk source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(java.lang.String zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorOperatorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorOperatorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorOperatorProperty {
            private final java.lang.String marketo;
            private final java.lang.String s3;
            private final java.lang.String salesforce;
            private final java.lang.String serviceNow;
            private final java.lang.String zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.marketo = builder.marketo;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.serviceNow = builder.serviceNow;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.String getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.String getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.String getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.String getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.String getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.ConnectorOperatorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorOperatorProperty.Jsii$Proxy that = (ConnectorOperatorProperty.Jsii$Proxy) o;

                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.marketo != null ? this.marketo.hashCode() : 0;
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configurations that control how Customer Profiles retrieves data from the source, Amazon AppFlow.
     * <p>
     * Customer Profiles uses this information to create an AppFlow flow on behalf of customers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * FlowDefinitionProperty flowDefinitionProperty = FlowDefinitionProperty.builder()
     *         .flowName("flowName")
     *         .kmsArn("kmsArn")
     *         .sourceFlowConfig(SourceFlowConfigProperty.builder()
     *                 .connectorType("connectorType")
     *                 .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
     *                         .marketo(MarketoSourcePropertiesProperty.builder()
     *                                 .object("object")
     *                                 .build())
     *                         .s3(S3SourcePropertiesProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 // the properties below are optional
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .build())
     *                         .salesforce(SalesforceSourcePropertiesProperty.builder()
     *                                 .object("object")
     *                                 // the properties below are optional
     *                                 .enableDynamicFieldUpdate(false)
     *                                 .includeDeletedRecords(false)
     *                                 .build())
     *                         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
     *                                 .object("object")
     *                                 .build())
     *                         .zendesk(ZendeskSourcePropertiesProperty.builder()
     *                                 .object("object")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .connectorProfileName("connectorProfileName")
     *                 .incrementalPullConfig(IncrementalPullConfigProperty.builder()
     *                         .datetimeTypeFieldName("datetimeTypeFieldName")
     *                         .build())
     *                 .build())
     *         .tasks(List.of(TaskProperty.builder()
     *                 .sourceFields(List.of("sourceFields"))
     *                 .taskType("taskType")
     *                 // the properties below are optional
     *                 .connectorOperator(ConnectorOperatorProperty.builder()
     *                         .marketo("marketo")
     *                         .s3("s3")
     *                         .salesforce("salesforce")
     *                         .serviceNow("serviceNow")
     *                         .zendesk("zendesk")
     *                         .build())
     *                 .destinationField("destinationField")
     *                 .taskProperties(List.of(TaskPropertiesMapProperty.builder()
     *                         .operatorPropertyKey("operatorPropertyKey")
     *                         .property("property")
     *                         .build()))
     *                 .build()))
     *         .triggerConfig(TriggerConfigProperty.builder()
     *                 .triggerType("triggerType")
     *                 // the properties below are optional
     *                 .triggerProperties(TriggerPropertiesProperty.builder()
     *                         .scheduled(ScheduledTriggerPropertiesProperty.builder()
     *                                 .scheduleExpression("scheduleExpression")
     *                                 // the properties below are optional
     *                                 .dataPullMode("dataPullMode")
     *                                 .firstExecutionFrom(123)
     *                                 .scheduleEndTime(123)
     *                                 .scheduleOffset(123)
     *                                 .scheduleStartTime(123)
     *                                 .timezone("timezone")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.FlowDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specified name of the flow.
         * <p>
         * Use underscores (_) or hyphens (-) only. Spaces are not allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-flowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-flowname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFlowName();

        /**
         * The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key you provide for encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-kmsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-kmsarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKmsArn();

        /**
         * The configuration that controls how Customer Profiles retrieves data from the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-sourceflowconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-sourceflowconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceFlowConfig();

        /**
         * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-tasks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-tasks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTasks();

        /**
         * The trigger settings that determine how and when the flow runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-triggerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-triggerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTriggerConfig();

        /**
         * A description of the flow you want to create.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowDefinitionProperty> {
            java.lang.String flowName;
            java.lang.String kmsArn;
            java.lang.Object sourceFlowConfig;
            java.lang.Object tasks;
            java.lang.Object triggerConfig;
            java.lang.String description;

            /**
             * Sets the value of {@link FlowDefinitionProperty#getFlowName}
             * @param flowName The specified name of the flow. This parameter is required.
             *                 Use underscores (_) or hyphens (-) only. Spaces are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowName(java.lang.String flowName) {
                this.flowName = flowName;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getKmsArn}
             * @param kmsArn The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key you provide for encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsArn(java.lang.String kmsArn) {
                this.kmsArn = kmsArn;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getSourceFlowConfig}
             * @param sourceFlowConfig The configuration that controls how Customer Profiles retrieves data from the source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFlowConfig(software.amazon.awscdk.IResolvable sourceFlowConfig) {
                this.sourceFlowConfig = sourceFlowConfig;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getSourceFlowConfig}
             * @param sourceFlowConfig The configuration that controls how Customer Profiles retrieves data from the source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFlowConfig(software.amazon.awscdk.services.customerprofiles.CfnIntegration.SourceFlowConfigProperty sourceFlowConfig) {
                this.sourceFlowConfig = sourceFlowConfig;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getTasks}
             * @param tasks A list of tasks that Customer Profiles performs while transferring the data in the flow run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tasks(software.amazon.awscdk.IResolvable tasks) {
                this.tasks = tasks;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getTasks}
             * @param tasks A list of tasks that Customer Profiles performs while transferring the data in the flow run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tasks(java.util.List<? extends java.lang.Object> tasks) {
                this.tasks = tasks;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getTriggerConfig}
             * @param triggerConfig The trigger settings that determine how and when the flow runs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerConfig(software.amazon.awscdk.IResolvable triggerConfig) {
                this.triggerConfig = triggerConfig;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getTriggerConfig}
             * @param triggerConfig The trigger settings that determine how and when the flow runs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerConfig(software.amazon.awscdk.services.customerprofiles.CfnIntegration.TriggerConfigProperty triggerConfig) {
                this.triggerConfig = triggerConfig;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getDescription}
             * @param description A description of the flow you want to create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowDefinitionProperty {
            private final java.lang.String flowName;
            private final java.lang.String kmsArn;
            private final java.lang.Object sourceFlowConfig;
            private final java.lang.Object tasks;
            private final java.lang.Object triggerConfig;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.flowName = software.amazon.jsii.Kernel.get(this, "flowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsArn = software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceFlowConfig = software.amazon.jsii.Kernel.get(this, "sourceFlowConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tasks = software.amazon.jsii.Kernel.get(this, "tasks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.triggerConfig = software.amazon.jsii.Kernel.get(this, "triggerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.flowName = java.util.Objects.requireNonNull(builder.flowName, "flowName is required");
                this.kmsArn = java.util.Objects.requireNonNull(builder.kmsArn, "kmsArn is required");
                this.sourceFlowConfig = java.util.Objects.requireNonNull(builder.sourceFlowConfig, "sourceFlowConfig is required");
                this.tasks = java.util.Objects.requireNonNull(builder.tasks, "tasks is required");
                this.triggerConfig = java.util.Objects.requireNonNull(builder.triggerConfig, "triggerConfig is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getFlowName() {
                return this.flowName;
            }

            @Override
            public final java.lang.String getKmsArn() {
                return this.kmsArn;
            }

            @Override
            public final java.lang.Object getSourceFlowConfig() {
                return this.sourceFlowConfig;
            }

            @Override
            public final java.lang.Object getTasks() {
                return this.tasks;
            }

            @Override
            public final java.lang.Object getTriggerConfig() {
                return this.triggerConfig;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("flowName", om.valueToTree(this.getFlowName()));
                data.set("kmsArn", om.valueToTree(this.getKmsArn()));
                data.set("sourceFlowConfig", om.valueToTree(this.getSourceFlowConfig()));
                data.set("tasks", om.valueToTree(this.getTasks()));
                data.set("triggerConfig", om.valueToTree(this.getTriggerConfig()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.FlowDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowDefinitionProperty.Jsii$Proxy that = (FlowDefinitionProperty.Jsii$Proxy) o;

                if (!flowName.equals(that.flowName)) return false;
                if (!kmsArn.equals(that.kmsArn)) return false;
                if (!sourceFlowConfig.equals(that.sourceFlowConfig)) return false;
                if (!tasks.equals(that.tasks)) return false;
                if (!triggerConfig.equals(that.triggerConfig)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.flowName.hashCode();
                result = 31 * result + (this.kmsArn.hashCode());
                result = 31 * result + (this.sourceFlowConfig.hashCode());
                result = 31 * result + (this.tasks.hashCode());
                result = 31 * result + (this.triggerConfig.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration used when importing incremental records from the source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * IncrementalPullConfigProperty incrementalPullConfigProperty = IncrementalPullConfigProperty.builder()
     *         .datetimeTypeFieldName("datetimeTypeFieldName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-incrementalpullconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-incrementalpullconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.IncrementalPullConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IncrementalPullConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncrementalPullConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-incrementalpullconfig.html#cfn-customerprofiles-integration-incrementalpullconfig-datetimetypefieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-incrementalpullconfig.html#cfn-customerprofiles-integration-incrementalpullconfig-datetimetypefieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatetimeTypeFieldName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncrementalPullConfigProperty> {
            java.lang.String datetimeTypeFieldName;

            /**
             * Sets the value of {@link IncrementalPullConfigProperty#getDatetimeTypeFieldName}
             * @param datetimeTypeFieldName A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datetimeTypeFieldName(java.lang.String datetimeTypeFieldName) {
                this.datetimeTypeFieldName = datetimeTypeFieldName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncrementalPullConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncrementalPullConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncrementalPullConfigProperty {
            private final java.lang.String datetimeTypeFieldName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datetimeTypeFieldName = software.amazon.jsii.Kernel.get(this, "datetimeTypeFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datetimeTypeFieldName = builder.datetimeTypeFieldName;
            }

            @Override
            public final java.lang.String getDatetimeTypeFieldName() {
                return this.datetimeTypeFieldName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatetimeTypeFieldName() != null) {
                    data.set("datetimeTypeFieldName", om.valueToTree(this.getDatetimeTypeFieldName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.IncrementalPullConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncrementalPullConfigProperty.Jsii$Proxy that = (IncrementalPullConfigProperty.Jsii$Proxy) o;

                return this.datetimeTypeFieldName != null ? this.datetimeTypeFieldName.equals(that.datetimeTypeFieldName) : that.datetimeTypeFieldName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.datetimeTypeFieldName != null ? this.datetimeTypeFieldName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Marketo is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * MarketoSourcePropertiesProperty marketoSourcePropertiesProperty = MarketoSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-marketosourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-marketosourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.MarketoSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Marketo flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-marketosourceproperties.html#cfn-customerprofiles-integration-marketosourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-marketosourceproperties.html#cfn-customerprofiles-integration-marketosourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link MarketoSourcePropertiesProperty#getObject}
             * @param object The object specified in the Marketo flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.MarketoSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoSourcePropertiesProperty.Jsii$Proxy that = (MarketoSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ObjectTypeMappingProperty objectTypeMappingProperty = ObjectTypeMappingProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-objecttypemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-objecttypemapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.ObjectTypeMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ObjectTypeMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectTypeMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-objecttypemapping.html#cfn-customerprofiles-integration-objecttypemapping-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-objecttypemapping.html#cfn-customerprofiles-integration-objecttypemapping-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-objecttypemapping.html#cfn-customerprofiles-integration-objecttypemapping-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-objecttypemapping.html#cfn-customerprofiles-integration-objecttypemapping-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ObjectTypeMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObjectTypeMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObjectTypeMappingProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ObjectTypeMappingProperty#getKey}
             * @param key The key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ObjectTypeMappingProperty#getValue}
             * @param value The value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectTypeMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObjectTypeMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObjectTypeMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectTypeMappingProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.ObjectTypeMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectTypeMappingProperty.Jsii$Proxy that = (ObjectTypeMappingProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon S3 is being used as the flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * S3SourcePropertiesProperty s3SourcePropertiesProperty = S3SourcePropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.S3SourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name where the source files are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html#cfn-customerprofiles-integration-s3sourceproperties-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html#cfn-customerprofiles-integration-s3sourceproperties-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The object key for the Amazon S3 bucket in which the source files are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html#cfn-customerprofiles-integration-s3sourceproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html#cfn-customerprofiles-integration-s3sourceproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SourcePropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getBucketName}
             * @param bucketName The Amazon S3 bucket name where the source files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the Amazon S3 bucket in which the source files are stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourcePropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.bucketPrefix = builder.bucketPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.S3SourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SourcePropertiesProperty.Jsii$Proxy that = (S3SourcePropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.bucketPrefix != null ? this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Salesforce is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * SalesforceSourcePropertiesProperty salesforceSourcePropertiesProperty = SalesforceSourcePropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .enableDynamicFieldUpdate(false)
     *         .includeDeletedRecords(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.SalesforceSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Salesforce flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-enabledynamicfieldupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-enabledynamicfieldupdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDynamicFieldUpdate() {
            return null;
        }

        /**
         * Indicates whether Amazon AppFlow includes deleted files in the flow run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-includedeletedrecords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-includedeletedrecords</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeDeletedRecords() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceSourcePropertiesProperty> {
            java.lang.String object;
            java.lang.Object enableDynamicFieldUpdate;
            java.lang.Object includeDeletedRecords;

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getObject}
             * @param object The object specified in the Salesforce flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getEnableDynamicFieldUpdate}
             * @param enableDynamicFieldUpdate The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDynamicFieldUpdate(java.lang.Boolean enableDynamicFieldUpdate) {
                this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getEnableDynamicFieldUpdate}
             * @param enableDynamicFieldUpdate The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDynamicFieldUpdate(software.amazon.awscdk.IResolvable enableDynamicFieldUpdate) {
                this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getIncludeDeletedRecords}
             * @param includeDeletedRecords Indicates whether Amazon AppFlow includes deleted files in the flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDeletedRecords(java.lang.Boolean includeDeletedRecords) {
                this.includeDeletedRecords = includeDeletedRecords;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getIncludeDeletedRecords}
             * @param includeDeletedRecords Indicates whether Amazon AppFlow includes deleted files in the flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDeletedRecords(software.amazon.awscdk.IResolvable includeDeletedRecords) {
                this.includeDeletedRecords = includeDeletedRecords;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceSourcePropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object enableDynamicFieldUpdate;
            private final java.lang.Object includeDeletedRecords;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableDynamicFieldUpdate = software.amazon.jsii.Kernel.get(this, "enableDynamicFieldUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeDeletedRecords = software.amazon.jsii.Kernel.get(this, "includeDeletedRecords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.enableDynamicFieldUpdate = builder.enableDynamicFieldUpdate;
                this.includeDeletedRecords = builder.includeDeletedRecords;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getEnableDynamicFieldUpdate() {
                return this.enableDynamicFieldUpdate;
            }

            @Override
            public final java.lang.Object getIncludeDeletedRecords() {
                return this.includeDeletedRecords;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getEnableDynamicFieldUpdate() != null) {
                    data.set("enableDynamicFieldUpdate", om.valueToTree(this.getEnableDynamicFieldUpdate()));
                }
                if (this.getIncludeDeletedRecords() != null) {
                    data.set("includeDeletedRecords", om.valueToTree(this.getIncludeDeletedRecords()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.SalesforceSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceSourcePropertiesProperty.Jsii$Proxy that = (SalesforceSourcePropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.enableDynamicFieldUpdate != null ? !this.enableDynamicFieldUpdate.equals(that.enableDynamicFieldUpdate) : that.enableDynamicFieldUpdate != null) return false;
                return this.includeDeletedRecords != null ? this.includeDeletedRecords.equals(that.includeDeletedRecords) : that.includeDeletedRecords == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.enableDynamicFieldUpdate != null ? this.enableDynamicFieldUpdate.hashCode() : 0);
                result = 31 * result + (this.includeDeletedRecords != null ? this.includeDeletedRecords.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration details of a scheduled-trigger flow that you define.
     * <p>
     * Currently, these settings only apply to the scheduled-trigger type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ScheduledTriggerPropertiesProperty scheduledTriggerPropertiesProperty = ScheduledTriggerPropertiesProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         // the properties below are optional
     *         .dataPullMode("dataPullMode")
     *         .firstExecutionFrom(123)
     *         .scheduleEndTime(123)
     *         .scheduleOffset(123)
     *         .scheduleStartTime(123)
     *         .timezone("timezone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.ScheduledTriggerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduledTriggerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduledTriggerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scheduling expression that determines the rate at which the schedule will run, for example rate (5 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-datapullmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-datapullmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataPullMode() {
            return null;
        }

        /**
         * Specifies the date range for the records to import from the connector in the first flow run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-firstexecutionfrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-firstexecutionfrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFirstExecutionFrom() {
            return null;
        }

        /**
         * Specifies the scheduled end time for a scheduled-trigger flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleendtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleendtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleEndTime() {
            return null;
        }

        /**
         * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleOffset() {
            return null;
        }

        /**
         * Specifies the scheduled start time for a scheduled-trigger flow.
         * <p>
         * The value must be a date/time value in EPOCH format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-schedulestarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-schedulestarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleStartTime() {
            return null;
        }

        /**
         * Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as America/New_York.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduledTriggerPropertiesProperty> {
            java.lang.String scheduleExpression;
            java.lang.String dataPullMode;
            java.lang.Number firstExecutionFrom;
            java.lang.Number scheduleEndTime;
            java.lang.Number scheduleOffset;
            java.lang.Number scheduleStartTime;
            java.lang.String timezone;

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleExpression}
             * @param scheduleExpression The scheduling expression that determines the rate at which the schedule will run, for example rate (5 minutes). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getDataPullMode}
             * @param dataPullMode Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataPullMode(java.lang.String dataPullMode) {
                this.dataPullMode = dataPullMode;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getFirstExecutionFrom}
             * @param firstExecutionFrom Specifies the date range for the records to import from the connector in the first flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstExecutionFrom(java.lang.Number firstExecutionFrom) {
                this.firstExecutionFrom = firstExecutionFrom;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleEndTime}
             * @param scheduleEndTime Specifies the scheduled end time for a scheduled-trigger flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleEndTime(java.lang.Number scheduleEndTime) {
                this.scheduleEndTime = scheduleEndTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleOffset}
             * @param scheduleOffset Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleOffset(java.lang.Number scheduleOffset) {
                this.scheduleOffset = scheduleOffset;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleStartTime}
             * @param scheduleStartTime Specifies the scheduled start time for a scheduled-trigger flow.
             *                          The value must be a date/time value in EPOCH format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleStartTime(java.lang.Number scheduleStartTime) {
                this.scheduleStartTime = scheduleStartTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getTimezone}
             * @param timezone Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as America/New_York.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timezone(java.lang.String timezone) {
                this.timezone = timezone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduledTriggerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduledTriggerPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledTriggerPropertiesProperty {
            private final java.lang.String scheduleExpression;
            private final java.lang.String dataPullMode;
            private final java.lang.Number firstExecutionFrom;
            private final java.lang.Number scheduleEndTime;
            private final java.lang.Number scheduleOffset;
            private final java.lang.Number scheduleStartTime;
            private final java.lang.String timezone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataPullMode = software.amazon.jsii.Kernel.get(this, "dataPullMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firstExecutionFrom = software.amazon.jsii.Kernel.get(this, "firstExecutionFrom", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleEndTime = software.amazon.jsii.Kernel.get(this, "scheduleEndTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleOffset = software.amazon.jsii.Kernel.get(this, "scheduleOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleStartTime = software.amazon.jsii.Kernel.get(this, "scheduleStartTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
                this.dataPullMode = builder.dataPullMode;
                this.firstExecutionFrom = builder.firstExecutionFrom;
                this.scheduleEndTime = builder.scheduleEndTime;
                this.scheduleOffset = builder.scheduleOffset;
                this.scheduleStartTime = builder.scheduleStartTime;
                this.timezone = builder.timezone;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            public final java.lang.String getDataPullMode() {
                return this.dataPullMode;
            }

            @Override
            public final java.lang.Number getFirstExecutionFrom() {
                return this.firstExecutionFrom;
            }

            @Override
            public final java.lang.Number getScheduleEndTime() {
                return this.scheduleEndTime;
            }

            @Override
            public final java.lang.Number getScheduleOffset() {
                return this.scheduleOffset;
            }

            @Override
            public final java.lang.Number getScheduleStartTime() {
                return this.scheduleStartTime;
            }

            @Override
            public final java.lang.String getTimezone() {
                return this.timezone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                if (this.getDataPullMode() != null) {
                    data.set("dataPullMode", om.valueToTree(this.getDataPullMode()));
                }
                if (this.getFirstExecutionFrom() != null) {
                    data.set("firstExecutionFrom", om.valueToTree(this.getFirstExecutionFrom()));
                }
                if (this.getScheduleEndTime() != null) {
                    data.set("scheduleEndTime", om.valueToTree(this.getScheduleEndTime()));
                }
                if (this.getScheduleOffset() != null) {
                    data.set("scheduleOffset", om.valueToTree(this.getScheduleOffset()));
                }
                if (this.getScheduleStartTime() != null) {
                    data.set("scheduleStartTime", om.valueToTree(this.getScheduleStartTime()));
                }
                if (this.getTimezone() != null) {
                    data.set("timezone", om.valueToTree(this.getTimezone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.ScheduledTriggerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduledTriggerPropertiesProperty.Jsii$Proxy that = (ScheduledTriggerPropertiesProperty.Jsii$Proxy) o;

                if (!scheduleExpression.equals(that.scheduleExpression)) return false;
                if (this.dataPullMode != null ? !this.dataPullMode.equals(that.dataPullMode) : that.dataPullMode != null) return false;
                if (this.firstExecutionFrom != null ? !this.firstExecutionFrom.equals(that.firstExecutionFrom) : that.firstExecutionFrom != null) return false;
                if (this.scheduleEndTime != null ? !this.scheduleEndTime.equals(that.scheduleEndTime) : that.scheduleEndTime != null) return false;
                if (this.scheduleOffset != null ? !this.scheduleOffset.equals(that.scheduleOffset) : that.scheduleOffset != null) return false;
                if (this.scheduleStartTime != null ? !this.scheduleStartTime.equals(that.scheduleStartTime) : that.scheduleStartTime != null) return false;
                return this.timezone != null ? this.timezone.equals(that.timezone) : that.timezone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                result = 31 * result + (this.dataPullMode != null ? this.dataPullMode.hashCode() : 0);
                result = 31 * result + (this.firstExecutionFrom != null ? this.firstExecutionFrom.hashCode() : 0);
                result = 31 * result + (this.scheduleEndTime != null ? this.scheduleEndTime.hashCode() : 0);
                result = 31 * result + (this.scheduleOffset != null ? this.scheduleOffset.hashCode() : 0);
                result = 31 * result + (this.scheduleStartTime != null ? this.scheduleStartTime.hashCode() : 0);
                result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when ServiceNow is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ServiceNowSourcePropertiesProperty serviceNowSourcePropertiesProperty = ServiceNowSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-servicenowsourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-servicenowsourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.ServiceNowSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the ServiceNow flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-servicenowsourceproperties.html#cfn-customerprofiles-integration-servicenowsourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-servicenowsourceproperties.html#cfn-customerprofiles-integration-servicenowsourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link ServiceNowSourcePropertiesProperty#getObject}
             * @param object The object specified in the ServiceNow flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.ServiceNowSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowSourcePropertiesProperty.Jsii$Proxy that = (ServiceNowSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the information that is required to query a particular Amazon AppFlow connector.
     * <p>
     * Customer Profiles supports Salesforce, Zendesk, Marketo, ServiceNow and Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * SourceConnectorPropertiesProperty sourceConnectorPropertiesProperty = SourceConnectorPropertiesProperty.builder()
     *         .marketo(MarketoSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .s3(S3SourcePropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .build())
     *         .salesforce(SalesforceSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .enableDynamicFieldUpdate(false)
     *                 .includeDeletedRecords(false)
     *                 .build())
     *         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .zendesk(ZendeskSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.SourceConnectorPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConnectorPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConnectorPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties that are applied when Marketo is being used as a source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-marketo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-marketo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * The properties that are applied when Amazon S3 is being used as the flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * The properties that are applied when Salesforce is being used as a source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-salesforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-salesforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * The properties that are applied when ServiceNow is being used as a source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-servicenow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-servicenow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNow() {
            return null;
        }

        /**
         * The properties that are applied when using Zendesk as a flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-zendesk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-zendesk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConnectorPropertiesProperty> {
            java.lang.Object marketo;
            java.lang.Object s3;
            java.lang.Object salesforce;
            java.lang.Object serviceNow;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getMarketo}
             * @param marketo The properties that are applied when Marketo is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getMarketo}
             * @param marketo The properties that are applied when Marketo is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.customerprofiles.CfnIntegration.MarketoSourcePropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getS3}
             * @param s3 The properties that are applied when Amazon S3 is being used as the flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getS3}
             * @param s3 The properties that are applied when Amazon S3 is being used as the flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.customerprofiles.CfnIntegration.S3SourcePropertiesProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSalesforce}
             * @param salesforce The properties that are applied when Salesforce is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSalesforce}
             * @param salesforce The properties that are applied when Salesforce is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.customerprofiles.CfnIntegration.SalesforceSourcePropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getServiceNow}
             * @param serviceNow The properties that are applied when ServiceNow is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getServiceNow}
             * @param serviceNow The properties that are applied when ServiceNow is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.services.customerprofiles.CfnIntegration.ServiceNowSourcePropertiesProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getZendesk}
             * @param zendesk The properties that are applied when using Zendesk as a flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getZendesk}
             * @param zendesk The properties that are applied when using Zendesk as a flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.customerprofiles.CfnIntegration.ZendeskSourcePropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConnectorPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConnectorPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConnectorPropertiesProperty {
            private final java.lang.Object marketo;
            private final java.lang.Object s3;
            private final java.lang.Object salesforce;
            private final java.lang.Object serviceNow;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.marketo = builder.marketo;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.serviceNow = builder.serviceNow;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.SourceConnectorPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConnectorPropertiesProperty.Jsii$Proxy that = (SourceConnectorPropertiesProperty.Jsii$Proxy) o;

                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.marketo != null ? this.marketo.hashCode() : 0;
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * SourceFlowConfigProperty sourceFlowConfigProperty = SourceFlowConfigProperty.builder()
     *         .connectorType("connectorType")
     *         .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
     *                 .marketo(MarketoSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .s3(S3SourcePropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .build())
     *                 .salesforce(SalesforceSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .enableDynamicFieldUpdate(false)
     *                         .includeDeletedRecords(false)
     *                         .build())
     *                 .serviceNow(ServiceNowSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .zendesk(ZendeskSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .connectorProfileName("connectorProfileName")
     *         .incrementalPullConfig(IncrementalPullConfigProperty.builder()
     *                 .datetimeTypeFieldName("datetimeTypeFieldName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.SourceFlowConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceFlowConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceFlowConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of connector, such as Salesforce, Marketo, and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-connectortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-connectortype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectorType();

        /**
         * Specifies the information that is required to query a particular source connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-sourceconnectorproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-sourceconnectorproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConnectorProperties();

        /**
         * The name of the Amazon AppFlow connector profile.
         * <p>
         * This name must be unique for each connector profile in the AWS account .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-connectorprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-connectorprofilename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectorProfileName() {
            return null;
        }

        /**
         * Defines the configuration for a scheduled incremental data pull.
         * <p>
         * If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-incrementalpullconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-incrementalpullconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncrementalPullConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceFlowConfigProperty> {
            java.lang.String connectorType;
            java.lang.Object sourceConnectorProperties;
            java.lang.String connectorProfileName;
            java.lang.Object incrementalPullConfig;

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getConnectorType}
             * @param connectorType The type of connector, such as Salesforce, Marketo, and so on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorType(java.lang.String connectorType) {
                this.connectorType = connectorType;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getSourceConnectorProperties}
             * @param sourceConnectorProperties Specifies the information that is required to query a particular source connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConnectorProperties(software.amazon.awscdk.IResolvable sourceConnectorProperties) {
                this.sourceConnectorProperties = sourceConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getSourceConnectorProperties}
             * @param sourceConnectorProperties Specifies the information that is required to query a particular source connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConnectorProperties(software.amazon.awscdk.services.customerprofiles.CfnIntegration.SourceConnectorPropertiesProperty sourceConnectorProperties) {
                this.sourceConnectorProperties = sourceConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getConnectorProfileName}
             * @param connectorProfileName The name of the Amazon AppFlow connector profile.
             *                             This name must be unique for each connector profile in the AWS account .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileName(java.lang.String connectorProfileName) {
                this.connectorProfileName = connectorProfileName;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getIncrementalPullConfig}
             * @param incrementalPullConfig Defines the configuration for a scheduled incremental data pull.
             *                              If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalPullConfig(software.amazon.awscdk.IResolvable incrementalPullConfig) {
                this.incrementalPullConfig = incrementalPullConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getIncrementalPullConfig}
             * @param incrementalPullConfig Defines the configuration for a scheduled incremental data pull.
             *                              If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalPullConfig(software.amazon.awscdk.services.customerprofiles.CfnIntegration.IncrementalPullConfigProperty incrementalPullConfig) {
                this.incrementalPullConfig = incrementalPullConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceFlowConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceFlowConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceFlowConfigProperty {
            private final java.lang.String connectorType;
            private final java.lang.Object sourceConnectorProperties;
            private final java.lang.String connectorProfileName;
            private final java.lang.Object incrementalPullConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorType = software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceConnectorProperties = software.amazon.jsii.Kernel.get(this, "sourceConnectorProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectorProfileName = software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.incrementalPullConfig = software.amazon.jsii.Kernel.get(this, "incrementalPullConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorType = java.util.Objects.requireNonNull(builder.connectorType, "connectorType is required");
                this.sourceConnectorProperties = java.util.Objects.requireNonNull(builder.sourceConnectorProperties, "sourceConnectorProperties is required");
                this.connectorProfileName = builder.connectorProfileName;
                this.incrementalPullConfig = builder.incrementalPullConfig;
            }

            @Override
            public final java.lang.String getConnectorType() {
                return this.connectorType;
            }

            @Override
            public final java.lang.Object getSourceConnectorProperties() {
                return this.sourceConnectorProperties;
            }

            @Override
            public final java.lang.String getConnectorProfileName() {
                return this.connectorProfileName;
            }

            @Override
            public final java.lang.Object getIncrementalPullConfig() {
                return this.incrementalPullConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectorType", om.valueToTree(this.getConnectorType()));
                data.set("sourceConnectorProperties", om.valueToTree(this.getSourceConnectorProperties()));
                if (this.getConnectorProfileName() != null) {
                    data.set("connectorProfileName", om.valueToTree(this.getConnectorProfileName()));
                }
                if (this.getIncrementalPullConfig() != null) {
                    data.set("incrementalPullConfig", om.valueToTree(this.getIncrementalPullConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.SourceFlowConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceFlowConfigProperty.Jsii$Proxy that = (SourceFlowConfigProperty.Jsii$Proxy) o;

                if (!connectorType.equals(that.connectorType)) return false;
                if (!sourceConnectorProperties.equals(that.sourceConnectorProperties)) return false;
                if (this.connectorProfileName != null ? !this.connectorProfileName.equals(that.connectorProfileName) : that.connectorProfileName != null) return false;
                return this.incrementalPullConfig != null ? this.incrementalPullConfig.equals(that.incrementalPullConfig) : that.incrementalPullConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorType.hashCode();
                result = 31 * result + (this.sourceConnectorProperties.hashCode());
                result = 31 * result + (this.connectorProfileName != null ? this.connectorProfileName.hashCode() : 0);
                result = 31 * result + (this.incrementalPullConfig != null ? this.incrementalPullConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A map used to store task-related information.
     * <p>
     * The execution service looks for particular information based on the <code>TaskType</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * TaskPropertiesMapProperty taskPropertiesMapProperty = TaskPropertiesMapProperty.builder()
     *         .operatorPropertyKey("operatorPropertyKey")
     *         .property("property")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.TaskPropertiesMapProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskPropertiesMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskPropertiesMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The task property key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html#cfn-customerprofiles-integration-taskpropertiesmap-operatorpropertykey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html#cfn-customerprofiles-integration-taskpropertiesmap-operatorpropertykey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperatorPropertyKey();

        /**
         * The task property value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html#cfn-customerprofiles-integration-taskpropertiesmap-property">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html#cfn-customerprofiles-integration-taskpropertiesmap-property</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProperty();

        /**
         * @return a {@link Builder} of {@link TaskPropertiesMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskPropertiesMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskPropertiesMapProperty> {
            java.lang.String operatorPropertyKey;
            java.lang.String property;

            /**
             * Sets the value of {@link TaskPropertiesMapProperty#getOperatorPropertyKey}
             * @param operatorPropertyKey The task property key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operatorPropertyKey(java.lang.String operatorPropertyKey) {
                this.operatorPropertyKey = operatorPropertyKey;
                return this;
            }

            /**
             * Sets the value of {@link TaskPropertiesMapProperty#getProperty}
             * @param property The task property value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder property(java.lang.String property) {
                this.property = property;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskPropertiesMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskPropertiesMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskPropertiesMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskPropertiesMapProperty {
            private final java.lang.String operatorPropertyKey;
            private final java.lang.String property;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operatorPropertyKey = software.amazon.jsii.Kernel.get(this, "operatorPropertyKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.property = software.amazon.jsii.Kernel.get(this, "property", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operatorPropertyKey = java.util.Objects.requireNonNull(builder.operatorPropertyKey, "operatorPropertyKey is required");
                this.property = java.util.Objects.requireNonNull(builder.property, "property is required");
            }

            @Override
            public final java.lang.String getOperatorPropertyKey() {
                return this.operatorPropertyKey;
            }

            @Override
            public final java.lang.String getProperty() {
                return this.property;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operatorPropertyKey", om.valueToTree(this.getOperatorPropertyKey()));
                data.set("property", om.valueToTree(this.getProperty()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.TaskPropertiesMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskPropertiesMapProperty.Jsii$Proxy that = (TaskPropertiesMapProperty.Jsii$Proxy) o;

                if (!operatorPropertyKey.equals(that.operatorPropertyKey)) return false;
                return this.property.equals(that.property);
            }

            @Override
            public final int hashCode() {
                int result = this.operatorPropertyKey.hashCode();
                result = 31 * result + (this.property.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>Task</code> property type specifies the class for modeling different type of tasks.
     * <p>
     * Task implementation varies based on the TaskType.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * TaskProperty taskProperty = TaskProperty.builder()
     *         .sourceFields(List.of("sourceFields"))
     *         .taskType("taskType")
     *         // the properties below are optional
     *         .connectorOperator(ConnectorOperatorProperty.builder()
     *                 .marketo("marketo")
     *                 .s3("s3")
     *                 .salesforce("salesforce")
     *                 .serviceNow("serviceNow")
     *                 .zendesk("zendesk")
     *                 .build())
     *         .destinationField("destinationField")
     *         .taskProperties(List.of(TaskPropertiesMapProperty.builder()
     *                 .operatorPropertyKey("operatorPropertyKey")
     *                 .property("property")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.TaskProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source fields to which a particular task is applied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-sourcefields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-sourcefields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSourceFields();

        /**
         * Specifies the particular task implementation that Amazon AppFlow performs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-tasktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-tasktype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTaskType();

        /**
         * The operation to be performed on the provided source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-connectoroperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-connectoroperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOperator() {
            return null;
        }

        /**
         * A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-destinationfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-destinationfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationField() {
            return null;
        }

        /**
         * A map used to store task-related information.
         * <p>
         * The service looks for particular information based on the TaskType.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-taskproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-taskproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTaskProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskProperty> {
            java.util.List<java.lang.String> sourceFields;
            java.lang.String taskType;
            java.lang.Object connectorOperator;
            java.lang.String destinationField;
            java.lang.Object taskProperties;

            /**
             * Sets the value of {@link TaskProperty#getSourceFields}
             * @param sourceFields The source fields to which a particular task is applied. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFields(java.util.List<java.lang.String> sourceFields) {
                this.sourceFields = sourceFields;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskType}
             * @param taskType Specifies the particular task implementation that Amazon AppFlow performs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskType(java.lang.String taskType) {
                this.taskType = taskType;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getConnectorOperator}
             * @param connectorOperator The operation to be performed on the provided source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOperator(software.amazon.awscdk.IResolvable connectorOperator) {
                this.connectorOperator = connectorOperator;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getConnectorOperator}
             * @param connectorOperator The operation to be performed on the provided source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOperator(software.amazon.awscdk.services.customerprofiles.CfnIntegration.ConnectorOperatorProperty connectorOperator) {
                this.connectorOperator = connectorOperator;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getDestinationField}
             * @param destinationField A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationField(java.lang.String destinationField) {
                this.destinationField = destinationField;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskProperties}
             * @param taskProperties A map used to store task-related information.
             *                       The service looks for particular information based on the TaskType.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(software.amazon.awscdk.IResolvable taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskProperties}
             * @param taskProperties A map used to store task-related information.
             *                       The service looks for particular information based on the TaskType.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(java.util.List<? extends java.lang.Object> taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskProperty {
            private final java.util.List<java.lang.String> sourceFields;
            private final java.lang.String taskType;
            private final java.lang.Object connectorOperator;
            private final java.lang.String destinationField;
            private final java.lang.Object taskProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceFields = software.amazon.jsii.Kernel.get(this, "sourceFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.taskType = software.amazon.jsii.Kernel.get(this, "taskType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOperator = software.amazon.jsii.Kernel.get(this, "connectorOperator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationField = software.amazon.jsii.Kernel.get(this, "destinationField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskProperties = software.amazon.jsii.Kernel.get(this, "taskProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceFields = java.util.Objects.requireNonNull(builder.sourceFields, "sourceFields is required");
                this.taskType = java.util.Objects.requireNonNull(builder.taskType, "taskType is required");
                this.connectorOperator = builder.connectorOperator;
                this.destinationField = builder.destinationField;
                this.taskProperties = builder.taskProperties;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceFields() {
                return this.sourceFields;
            }

            @Override
            public final java.lang.String getTaskType() {
                return this.taskType;
            }

            @Override
            public final java.lang.Object getConnectorOperator() {
                return this.connectorOperator;
            }

            @Override
            public final java.lang.String getDestinationField() {
                return this.destinationField;
            }

            @Override
            public final java.lang.Object getTaskProperties() {
                return this.taskProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceFields", om.valueToTree(this.getSourceFields()));
                data.set("taskType", om.valueToTree(this.getTaskType()));
                if (this.getConnectorOperator() != null) {
                    data.set("connectorOperator", om.valueToTree(this.getConnectorOperator()));
                }
                if (this.getDestinationField() != null) {
                    data.set("destinationField", om.valueToTree(this.getDestinationField()));
                }
                if (this.getTaskProperties() != null) {
                    data.set("taskProperties", om.valueToTree(this.getTaskProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.TaskProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskProperty.Jsii$Proxy that = (TaskProperty.Jsii$Proxy) o;

                if (!sourceFields.equals(that.sourceFields)) return false;
                if (!taskType.equals(that.taskType)) return false;
                if (this.connectorOperator != null ? !this.connectorOperator.equals(that.connectorOperator) : that.connectorOperator != null) return false;
                if (this.destinationField != null ? !this.destinationField.equals(that.destinationField) : that.destinationField != null) return false;
                return this.taskProperties != null ? this.taskProperties.equals(that.taskProperties) : that.taskProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceFields.hashCode();
                result = 31 * result + (this.taskType.hashCode());
                result = 31 * result + (this.connectorOperator != null ? this.connectorOperator.hashCode() : 0);
                result = 31 * result + (this.destinationField != null ? this.destinationField.hashCode() : 0);
                result = 31 * result + (this.taskProperties != null ? this.taskProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * TriggerConfigProperty triggerConfigProperty = TriggerConfigProperty.builder()
     *         .triggerType("triggerType")
     *         // the properties below are optional
     *         .triggerProperties(TriggerPropertiesProperty.builder()
     *                 .scheduled(ScheduledTriggerPropertiesProperty.builder()
     *                         .scheduleExpression("scheduleExpression")
     *                         // the properties below are optional
     *                         .dataPullMode("dataPullMode")
     *                         .firstExecutionFrom(123)
     *                         .scheduleEndTime(123)
     *                         .scheduleOffset(123)
     *                         .scheduleStartTime(123)
     *                         .timezone("timezone")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.TriggerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of flow trigger.
         * <p>
         * It can be OnDemand, Scheduled, or Event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html#cfn-customerprofiles-integration-triggerconfig-triggertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html#cfn-customerprofiles-integration-triggerconfig-triggertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTriggerType();

        /**
         * Specifies the configuration details of a schedule-triggered flow that you define.
         * <p>
         * Currently, these settings only apply to the Scheduled trigger type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html#cfn-customerprofiles-integration-triggerconfig-triggerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html#cfn-customerprofiles-integration-triggerconfig-triggerproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTriggerProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerConfigProperty> {
            java.lang.String triggerType;
            java.lang.Object triggerProperties;

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerType}
             * @param triggerType Specifies the type of flow trigger. This parameter is required.
             *                    It can be OnDemand, Scheduled, or Event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerType(java.lang.String triggerType) {
                this.triggerType = triggerType;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerProperties}
             * @param triggerProperties Specifies the configuration details of a schedule-triggered flow that you define.
             *                          Currently, these settings only apply to the Scheduled trigger type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerProperties(software.amazon.awscdk.IResolvable triggerProperties) {
                this.triggerProperties = triggerProperties;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerProperties}
             * @param triggerProperties Specifies the configuration details of a schedule-triggered flow that you define.
             *                          Currently, these settings only apply to the Scheduled trigger type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerProperties(software.amazon.awscdk.services.customerprofiles.CfnIntegration.TriggerPropertiesProperty triggerProperties) {
                this.triggerProperties = triggerProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerConfigProperty {
            private final java.lang.String triggerType;
            private final java.lang.Object triggerProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.triggerType = software.amazon.jsii.Kernel.get(this, "triggerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.triggerProperties = software.amazon.jsii.Kernel.get(this, "triggerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.triggerType = java.util.Objects.requireNonNull(builder.triggerType, "triggerType is required");
                this.triggerProperties = builder.triggerProperties;
            }

            @Override
            public final java.lang.String getTriggerType() {
                return this.triggerType;
            }

            @Override
            public final java.lang.Object getTriggerProperties() {
                return this.triggerProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("triggerType", om.valueToTree(this.getTriggerType()));
                if (this.getTriggerProperties() != null) {
                    data.set("triggerProperties", om.valueToTree(this.getTriggerProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.TriggerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerConfigProperty.Jsii$Proxy that = (TriggerConfigProperty.Jsii$Proxy) o;

                if (!triggerType.equals(that.triggerType)) return false;
                return this.triggerProperties != null ? this.triggerProperties.equals(that.triggerProperties) : that.triggerProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.triggerType.hashCode();
                result = 31 * result + (this.triggerProperties != null ? this.triggerProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration details that control the trigger for a flow.
     * <p>
     * Currently, these settings only apply to the Scheduled trigger type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * TriggerPropertiesProperty triggerPropertiesProperty = TriggerPropertiesProperty.builder()
     *         .scheduled(ScheduledTriggerPropertiesProperty.builder()
     *                 .scheduleExpression("scheduleExpression")
     *                 // the properties below are optional
     *                 .dataPullMode("dataPullMode")
     *                 .firstExecutionFrom(123)
     *                 .scheduleEndTime(123)
     *                 .scheduleOffset(123)
     *                 .scheduleStartTime(123)
     *                 .timezone("timezone")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.TriggerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the configuration details of a schedule-triggered flow that you define.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerproperties.html#cfn-customerprofiles-integration-triggerproperties-scheduled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerproperties.html#cfn-customerprofiles-integration-triggerproperties-scheduled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScheduled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerPropertiesProperty> {
            java.lang.Object scheduled;

            /**
             * Sets the value of {@link TriggerPropertiesProperty#getScheduled}
             * @param scheduled Specifies the configuration details of a schedule-triggered flow that you define.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduled(software.amazon.awscdk.IResolvable scheduled) {
                this.scheduled = scheduled;
                return this;
            }

            /**
             * Sets the value of {@link TriggerPropertiesProperty#getScheduled}
             * @param scheduled Specifies the configuration details of a schedule-triggered flow that you define.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduled(software.amazon.awscdk.services.customerprofiles.CfnIntegration.ScheduledTriggerPropertiesProperty scheduled) {
                this.scheduled = scheduled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerPropertiesProperty {
            private final java.lang.Object scheduled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduled = software.amazon.jsii.Kernel.get(this, "scheduled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduled = builder.scheduled;
            }

            @Override
            public final java.lang.Object getScheduled() {
                return this.scheduled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScheduled() != null) {
                    data.set("scheduled", om.valueToTree(this.getScheduled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.TriggerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerPropertiesProperty.Jsii$Proxy that = (TriggerPropertiesProperty.Jsii$Proxy) o;

                return this.scheduled != null ? this.scheduled.equals(that.scheduled) : that.scheduled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduled != null ? this.scheduled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using Zendesk as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ZendeskSourcePropertiesProperty zendeskSourcePropertiesProperty = ZendeskSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-zendesksourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-zendesksourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegration.ZendeskSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Zendesk flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-zendesksourceproperties.html#cfn-customerprofiles-integration-zendesksourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-zendesksourceproperties.html#cfn-customerprofiles-integration-zendesksourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link ZendeskSourcePropertiesProperty#getObject}
             * @param object The object specified in the Zendesk flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegration.ZendeskSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskSourcePropertiesProperty.Jsii$Proxy that = (ZendeskSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.customerprofiles.CfnIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.customerprofiles.CfnIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.customerprofiles.CfnIntegrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.customerprofiles.CfnIntegrationProps.Builder();
        }

        /**
         * The unique name of the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-domainname</a>
         * @param domainName The unique name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * A list of unique names for active event triggers associated with the integration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-eventtriggernames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-eventtriggernames</a>
         * @param eventTriggerNames A list of unique names for active event triggers associated with the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerNames(final java.util.List<java.lang.String> eventTriggerNames) {
            this.props.eventTriggerNames(eventTriggerNames);
            return this;
        }

        /**
         * The configuration that controls how Customer Profiles retrieves data from the source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition</a>
         * @param flowDefinition The configuration that controls how Customer Profiles retrieves data from the source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowDefinition(final software.amazon.awscdk.IResolvable flowDefinition) {
            this.props.flowDefinition(flowDefinition);
            return this;
        }
        /**
         * The configuration that controls how Customer Profiles retrieves data from the source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition</a>
         * @param flowDefinition The configuration that controls how Customer Profiles retrieves data from the source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowDefinition(final software.amazon.awscdk.services.customerprofiles.CfnIntegration.FlowDefinitionProperty flowDefinition) {
            this.props.flowDefinition(flowDefinition);
            return this;
        }

        /**
         * The name of the profile object type mapping to use.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypename</a>
         * @param objectTypeName The name of the profile object type mapping to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeName(final java.lang.String objectTypeName) {
            this.props.objectTypeName(objectTypeName);
            return this;
        }

        /**
         * The object type mapping.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypenames</a>
         * @param objectTypeNames The object type mapping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeNames(final software.amazon.awscdk.IResolvable objectTypeNames) {
            this.props.objectTypeNames(objectTypeNames);
            return this;
        }
        /**
         * The object type mapping.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypenames</a>
         * @param objectTypeNames The object type mapping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeNames(final java.util.List<? extends java.lang.Object> objectTypeNames) {
            this.props.objectTypeNames(objectTypeNames);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The URI of the S3 bucket or any other type of data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-uri</a>
         * @param uri The URI of the S3 bucket or any other type of data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(final java.lang.String uri) {
            this.props.uri(uri);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.customerprofiles.CfnIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.customerprofiles.CfnIntegration build() {
            return new software.amazon.awscdk.services.customerprofiles.CfnIntegration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
