package software.amazon.awscdk.services.customerprofiles;

/**
 * Properties for defining a <code>CfnSegmentDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnSegmentDefinitionProps cfnSegmentDefinitionProps = CfnSegmentDefinitionProps.builder()
 *         .displayName("displayName")
 *         .domainName("domainName")
 *         .segmentDefinitionName("segmentDefinitionName")
 *         .segmentGroups(SegmentGroupProperty.builder()
 *                 .groups(List.of(GroupProperty.builder()
 *                         .dimensions(List.of(DimensionProperty.builder()
 *                                 .calculatedAttributes(Map.of(
 *                                         "calculatedAttributesKey", CalculatedAttributeDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 // the properties below are optional
 *                                                 .conditionOverrides(ConditionOverridesProperty.builder()
 *                                                         .range(RangeOverrideProperty.builder()
 *                                                                 .start(123)
 *                                                                 .unit("unit")
 *                                                                 // the properties below are optional
 *                                                                 .end(123)
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build()))
 *                                 .profileAttributes(ProfileAttributesProperty.builder()
 *                                         .accountNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .additionalInformation(ExtraLengthValueProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .address(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .attributes(Map.of(
 *                                                 "attributesKey", AttributeDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build()))
 *                                         .billingAddress(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .birthDate(DateDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .businessEmailAddress(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .businessName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .businessPhoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .emailAddress(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .firstName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .genderString(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .homePhoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .lastName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .mailingAddress(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .middleName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .mobilePhoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .partyTypeString(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .personalEmailAddress(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .phoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .shippingAddress(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .sourceSegments(List.of(SourceSegmentProperty.builder()
 *                                 .segmentDefinitionName("segmentDefinitionName")
 *                                 .build()))
 *                         .sourceType("sourceType")
 *                         .type("type")
 *                         .build()))
 *                 .include("include")
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:52.208Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnSegmentDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSegmentDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Display name of the segment definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The name of the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * Name of the segment definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentdefinitionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSegmentDefinitionName();

    /**
     * Contains all groups of the segment definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentgroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSegmentGroups();

    /**
     * The description of the segment definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The tags belonging to the segment definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSegmentDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSegmentDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSegmentDefinitionProps> {
        java.lang.String displayName;
        java.lang.String domainName;
        java.lang.String segmentDefinitionName;
        java.lang.Object segmentGroups;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSegmentDefinitionProps#getDisplayName}
         * @param displayName Display name of the segment definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentDefinitionProps#getDomainName}
         * @param domainName The name of the domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentDefinitionProps#getSegmentDefinitionName}
         * @param segmentDefinitionName Name of the segment definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentDefinitionName(java.lang.String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentDefinitionProps#getSegmentGroups}
         * @param segmentGroups Contains all groups of the segment definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(software.amazon.awscdk.IResolvable segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentDefinitionProps#getSegmentGroups}
         * @param segmentGroups Contains all groups of the segment definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.SegmentGroupProperty segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentDefinitionProps#getDescription}
         * @param description The description of the segment definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentDefinitionProps#getTags}
         * @param tags The tags belonging to the segment definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSegmentDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSegmentDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSegmentDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSegmentDefinitionProps {
        private final java.lang.String displayName;
        private final java.lang.String domainName;
        private final java.lang.String segmentDefinitionName;
        private final java.lang.Object segmentGroups;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.segmentDefinitionName = software.amazon.jsii.Kernel.get(this, "segmentDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.segmentGroups = software.amazon.jsii.Kernel.get(this, "segmentGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.segmentDefinitionName = java.util.Objects.requireNonNull(builder.segmentDefinitionName, "segmentDefinitionName is required");
            this.segmentGroups = java.util.Objects.requireNonNull(builder.segmentGroups, "segmentGroups is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getSegmentDefinitionName() {
            return this.segmentDefinitionName;
        }

        @Override
        public final java.lang.Object getSegmentGroups() {
            return this.segmentGroups;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("segmentDefinitionName", om.valueToTree(this.getSegmentDefinitionName()));
            data.set("segmentGroups", om.valueToTree(this.getSegmentGroups()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSegmentDefinitionProps.Jsii$Proxy that = (CfnSegmentDefinitionProps.Jsii$Proxy) o;

            if (!displayName.equals(that.displayName)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (!segmentDefinitionName.equals(that.segmentDefinitionName)) return false;
            if (!segmentGroups.equals(that.segmentGroups)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.displayName.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.segmentDefinitionName.hashCode());
            result = 31 * result + (this.segmentGroups.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
