package software.amazon.awscdk.services.dms;

/**
 * Properties for defining a <code>CfnDataProvider</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnDataProviderProps cfnDataProviderProps = CfnDataProviderProps.builder()
 *         .engine("engine")
 *         // the properties below are optional
 *         .dataProviderIdentifier("dataProviderIdentifier")
 *         .dataProviderName("dataProviderName")
 *         .description("description")
 *         .exactSettings(false)
 *         .settings(SettingsProperty.builder()
 *                 .docDbSettings(DocDbSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .sslMode("sslMode")
 *                         .build())
 *                 .mariaDbSettings(MariaDbSettingsProperty.builder()
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .mongoDbSettings(MongoDbSettingsProperty.builder()
 *                         .port(123)
 *                         .serverName("serverName")
 *                         // the properties below are optional
 *                         .authMechanism("authMechanism")
 *                         .authSource("authSource")
 *                         .authType("authType")
 *                         .certificateArn("certificateArn")
 *                         .databaseName("databaseName")
 *                         .sslMode("sslMode")
 *                         .build())
 *                 .mySqlSettings(MySqlSettingsProperty.builder()
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .oracleSettings(OracleSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .asmServer("asmServer")
 *                         .certificateArn("certificateArn")
 *                         .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
 *                         .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
 *                         .secretsManagerSecurityDbEncryptionAccessRoleArn("secretsManagerSecurityDbEncryptionAccessRoleArn")
 *                         .secretsManagerSecurityDbEncryptionSecretId("secretsManagerSecurityDbEncryptionSecretId")
 *                         .build())
 *                 .postgreSqlSettings(PostgreSqlSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .redshiftSettings(RedshiftSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:52.526Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProviderProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of database engine for the data provider.
     * <p>
     * Valid values include <code>"aurora"</code> , <code>"aurora-postgresql"</code> , <code>"mysql"</code> , <code>"oracle"</code> , <code>"postgres"</code> , <code>"sqlserver"</code> , <code>redshift</code> , <code>mariadb</code> , <code>mongodb</code> , and <code>docdb</code> . A value of <code>"aurora"</code> represents Amazon Aurora MySQL-Compatible Edition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngine();

    /**
     * The identifier of the data provider.
     * <p>
     * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovideridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovideridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataProviderIdentifier() {
        return null;
    }

    /**
     * The name of the data provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovidername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataProviderName() {
        return null;
    }

    /**
     * A description of the data provider.
     * <p>
     * Descriptions can have up to 31 characters. A description can contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The property describes the exact settings which can be modified.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-exactsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-exactsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExactSettings() {
        return null;
    }

    /**
     * The settings in JSON format for a data provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-settings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataProviderProps> {
        java.lang.String engine;
        java.lang.String dataProviderIdentifier;
        java.lang.String dataProviderName;
        java.lang.String description;
        java.lang.Object exactSettings;
        java.lang.Object settings;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataProviderProps#getEngine}
         * @param engine The type of database engine for the data provider. This parameter is required.
         *               Valid values include <code>"aurora"</code> , <code>"aurora-postgresql"</code> , <code>"mysql"</code> , <code>"oracle"</code> , <code>"postgres"</code> , <code>"sqlserver"</code> , <code>redshift</code> , <code>mariadb</code> , <code>mongodb</code> , and <code>docdb</code> . A value of <code>"aurora"</code> represents Amazon Aurora MySQL-Compatible Edition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getDataProviderIdentifier}
         * @param dataProviderIdentifier The identifier of the data provider.
         *                               Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProviderIdentifier(java.lang.String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getDataProviderName}
         * @param dataProviderName The name of the data provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProviderName(java.lang.String dataProviderName) {
            this.dataProviderName = dataProviderName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getDescription}
         * @param description A description of the data provider.
         *                    Descriptions can have up to 31 characters. A description can contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getExactSettings}
         * @param exactSettings The property describes the exact settings which can be modified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exactSettings(java.lang.Boolean exactSettings) {
            this.exactSettings = exactSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getExactSettings}
         * @param exactSettings The property describes the exact settings which can be modified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exactSettings(software.amazon.awscdk.IResolvable exactSettings) {
            this.exactSettings = exactSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getSettings}
         * @param settings The settings in JSON format for a data provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(software.amazon.awscdk.IResolvable settings) {
            this.settings = settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getSettings}
         * @param settings The settings in JSON format for a data provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(software.amazon.awscdk.services.dms.CfnDataProvider.SettingsProperty settings) {
            this.settings = settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataProviderProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataProviderProps {
        private final java.lang.String engine;
        private final java.lang.String dataProviderIdentifier;
        private final java.lang.String dataProviderName;
        private final java.lang.String description;
        private final java.lang.Object exactSettings;
        private final java.lang.Object settings;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataProviderIdentifier = software.amazon.jsii.Kernel.get(this, "dataProviderIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataProviderName = software.amazon.jsii.Kernel.get(this, "dataProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exactSettings = software.amazon.jsii.Kernel.get(this, "exactSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.settings = software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.dataProviderIdentifier = builder.dataProviderIdentifier;
            this.dataProviderName = builder.dataProviderName;
            this.description = builder.description;
            this.exactSettings = builder.exactSettings;
            this.settings = builder.settings;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getDataProviderIdentifier() {
            return this.dataProviderIdentifier;
        }

        @Override
        public final java.lang.String getDataProviderName() {
            return this.dataProviderName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getExactSettings() {
            return this.exactSettings;
        }

        @Override
        public final java.lang.Object getSettings() {
            return this.settings;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engine", om.valueToTree(this.getEngine()));
            if (this.getDataProviderIdentifier() != null) {
                data.set("dataProviderIdentifier", om.valueToTree(this.getDataProviderIdentifier()));
            }
            if (this.getDataProviderName() != null) {
                data.set("dataProviderName", om.valueToTree(this.getDataProviderName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExactSettings() != null) {
                data.set("exactSettings", om.valueToTree(this.getExactSettings()));
            }
            if (this.getSettings() != null) {
                data.set("settings", om.valueToTree(this.getSettings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataProviderProps.Jsii$Proxy that = (CfnDataProviderProps.Jsii$Proxy) o;

            if (!engine.equals(that.engine)) return false;
            if (this.dataProviderIdentifier != null ? !this.dataProviderIdentifier.equals(that.dataProviderIdentifier) : that.dataProviderIdentifier != null) return false;
            if (this.dataProviderName != null ? !this.dataProviderName.equals(that.dataProviderName) : that.dataProviderName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.exactSettings != null ? !this.exactSettings.equals(that.exactSettings) : that.exactSettings != null) return false;
            if (this.settings != null ? !this.settings.equals(that.settings) : that.settings != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engine.hashCode();
            result = 31 * result + (this.dataProviderIdentifier != null ? this.dataProviderIdentifier.hashCode() : 0);
            result = 31 * result + (this.dataProviderName != null ? this.dataProviderName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.exactSettings != null ? this.exactSettings.hashCode() : 0);
            result = 31 * result + (this.settings != null ? this.settings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
