package software.amazon.awscdk.services.docdb;

/**
 * The CA certificate used for a DB instance.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:52.620Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.CaCertificate")
public class CaCertificate extends software.amazon.jsii.JsiiObject {

    protected CaCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CaCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        RDS_CA_2019 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.CaCertificate.class, "RDS_CA_2019", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
        RDS_CA_ECC384_G1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.CaCertificate.class, "RDS_CA_ECC384_G1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
        RDS_CA_RDS2048_G1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.CaCertificate.class, "RDS_CA_RDS2048_G1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
        RDS_CA_RDS4096_G1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.CaCertificate.class, "RDS_CA_RDS4096_G1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
        RDS_CA_RSA2048_G1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.CaCertificate.class, "RDS_CA_RSA2048_G1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
        RDS_CA_RSA4096_G1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.CaCertificate.class, "RDS_CA_RSA4096_G1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
    }

    /**
     * Custom CA certificate.
     * <p>
     * @param identifier <ul><li>CA certificate identifier.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CaCertificate of(final @org.jetbrains.annotations.NotNull java.lang.String identifier) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.docdb.CaCertificate.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class), new Object[] { java.util.Objects.requireNonNull(identifier, "identifier is required") });
    }

    /**
     * Returns the CA certificate identifier as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) rds-ca-2019 certificate authority.
     * <p>
     * @deprecated rds-ca-2019 expired in August, 2024.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.CaCertificate RDS_CA_2019;

    /**
     * rds-ca-ecc384-g1 certificate authority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.CaCertificate RDS_CA_ECC384_G1;

    /**
     * (deprecated) rds-ca-rsa2048-g1 certificate authority.
     * <p>
     * @deprecated use RDS_CA_RSA2048_G1 (slight misspelling)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.CaCertificate RDS_CA_RDS2048_G1;

    /**
     * (deprecated) rds-ca-rsa4096-g1 certificate authority.
     * <p>
     * @deprecated use RDS_CA_RSA4096_G1 (slight misspelling)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.CaCertificate RDS_CA_RDS4096_G1;

    /**
     * rds-ca-rsa2048-g1 certificate authority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.CaCertificate RDS_CA_RSA2048_G1;

    /**
     * rds-ca-rsa4096-g1 certificate authority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.CaCertificate RDS_CA_RSA4096_G1;
}
