package software.amazon.awscdk.services.docdb;

/**
 * Properties for defining a <code>CfnDBInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdb.*;
 * CfnDBInstanceProps cfnDBInstanceProps = CfnDBInstanceProps.builder()
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbInstanceClass("dbInstanceClass")
 *         // the properties below are optional
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZone("availabilityZone")
 *         .caCertificateIdentifier("caCertificateIdentifier")
 *         .certificateRotationRestart(false)
 *         .dbInstanceIdentifier("dbInstanceIdentifier")
 *         .enablePerformanceInsights(false)
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:52.641Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.CfnDBInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the cluster that the instance will belong to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbClusterIdentifier();

    /**
     * The compute and memory capacity of the instance;
     * <p>
     * for example, <code>db.m4.large</code> . If you change the class of an instance there can be some interruption in the cluster's service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceClass();

    /**
     * This parameter does not apply to Amazon DocumentDB.
     * <p>
     * Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
     * <p>
     * Default: <code>false</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-autominorversionupgrade</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * The Amazon EC2 Availability Zone that the instance is created in.
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
     * <p>
     * Example: <code>us-east-1d</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-cacertificateidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-cacertificateidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaCertificateIdentifier() {
        return null;
    }

    /**
     * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
     * <p>
     * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
     * <p>
     * <blockquote>
     * <p>
     * Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
     * <p>
     * </blockquote>
     * <p>
     * If you are using SSL/TLS to connect to the DB instance, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon DocumentDB TLS Certificates</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html">Encrypting Data in Transit</a> in the <em>Amazon DocumentDB Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-certificaterotationrestart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-certificaterotationrestart</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCertificateRotationRestart() {
        return null;
    }

    /**
     * The instance identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>The first character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>mydbinstance</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceIdentifier() {
        return null;
    }

    /**
     * A value that indicates whether to enable Performance Insights for the DB Instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using Amazon Performance Insights</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-enableperformanceinsights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-enableperformanceinsights</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePerformanceInsights() {
        return null;
    }

    /**
     * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region , occurring on a random day of the week.
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * <p>
     * Constraints: Minimum 30-minute window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The tags to be assigned to the instance.
     * <p>
     * You can assign up to 10 tags to an instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBInstanceProps> {
        java.lang.String dbClusterIdentifier;
        java.lang.String dbInstanceClass;
        java.lang.Object autoMinorVersionUpgrade;
        java.lang.String availabilityZone;
        java.lang.String caCertificateIdentifier;
        java.lang.Object certificateRotationRestart;
        java.lang.String dbInstanceIdentifier;
        java.lang.Object enablePerformanceInsights;
        java.lang.String preferredMaintenanceWindow;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbClusterIdentifier}
         * @param dbClusterIdentifier The identifier of the cluster that the instance will belong to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbInstanceClass}
         * @param dbInstanceClass The compute and memory capacity of the instance;. This parameter is required.
         *                        for example, <code>db.m4.large</code> . If you change the class of an instance there can be some interruption in the cluster's service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceClass(java.lang.String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade This parameter does not apply to Amazon DocumentDB.
         *                                Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         *                                <p>
         *                                Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade This parameter does not apply to Amazon DocumentDB.
         *                                Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         *                                <p>
         *                                Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getAvailabilityZone}
         * @param availabilityZone The Amazon EC2 Availability Zone that the instance is created in.
         *                         Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
         *                         <p>
         *                         Example: <code>us-east-1d</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCaCertificateIdentifier}
         * @param caCertificateIdentifier The identifier of the CA certificate for this DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificateIdentifier(java.lang.String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCertificateRotationRestart}
         * @param certificateRotationRestart Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         *                                   By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
         *                                   <p>
         *                                   </blockquote>
         *                                   <p>
         *                                   If you are using SSL/TLS to connect to the DB instance, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon DocumentDB TLS Certificates</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html">Encrypting Data in Transit</a> in the <em>Amazon DocumentDB Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateRotationRestart(java.lang.Boolean certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getCertificateRotationRestart}
         * @param certificateRotationRestart Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         *                                   By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
         *                                   <p>
         *                                   </blockquote>
         *                                   <p>
         *                                   If you are using SSL/TLS to connect to the DB instance, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon DocumentDB TLS Certificates</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html">Encrypting Data in Transit</a> in the <em>Amazon DocumentDB Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateRotationRestart(software.amazon.awscdk.IResolvable certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getDbInstanceIdentifier}
         * @param dbInstanceIdentifier The instance identifier. This parameter is stored as a lowercase string.
         *                             Constraints:
         *                             <p>
         *                             <ul>
         *                             <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
         *                             <li>The first character must be a letter.</li>
         *                             <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         *                             </ul>
         *                             <p>
         *                             Example: <code>mydbinstance</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifier(java.lang.String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB Instance.
         *                                  For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using Amazon Performance Insights</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(java.lang.Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB Instance.
         *                                  For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using Amazon Performance Insights</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(software.amazon.awscdk.IResolvable enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   <p>
         *                                   The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region , occurring on a random day of the week.
         *                                   <p>
         *                                   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *                                   <p>
         *                                   Constraints: Minimum 30-minute window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBInstanceProps#getTags}
         * @param tags The tags to be assigned to the instance.
         *             You can assign up to 10 tags to an instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBInstanceProps {
        private final java.lang.String dbClusterIdentifier;
        private final java.lang.String dbInstanceClass;
        private final java.lang.Object autoMinorVersionUpgrade;
        private final java.lang.String availabilityZone;
        private final java.lang.String caCertificateIdentifier;
        private final java.lang.Object certificateRotationRestart;
        private final java.lang.String dbInstanceIdentifier;
        private final java.lang.Object enablePerformanceInsights;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbInstanceClass = software.amazon.jsii.Kernel.get(this, "dbInstanceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caCertificateIdentifier = software.amazon.jsii.Kernel.get(this, "caCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateRotationRestart = software.amazon.jsii.Kernel.get(this, "certificateRotationRestart", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dbInstanceIdentifier = software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enablePerformanceInsights = software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbClusterIdentifier = java.util.Objects.requireNonNull(builder.dbClusterIdentifier, "dbClusterIdentifier is required");
            this.dbInstanceClass = java.util.Objects.requireNonNull(builder.dbInstanceClass, "dbInstanceClass is required");
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.availabilityZone = builder.availabilityZone;
            this.caCertificateIdentifier = builder.caCertificateIdentifier;
            this.certificateRotationRestart = builder.certificateRotationRestart;
            this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
            this.enablePerformanceInsights = builder.enablePerformanceInsights;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final java.lang.String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final java.lang.Object getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final java.lang.Object getCertificateRotationRestart() {
            return this.certificateRotationRestart;
        }

        @Override
        public final java.lang.String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final java.lang.Object getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));
            data.set("dbInstanceClass", om.valueToTree(this.getDbInstanceClass()));
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getCaCertificateIdentifier() != null) {
                data.set("caCertificateIdentifier", om.valueToTree(this.getCaCertificateIdentifier()));
            }
            if (this.getCertificateRotationRestart() != null) {
                data.set("certificateRotationRestart", om.valueToTree(this.getCertificateRotationRestart()));
            }
            if (this.getDbInstanceIdentifier() != null) {
                data.set("dbInstanceIdentifier", om.valueToTree(this.getDbInstanceIdentifier()));
            }
            if (this.getEnablePerformanceInsights() != null) {
                data.set("enablePerformanceInsights", om.valueToTree(this.getEnablePerformanceInsights()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.CfnDBInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBInstanceProps.Jsii$Proxy that = (CfnDBInstanceProps.Jsii$Proxy) o;

            if (!dbClusterIdentifier.equals(that.dbClusterIdentifier)) return false;
            if (!dbInstanceClass.equals(that.dbInstanceClass)) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.caCertificateIdentifier != null ? !this.caCertificateIdentifier.equals(that.caCertificateIdentifier) : that.caCertificateIdentifier != null) return false;
            if (this.certificateRotationRestart != null ? !this.certificateRotationRestart.equals(that.certificateRotationRestart) : that.certificateRotationRestart != null) return false;
            if (this.dbInstanceIdentifier != null ? !this.dbInstanceIdentifier.equals(that.dbInstanceIdentifier) : that.dbInstanceIdentifier != null) return false;
            if (this.enablePerformanceInsights != null ? !this.enablePerformanceInsights.equals(that.enablePerformanceInsights) : that.enablePerformanceInsights != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dbClusterIdentifier.hashCode();
            result = 31 * result + (this.dbInstanceClass.hashCode());
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.caCertificateIdentifier != null ? this.caCertificateIdentifier.hashCode() : 0);
            result = 31 * result + (this.certificateRotationRestart != null ? this.certificateRotationRestart.hashCode() : 0);
            result = 31 * result + (this.dbInstanceIdentifier != null ? this.dbInstanceIdentifier.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceInsights != null ? this.enablePerformanceInsights.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
