package software.amazon.awscdk.services.dynamodb;

/**
 * Properties of a DynamoDB Table.
 * <p>
 * Use <code>TableProps</code> for all table properties
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * InputFormat inputFormat;
 * Key key;
 * PolicyDocument policyDocument;
 * TableOptions tableOptions = TableOptions.builder()
 *         .partitionKey(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build())
 *         // the properties below are optional
 *         .billingMode(BillingMode.PAY_PER_REQUEST)
 *         .contributorInsightsEnabled(false)
 *         .deletionProtection(false)
 *         .encryption(TableEncryption.DEFAULT)
 *         .encryptionKey(key)
 *         .importSource(ImportSourceSpecification.builder()
 *                 .bucket(bucket)
 *                 .inputFormat(inputFormat)
 *                 // the properties below are optional
 *                 .bucketOwner("bucketOwner")
 *                 .compressionType(InputCompressionType.GZIP)
 *                 .keyPrefix("keyPrefix")
 *                 .build())
 *         .maxReadRequestUnits(123)
 *         .maxWriteRequestUnits(123)
 *         .pointInTimeRecovery(false)
 *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecification.builder()
 *                 .pointInTimeRecoveryEnabled(false)
 *                 // the properties below are optional
 *                 .recoveryPeriodInDays(123)
 *                 .build())
 *         .readCapacity(123)
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .replicationRegions(List.of("replicationRegions"))
 *         .replicationTimeout(Duration.minutes(30))
 *         .resourcePolicy(policyDocument)
 *         .sortKey(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build())
 *         .stream(StreamViewType.NEW_IMAGE)
 *         .tableClass(TableClass.STANDARD)
 *         .timeToLiveAttribute("timeToLiveAttribute")
 *         .waitForReplicationToFinish(false)
 *         .warmThroughput(WarmThroughput.builder()
 *                 .readUnitsPerSecond(123)
 *                 .writeUnitsPerSecond(123)
 *                 .build())
 *         .writeCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:52.782Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableOptions")
@software.amazon.jsii.Jsii.Proxy(TableOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.SchemaOptions {

    /**
     * Specify how you are charged for read and write throughput and how you manage capacity.
     * <p>
     * Default: PROVISIONED if `replicationRegions` is not specified, PAY_PER_REQUEST otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
        return null;
    }

    /**
     * Whether CloudWatch contributor insights is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContributorInsightsEnabled() {
        return null;
    }

    /**
     * Enables deletion protection for the table.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeletionProtection() {
        return null;
    }

    /**
     * Whether server-side encryption with an AWS managed customer master key is enabled.
     * <p>
     * This property cannot be set if <code>serverSideEncryption</code> is set.
     * <p>
     * <blockquote>
     * <p>
     * <strong>NOTE</strong>: if you set this to <code>CUSTOMER_MANAGED</code> and <code>encryptionKey</code> is not
     * specified, the key that the Tablet generates for you will be created with
     * default permissions. If you are using CDKv2, these permissions will be
     * sufficient to enable the key for use with DynamoDB tables.  If you are
     * using CDKv1, make sure the feature flag
     * <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> is set to <code>true</code> in your <code>cdk.json</code>.
     * <p>
     * </blockquote>
     * <p>
     * Default: - The table is encrypted with an encryption key managed by DynamoDB, and you are not charged any fee for using it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.TableEncryption getEncryption() {
        return null;
    }

    /**
     * External KMS key to use for table encryption.
     * <p>
     * This property can only be set if <code>encryption</code> is set to <code>TableEncryption.CUSTOMER_MANAGED</code>.
     * <p>
     * Default: - If `encryption` is set to `TableEncryption.CUSTOMER_MANAGED` and this
     * property is undefined, a new KMS key will be created and associated with this table.
     * If `encryption` and this property are both undefined, then the table is encrypted with
     * an encryption key managed by DynamoDB, and you are not charged any fee for using it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The properties of data being imported from the S3 bucket source to the table.
     * <p>
     * Default: - no data import from the S3 bucket
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.ImportSourceSpecification getImportSource() {
        return null;
    }

    /**
     * The maximum read request units for the table.
     * <p>
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's maximum on-demand throughput.
     * <p>
     * Can only be provided if billingMode is PAY_PER_REQUEST.
     * <p>
     * Default: - on-demand throughput is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReadRequestUnits() {
        return null;
    }

    /**
     * The write request units for the table.
     * <p>
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's maximum on-demand throughput.
     * <p>
     * Can only be provided if billingMode is PAY_PER_REQUEST.
     * <p>
     * Default: - on-demand throughput is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxWriteRequestUnits() {
        return null;
    }

    /**
     * (deprecated) Whether point-in-time recovery is enabled.
     * <p>
     * Default: false - point in time recovery is not enabled.
     * <p>
     * @deprecated use <code>pointInTimeRecoverySpecification</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPointInTimeRecovery() {
        return null;
    }

    /**
     * Whether point-in-time recovery is enabled and recoveryPeriodInDays is set.
     * <p>
     * Default: - point in time recovery is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification getPointInTimeRecoverySpecification() {
        return null;
    }

    /**
     * The read capacity for the table.
     * <p>
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * <p>
     * Can only be provided if billingMode is Provisioned.
     * <p>
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReadCapacity() {
        return null;
    }

    /**
     * The removal policy to apply to the DynamoDB Table.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Regions where replica tables will be created.
     * <p>
     * Default: - no replica tables are created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReplicationRegions() {
        return null;
    }

    /**
     * The timeout for a table replication operation in a single region.
     * <p>
     * Default: Duration.minutes(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getReplicationTimeout() {
        return null;
    }

    /**
     * Resource policy to assign to table.
     * <p>
     * Default: - No resource policy statement
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-resourcepolicy">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-resourcepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
        return null;
    }

    /**
     * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
     * <p>
     * Default: - streams are disabled unless `replicationRegions` is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.StreamViewType getStream() {
        return null;
    }

    /**
     * Specify the table class.
     * <p>
     * Default: STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.TableClass getTableClass() {
        return null;
    }

    /**
     * The name of TTL attribute.
     * <p>
     * Default: - TTL is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeToLiveAttribute() {
        return null;
    }

    /**
     * [WARNING: Use this flag with caution, misusing this flag may cause deleting existing replicas, refer to the detailed documentation for more information] Indicates whether CloudFormation stack waits for replication to finish.
     * <p>
     * If set to false, the CloudFormation resource will mark the resource as
     * created and replication will be completed asynchronously. This property is
     * ignored if replicationRegions property is not set.
     * <p>
     * WARNING:
     * DO NOT UNSET this property if adding/removing multiple replicationRegions
     * in one deployment, as CloudFormation only supports one region replication
     * at a time. CDK overcomes this limitation by waiting for replication to
     * finish before starting new replicationRegion.
     * <p>
     * If the custom resource which handles replication has a physical resource
     * ID with the format <code>region</code> instead of <code>tablename-region</code> (this would happen
     * if the custom resource hasn't received an event since v1.91.0), DO NOT SET
     * this property to false without making a change to the table name.
     * This will cause the existing replicas to be deleted.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWaitForReplicationToFinish() {
        return null;
    }

    /**
     * Specify values to pre-warm you DynamoDB Table Warm Throughput feature is not available for Global Table replicas using the <code>Table</code> construct.
     * <p>
     * To enable Warm Throughput, use the <code>TableV2</code> construct instead.
     * <p>
     * Default: - warm throughput is not configured
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-warmthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-warmthroughput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.WarmThroughput getWarmThroughput() {
        return null;
    }

    /**
     * The write capacity for the table.
     * <p>
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * <p>
     * Can only be provided if billingMode is Provisioned.
     * <p>
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWriteCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableOptions> {
        software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        java.lang.Boolean contributorInsightsEnabled;
        java.lang.Boolean deletionProtection;
        software.amazon.awscdk.services.dynamodb.TableEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.services.dynamodb.ImportSourceSpecification importSource;
        java.lang.Number maxReadRequestUnits;
        java.lang.Number maxWriteRequestUnits;
        java.lang.Boolean pointInTimeRecovery;
        software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        java.lang.Number readCapacity;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.util.List<java.lang.String> replicationRegions;
        software.amazon.awscdk.Duration replicationTimeout;
        software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        java.lang.String timeToLiveAttribute;
        java.lang.Boolean waitForReplicationToFinish;
        software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput;
        java.lang.Number writeCapacity;
        software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Sets the value of {@link TableOptions#getBillingMode}
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(software.amazon.awscdk.services.dynamodb.BillingMode billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getContributorInsightsEnabled}
         * @param contributorInsightsEnabled Whether CloudWatch contributor insights is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsEnabled(java.lang.Boolean contributorInsightsEnabled) {
            this.contributorInsightsEnabled = contributorInsightsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getDeletionProtection}
         * @param deletionProtection Enables deletion protection for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getEncryption}
         * @param encryption Whether server-side encryption with an AWS managed customer master key is enabled.
         *                   This property cannot be set if <code>serverSideEncryption</code> is set.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   <strong>NOTE</strong>: if you set this to <code>CUSTOMER_MANAGED</code> and <code>encryptionKey</code> is not
         *                   specified, the key that the Tablet generates for you will be created with
         *                   default permissions. If you are using CDKv2, these permissions will be
         *                   sufficient to enable the key for use with DynamoDB tables.  If you are
         *                   using CDKv1, make sure the feature flag
         *                   <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> is set to <code>true</code> in your <code>cdk.json</code>.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.dynamodb.TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getEncryptionKey}
         * @param encryptionKey External KMS key to use for table encryption.
         *                      This property can only be set if <code>encryption</code> is set to <code>TableEncryption.CUSTOMER_MANAGED</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getImportSource}
         * @param importSource The properties of data being imported from the S3 bucket source to the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importSource(software.amazon.awscdk.services.dynamodb.ImportSourceSpecification importSource) {
            this.importSource = importSource;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getMaxReadRequestUnits}
         * @param maxReadRequestUnits The maximum read request units for the table.
         *                            Careful if you add Global Secondary Indexes, as
         *                            those will share the table's maximum on-demand throughput.
         *                            <p>
         *                            Can only be provided if billingMode is PAY_PER_REQUEST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReadRequestUnits(java.lang.Number maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getMaxWriteRequestUnits}
         * @param maxWriteRequestUnits The write request units for the table.
         *                             Careful if you add Global Secondary Indexes, as
         *                             those will share the table's maximum on-demand throughput.
         *                             <p>
         *                             Can only be provided if billingMode is PAY_PER_REQUEST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWriteRequestUnits(java.lang.Number maxWriteRequestUnits) {
            this.maxWriteRequestUnits = maxWriteRequestUnits;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getPointInTimeRecovery}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled.
         * @return {@code this}
         * @deprecated use `pointInTimeRecoverySpecification` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pointInTimeRecovery(java.lang.Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification Whether point-in-time recovery is enabled and recoveryPeriodInDays is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getReadCapacity}
         * @param readCapacity The read capacity for the table.
         *                     Careful if you add Global Secondary Indexes, as
         *                     those will share the table's provisioned throughput.
         *                     <p>
         *                     Can only be provided if billingMode is Provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(java.lang.Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to the DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getReplicationRegions}
         * @param replicationRegions Regions where replica tables will be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationRegions(java.util.List<java.lang.String> replicationRegions) {
            this.replicationRegions = replicationRegions;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getReplicationTimeout}
         * @param replicationTimeout The timeout for a table replication operation in a single region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationTimeout(software.amazon.awscdk.Duration replicationTimeout) {
            this.replicationTimeout = replicationTimeout;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getResourcePolicy}
         * @param resourcePolicy Resource policy to assign to table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getStream}
         * @param stream When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(software.amazon.awscdk.services.dynamodb.StreamViewType stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getTableClass}
         * @param tableClass Specify the table class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(software.amazon.awscdk.services.dynamodb.TableClass tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getTimeToLiveAttribute}
         * @param timeToLiveAttribute The name of TTL attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(java.lang.String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getWaitForReplicationToFinish}
         * @param waitForReplicationToFinish [WARNING: Use this flag with caution, misusing this flag may cause deleting existing replicas, refer to the detailed documentation for more information] Indicates whether CloudFormation stack waits for replication to finish.
         *                                   If set to false, the CloudFormation resource will mark the resource as
         *                                   created and replication will be completed asynchronously. This property is
         *                                   ignored if replicationRegions property is not set.
         *                                   <p>
         *                                   WARNING:
         *                                   DO NOT UNSET this property if adding/removing multiple replicationRegions
         *                                   in one deployment, as CloudFormation only supports one region replication
         *                                   at a time. CDK overcomes this limitation by waiting for replication to
         *                                   finish before starting new replicationRegion.
         *                                   <p>
         *                                   If the custom resource which handles replication has a physical resource
         *                                   ID with the format <code>region</code> instead of <code>tablename-region</code> (this would happen
         *                                   if the custom resource hasn't received an event since v1.91.0), DO NOT SET
         *                                   this property to false without making a change to the table name.
         *                                   This will cause the existing replicas to be deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitForReplicationToFinish(java.lang.Boolean waitForReplicationToFinish) {
            this.waitForReplicationToFinish = waitForReplicationToFinish;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getWarmThroughput}
         * @param warmThroughput Specify values to pre-warm you DynamoDB Table Warm Throughput feature is not available for Global Table replicas using the <code>Table</code> construct.
         *                       To enable Warm Throughput, use the <code>TableV2</code> construct instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getWriteCapacity}
         * @param writeCapacity The write capacity for the table.
         *                      Careful if you add Global Secondary Indexes, as
         *                      those will share the table's provisioned throughput.
         *                      <p>
         *                      Can only be provided if billingMode is Provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(java.lang.Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getPartitionKey}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableOptions#getSortKey}
         * @param sortKey Sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableOptions {
        private final software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        private final java.lang.Boolean contributorInsightsEnabled;
        private final java.lang.Boolean deletionProtection;
        private final software.amazon.awscdk.services.dynamodb.TableEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.dynamodb.ImportSourceSpecification importSource;
        private final java.lang.Number maxReadRequestUnits;
        private final java.lang.Number maxWriteRequestUnits;
        private final java.lang.Boolean pointInTimeRecovery;
        private final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        private final java.lang.Number readCapacity;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<java.lang.String> replicationRegions;
        private final software.amazon.awscdk.Duration replicationTimeout;
        private final software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        private final software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        private final software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        private final java.lang.String timeToLiveAttribute;
        private final java.lang.Boolean waitForReplicationToFinish;
        private final software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput;
        private final java.lang.Number writeCapacity;
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.billingMode = software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.BillingMode.class));
            this.contributorInsightsEnabled = software.amazon.jsii.Kernel.get(this, "contributorInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.importSource = software.amazon.jsii.Kernel.get(this, "importSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ImportSourceSpecification.class));
            this.maxReadRequestUnits = software.amazon.jsii.Kernel.get(this, "maxReadRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxWriteRequestUnits = software.amazon.jsii.Kernel.get(this, "maxWriteRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pointInTimeRecovery = software.amazon.jsii.Kernel.get(this, "pointInTimeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pointInTimeRecoverySpecification = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoverySpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification.class));
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.replicationRegions = software.amazon.jsii.Kernel.get(this, "replicationRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.replicationTimeout = software.amazon.jsii.Kernel.get(this, "replicationTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.StreamViewType.class));
            this.tableClass = software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableClass.class));
            this.timeToLiveAttribute = software.amazon.jsii.Kernel.get(this, "timeToLiveAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.waitForReplicationToFinish = software.amazon.jsii.Kernel.get(this, "waitForReplicationToFinish", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.warmThroughput = software.amazon.jsii.Kernel.get(this, "warmThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.WarmThroughput.class));
            this.writeCapacity = software.amazon.jsii.Kernel.get(this, "writeCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.billingMode = builder.billingMode;
            this.contributorInsightsEnabled = builder.contributorInsightsEnabled;
            this.deletionProtection = builder.deletionProtection;
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.importSource = builder.importSource;
            this.maxReadRequestUnits = builder.maxReadRequestUnits;
            this.maxWriteRequestUnits = builder.maxWriteRequestUnits;
            this.pointInTimeRecovery = builder.pointInTimeRecovery;
            this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
            this.readCapacity = builder.readCapacity;
            this.removalPolicy = builder.removalPolicy;
            this.replicationRegions = builder.replicationRegions;
            this.replicationTimeout = builder.replicationTimeout;
            this.resourcePolicy = builder.resourcePolicy;
            this.stream = builder.stream;
            this.tableClass = builder.tableClass;
            this.timeToLiveAttribute = builder.timeToLiveAttribute;
            this.waitForReplicationToFinish = builder.waitForReplicationToFinish;
            this.warmThroughput = builder.warmThroughput;
            this.writeCapacity = builder.writeCapacity;
            this.partitionKey = java.util.Objects.requireNonNull(builder.partitionKey, "partitionKey is required");
            this.sortKey = builder.sortKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final java.lang.Boolean getContributorInsightsEnabled() {
            return this.contributorInsightsEnabled;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ImportSourceSpecification getImportSource() {
            return this.importSource;
        }

        @Override
        public final java.lang.Number getMaxReadRequestUnits() {
            return this.maxReadRequestUnits;
        }

        @Override
        public final java.lang.Number getMaxWriteRequestUnits() {
            return this.maxWriteRequestUnits;
        }

        @Override
        public final java.lang.Boolean getPointInTimeRecovery() {
            return this.pointInTimeRecovery;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification;
        }

        @Override
        public final java.lang.Number getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<java.lang.String> getReplicationRegions() {
            return this.replicationRegions;
        }

        @Override
        public final software.amazon.awscdk.Duration getReplicationTimeout() {
            return this.replicationTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.StreamViewType getStream() {
            return this.stream;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableClass getTableClass() {
            return this.tableClass;
        }

        @Override
        public final java.lang.String getTimeToLiveAttribute() {
            return this.timeToLiveAttribute;
        }

        @Override
        public final java.lang.Boolean getWaitForReplicationToFinish() {
            return this.waitForReplicationToFinish;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.WarmThroughput getWarmThroughput() {
            return this.warmThroughput;
        }

        @Override
        public final java.lang.Number getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getContributorInsightsEnabled() != null) {
                data.set("contributorInsightsEnabled", om.valueToTree(this.getContributorInsightsEnabled()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getImportSource() != null) {
                data.set("importSource", om.valueToTree(this.getImportSource()));
            }
            if (this.getMaxReadRequestUnits() != null) {
                data.set("maxReadRequestUnits", om.valueToTree(this.getMaxReadRequestUnits()));
            }
            if (this.getMaxWriteRequestUnits() != null) {
                data.set("maxWriteRequestUnits", om.valueToTree(this.getMaxWriteRequestUnits()));
            }
            if (this.getPointInTimeRecovery() != null) {
                data.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
            }
            if (this.getPointInTimeRecoverySpecification() != null) {
                data.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
            }
            if (this.getReadCapacity() != null) {
                data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReplicationRegions() != null) {
                data.set("replicationRegions", om.valueToTree(this.getReplicationRegions()));
            }
            if (this.getReplicationTimeout() != null) {
                data.set("replicationTimeout", om.valueToTree(this.getReplicationTimeout()));
            }
            if (this.getResourcePolicy() != null) {
                data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
            }
            if (this.getStream() != null) {
                data.set("stream", om.valueToTree(this.getStream()));
            }
            if (this.getTableClass() != null) {
                data.set("tableClass", om.valueToTree(this.getTableClass()));
            }
            if (this.getTimeToLiveAttribute() != null) {
                data.set("timeToLiveAttribute", om.valueToTree(this.getTimeToLiveAttribute()));
            }
            if (this.getWaitForReplicationToFinish() != null) {
                data.set("waitForReplicationToFinish", om.valueToTree(this.getWaitForReplicationToFinish()));
            }
            if (this.getWarmThroughput() != null) {
                data.set("warmThroughput", om.valueToTree(this.getWarmThroughput()));
            }
            if (this.getWriteCapacity() != null) {
                data.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
            }
            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.TableOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableOptions.Jsii$Proxy that = (TableOptions.Jsii$Proxy) o;

            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.contributorInsightsEnabled != null ? !this.contributorInsightsEnabled.equals(that.contributorInsightsEnabled) : that.contributorInsightsEnabled != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.importSource != null ? !this.importSource.equals(that.importSource) : that.importSource != null) return false;
            if (this.maxReadRequestUnits != null ? !this.maxReadRequestUnits.equals(that.maxReadRequestUnits) : that.maxReadRequestUnits != null) return false;
            if (this.maxWriteRequestUnits != null ? !this.maxWriteRequestUnits.equals(that.maxWriteRequestUnits) : that.maxWriteRequestUnits != null) return false;
            if (this.pointInTimeRecovery != null ? !this.pointInTimeRecovery.equals(that.pointInTimeRecovery) : that.pointInTimeRecovery != null) return false;
            if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.replicationRegions != null ? !this.replicationRegions.equals(that.replicationRegions) : that.replicationRegions != null) return false;
            if (this.replicationTimeout != null ? !this.replicationTimeout.equals(that.replicationTimeout) : that.replicationTimeout != null) return false;
            if (this.resourcePolicy != null ? !this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy != null) return false;
            if (this.stream != null ? !this.stream.equals(that.stream) : that.stream != null) return false;
            if (this.tableClass != null ? !this.tableClass.equals(that.tableClass) : that.tableClass != null) return false;
            if (this.timeToLiveAttribute != null ? !this.timeToLiveAttribute.equals(that.timeToLiveAttribute) : that.timeToLiveAttribute != null) return false;
            if (this.waitForReplicationToFinish != null ? !this.waitForReplicationToFinish.equals(that.waitForReplicationToFinish) : that.waitForReplicationToFinish != null) return false;
            if (this.warmThroughput != null ? !this.warmThroughput.equals(that.warmThroughput) : that.warmThroughput != null) return false;
            if (this.writeCapacity != null ? !this.writeCapacity.equals(that.writeCapacity) : that.writeCapacity != null) return false;
            if (!partitionKey.equals(that.partitionKey)) return false;
            return this.sortKey != null ? this.sortKey.equals(that.sortKey) : that.sortKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.billingMode != null ? this.billingMode.hashCode() : 0;
            result = 31 * result + (this.contributorInsightsEnabled != null ? this.contributorInsightsEnabled.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.importSource != null ? this.importSource.hashCode() : 0);
            result = 31 * result + (this.maxReadRequestUnits != null ? this.maxReadRequestUnits.hashCode() : 0);
            result = 31 * result + (this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecovery != null ? this.pointInTimeRecovery.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.replicationRegions != null ? this.replicationRegions.hashCode() : 0);
            result = 31 * result + (this.replicationTimeout != null ? this.replicationTimeout.hashCode() : 0);
            result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
            result = 31 * result + (this.stream != null ? this.stream.hashCode() : 0);
            result = 31 * result + (this.tableClass != null ? this.tableClass.hashCode() : 0);
            result = 31 * result + (this.timeToLiveAttribute != null ? this.timeToLiveAttribute.hashCode() : 0);
            result = 31 * result + (this.waitForReplicationToFinish != null ? this.waitForReplicationToFinish.hashCode() : 0);
            result = 31 * result + (this.warmThroughput != null ? this.warmThroughput.hashCode() : 0);
            result = 31 * result + (this.writeCapacity != null ? this.writeCapacity.hashCode() : 0);
            result = 31 * result + (this.partitionKey.hashCode());
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            return result;
        }
    }
}
