package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnKeyPair</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnKeyPairProps cfnKeyPairProps = CfnKeyPairProps.builder()
 *         .keyName("keyName")
 *         // the properties below are optional
 *         .keyFormat("keyFormat")
 *         .keyType("keyType")
 *         .publicKeyMaterial("publicKeyMaterial")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:53.011Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnKeyPairProps")
@software.amazon.jsii.Jsii.Proxy(CfnKeyPairProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKeyPairProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique name for the key pair.
     * <p>
     * Constraints: Up to 255 ASCII characters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-keyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-keyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyName();

    /**
     * The format of the key pair.
     * <p>
     * Default: <code>pem</code>
     * <p>
     * Default: - "pem"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-keyformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-keyformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyFormat() {
        return null;
    }

    /**
     * The type of key pair. Note that ED25519 keys are not supported for Windows instances.
     * <p>
     * If the <code>PublicKeyMaterial</code> property is specified, the <code>KeyType</code> property is ignored, and the key type is inferred from the <code>PublicKeyMaterial</code> value.
     * <p>
     * Default: <code>rsa</code>
     * <p>
     * Default: - "rsa"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-keytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyType() {
        return null;
    }

    /**
     * The public key material.
     * <p>
     * The <code>PublicKeyMaterial</code> property is used to import a key pair. If this property is not specified, then a new key pair will be created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-publickeymaterial">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-publickeymaterial</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicKeyMaterial() {
        return null;
    }

    /**
     * The tags to apply to the key pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-keypair.html#cfn-ec2-keypair-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnKeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKeyPairProps> {
        java.lang.String keyName;
        java.lang.String keyFormat;
        java.lang.String keyType;
        java.lang.String publicKeyMaterial;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnKeyPairProps#getKeyName}
         * @param keyName A unique name for the key pair. This parameter is required.
         *                Constraints: Up to 255 ASCII characters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyPairProps#getKeyFormat}
         * @param keyFormat The format of the key pair.
         *                  Default: <code>pem</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyFormat(java.lang.String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyPairProps#getKeyType}
         * @param keyType The type of key pair. Note that ED25519 keys are not supported for Windows instances.
         *                If the <code>PublicKeyMaterial</code> property is specified, the <code>KeyType</code> property is ignored, and the key type is inferred from the <code>PublicKeyMaterial</code> value.
         *                <p>
         *                Default: <code>rsa</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyType(java.lang.String keyType) {
            this.keyType = keyType;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyPairProps#getPublicKeyMaterial}
         * @param publicKeyMaterial The public key material.
         *                          The <code>PublicKeyMaterial</code> property is used to import a key pair. If this property is not specified, then a new key pair will be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKeyMaterial(java.lang.String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyPairProps#getTags}
         * @param tags The tags to apply to the key pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKeyPairProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKeyPairProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKeyPairProps {
        private final java.lang.String keyName;
        private final java.lang.String keyFormat;
        private final java.lang.String keyType;
        private final java.lang.String publicKeyMaterial;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyFormat = software.amazon.jsii.Kernel.get(this, "keyFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicKeyMaterial = software.amazon.jsii.Kernel.get(this, "publicKeyMaterial", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyName = java.util.Objects.requireNonNull(builder.keyName, "keyName is required");
            this.keyFormat = builder.keyFormat;
            this.keyType = builder.keyType;
            this.publicKeyMaterial = builder.publicKeyMaterial;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.String getKeyFormat() {
            return this.keyFormat;
        }

        @Override
        public final java.lang.String getKeyType() {
            return this.keyType;
        }

        @Override
        public final java.lang.String getPublicKeyMaterial() {
            return this.publicKeyMaterial;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyName", om.valueToTree(this.getKeyName()));
            if (this.getKeyFormat() != null) {
                data.set("keyFormat", om.valueToTree(this.getKeyFormat()));
            }
            if (this.getKeyType() != null) {
                data.set("keyType", om.valueToTree(this.getKeyType()));
            }
            if (this.getPublicKeyMaterial() != null) {
                data.set("publicKeyMaterial", om.valueToTree(this.getPublicKeyMaterial()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnKeyPairProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKeyPairProps.Jsii$Proxy that = (CfnKeyPairProps.Jsii$Proxy) o;

            if (!keyName.equals(that.keyName)) return false;
            if (this.keyFormat != null ? !this.keyFormat.equals(that.keyFormat) : that.keyFormat != null) return false;
            if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) return false;
            if (this.publicKeyMaterial != null ? !this.publicKeyMaterial.equals(that.publicKeyMaterial) : that.publicKeyMaterial != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keyName.hashCode();
            result = 31 * result + (this.keyFormat != null ? this.keyFormat.hashCode() : 0);
            result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
            result = 31 * result + (this.publicKeyMaterial != null ? this.publicKeyMaterial.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
