package software.amazon.awscdk.services.ec2;

/**
 * The type of Subnet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Login.builder()
 *                 .username("myuser") // NOTE: 'admin' is reserved by DocumentDB
 *                 .excludeCharacters("\"&#64;/:") // optional, defaults to the set "\"&#64;/" and is also used for eventually created rotations
 *                 .secretName("/myapp/mydocdb/masteruser")
 *                 .build())
 *         .instanceType(InstanceType.of(InstanceClass.MEMORY5, InstanceSize.LARGE))
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .vpc(vpc)
 *         .copyTagsToSnapshot(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:53.516Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.SubnetType")
public enum SubnetType {
    /**
     * Isolated Subnets do not route traffic to the Internet (in this VPC), and as such, do not require NAT gateways.
     * <p>
     * Isolated subnets can only connect to or be connected to from other
     * instances in the same VPC. A default VPC configuration will not include
     * isolated subnets.
     * <p>
     * This can be good for subnets with RDS or Elasticache instances,
     * or which route Internet traffic through a peer VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRIVATE_ISOLATED,
    /**
     * Subnet that routes to the internet, but not vice versa.
     * <p>
     * Instances in a private subnet can connect to the Internet, but will not
     * allow connections to be initiated from the Internet. Egress to the internet will
     * need to be provided.
     * NAT Gateway(s) are the default solution to providing this subnet type the ability to route Internet traffic.
     * If a NAT Gateway is not required or desired, set <code>natGateways:0</code> or use
     * <code>SubnetType.PRIVATE_ISOLATED</code> instead.
     * <p>
     * By default, a NAT gateway is created in every public subnet for maximum availability.
     * Be aware that you will be charged for NAT gateways.
     * <p>
     * Normally a Private subnet will use a NAT gateway in the same AZ, but
     * if <code>natGateways</code> is used to reduce the number of NAT gateways, a NAT
     * gateway from another AZ will be used instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRIVATE_WITH_EGRESS,
    /**
     * (deprecated) Subnet that routes to the internet (via a NAT gateway), but not vice versa.
     * <p>
     * Instances in a private subnet can connect to the Internet, but will not
     * allow connections to be initiated from the Internet. NAT Gateway(s) are
     * required with this subnet type to route the Internet traffic through.
     * If a NAT Gateway is not required or desired, use <code>SubnetType.PRIVATE_ISOLATED</code> instead.
     * <p>
     * By default, a NAT gateway is created in every public subnet for maximum availability.
     * Be aware that you will be charged for NAT gateways.
     * <p>
     * Normally a Private subnet will use a NAT gateway in the same AZ, but
     * if <code>natGateways</code> is used to reduce the number of NAT gateways, a NAT
     * gateway from another AZ will be used instead.
     * <p>
     * @deprecated use <code>PRIVATE_WITH_EGRESS</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    PRIVATE_WITH_NAT,
    /**
     * Subnet connected to the Internet.
     * <p>
     * Instances in a Public subnet can connect to the Internet and can be
     * connected to from the Internet as long as they are launched with public
     * IPs (controlled on the AutoScalingGroup or other constructs that launch
     * instances).
     * <p>
     * Public subnets route outbound traffic via an Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC,
}
