package software.amazon.awscdk.services.ecs;

/**
 * The configuration for a Docker volume.
 * <p>
 * Docker volumes are only supported when you are using the EC2 launch type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * DockerVolumeConfiguration dockerVolumeConfiguration = DockerVolumeConfiguration.builder()
 *         .driver("driver")
 *         .scope(Scope.TASK)
 *         // the properties below are optional
 *         .autoprovision(false)
 *         .driverOpts(Map.of(
 *                 "driverOptsKey", "driverOpts"))
 *         .labels(Map.of(
 *                 "labelsKey", "labels"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:53.804Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DockerVolumeConfiguration")
@software.amazon.jsii.Jsii.Proxy(DockerVolumeConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerVolumeConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Docker volume driver to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDriver();

    /**
     * The scope for the Docker volume that determines its lifecycle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Scope getScope();

    /**
     * Specifies whether the Docker volume should be created if it does not already exist.
     * <p>
     * If true is specified, the Docker volume will be created for you.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoprovision() {
        return null;
    }

    /**
     * A map of Docker driver-specific options passed through.
     * <p>
     * Default: No options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDriverOpts() {
        return null;
    }

    /**
     * Custom metadata to add to your Docker volume.
     * <p>
     * Default: No labels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerVolumeConfiguration> {
        java.lang.String driver;
        software.amazon.awscdk.services.ecs.Scope scope;
        java.lang.Boolean autoprovision;
        java.util.Map<java.lang.String, java.lang.String> driverOpts;
        java.util.Map<java.lang.String, java.lang.String> labels;

        /**
         * Sets the value of {@link DockerVolumeConfiguration#getDriver}
         * @param driver The Docker volume driver to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder driver(java.lang.String driver) {
            this.driver = driver;
            return this;
        }

        /**
         * Sets the value of {@link DockerVolumeConfiguration#getScope}
         * @param scope The scope for the Docker volume that determines its lifecycle. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.services.ecs.Scope scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link DockerVolumeConfiguration#getAutoprovision}
         * @param autoprovision Specifies whether the Docker volume should be created if it does not already exist.
         *                      If true is specified, the Docker volume will be created for you.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoprovision(java.lang.Boolean autoprovision) {
            this.autoprovision = autoprovision;
            return this;
        }

        /**
         * Sets the value of {@link DockerVolumeConfiguration#getDriverOpts}
         * @param driverOpts A map of Docker driver-specific options passed through.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder driverOpts(java.util.Map<java.lang.String, java.lang.String> driverOpts) {
            this.driverOpts = driverOpts;
            return this;
        }

        /**
         * Sets the value of {@link DockerVolumeConfiguration#getLabels}
         * @param labels Custom metadata to add to your Docker volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerVolumeConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerVolumeConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DockerVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerVolumeConfiguration {
        private final java.lang.String driver;
        private final software.amazon.awscdk.services.ecs.Scope scope;
        private final java.lang.Boolean autoprovision;
        private final java.util.Map<java.lang.String, java.lang.String> driverOpts;
        private final java.util.Map<java.lang.String, java.lang.String> labels;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.driver = software.amazon.jsii.Kernel.get(this, "driver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Scope.class));
            this.autoprovision = software.amazon.jsii.Kernel.get(this, "autoprovision", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.driverOpts = software.amazon.jsii.Kernel.get(this, "driverOpts", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.driver = java.util.Objects.requireNonNull(builder.driver, "driver is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            this.autoprovision = builder.autoprovision;
            this.driverOpts = builder.driverOpts;
            this.labels = builder.labels;
        }

        @Override
        public final java.lang.String getDriver() {
            return this.driver;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.Scope getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.Boolean getAutoprovision() {
            return this.autoprovision;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDriverOpts() {
            return this.driverOpts;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("driver", om.valueToTree(this.getDriver()));
            data.set("scope", om.valueToTree(this.getScope()));
            if (this.getAutoprovision() != null) {
                data.set("autoprovision", om.valueToTree(this.getAutoprovision()));
            }
            if (this.getDriverOpts() != null) {
                data.set("driverOpts", om.valueToTree(this.getDriverOpts()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.DockerVolumeConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerVolumeConfiguration.Jsii$Proxy that = (DockerVolumeConfiguration.Jsii$Proxy) o;

            if (!driver.equals(that.driver)) return false;
            if (!scope.equals(that.scope)) return false;
            if (this.autoprovision != null ? !this.autoprovision.equals(that.autoprovision) : that.autoprovision != null) return false;
            if (this.driverOpts != null ? !this.driverOpts.equals(that.driverOpts) : that.driverOpts != null) return false;
            return this.labels != null ? this.labels.equals(that.labels) : that.labels == null;
        }

        @Override
        public final int hashCode() {
            int result = this.driver.hashCode();
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.autoprovision != null ? this.autoprovision.hashCode() : 0);
            result = 31 * result + (this.driverOpts != null ? this.driverOpts.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            return result;
        }
    }
}
