package software.amazon.awscdk.services.ecs;

/**
 * Port mappings allow containers to access ports on the host container instance to send or receive traffic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ContainerDefinition container;
 * container.addPortMappings(PortMapping.builder()
 *         .containerPort(ContainerDefinition.CONTAINER_PORT_USE_RANGE)
 *         .containerPortRange("8080-8081")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:53.887Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.PortMapping")
@software.amazon.jsii.Jsii.Proxy(PortMapping.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PortMapping extends software.amazon.jsii.JsiiSerializable {

    /**
     * The port number on the container that is bound to the user-specified or automatically assigned host port.
     * <p>
     * If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
     * If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
     * your container automatically receives a host port in the ephemeral port range.
     * <p>
     * For more information, see hostPort.
     * Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
     * <p>
     * If you want to expose a port range, you must specify <code>CONTAINER_PORT_USE_RANGE</code> as container port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getContainerPort();

    /**
     * The protocol used by Service Connect.
     * <p>
     * Valid values are AppProtocol.http, AppProtocol.http2, and
     * AppProtocol.grpc. The protocol determines what telemetry will be shown in the ECS Console for
     * Service Connect services using this port mapping.
     * <p>
     * This field may only be set when the task definition uses Bridge or Awsvpc network modes.
     * <p>
     * Default: - no app protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AppProtocol getAppProtocol() {
        return null;
    }

    /**
     * The port number range on the container that's bound to the dynamically mapped host port range.
     * <p>
     * The following rules apply when you specify a <code>containerPortRange</code>:
     * <p>
     * <ul>
     * <li>You must specify <code>CONTAINER_PORT_USE_RANGE</code> as <code>containerPort</code></li>
     * <li>You must use either the <code>bridge</code> network mode or the <code>awsvpc</code> network mode.</li>
     * <li>The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the <code>ecs-init</code> package</li>
     * <li>You can specify a maximum of 100 port ranges per container.</li>
     * <li>A port can only be included in one port mapping per container.</li>
     * <li>You cannot specify overlapping port ranges.</li>
     * <li>The first port in the range must be less than last port in the range.</li>
     * </ul>
     * <p>
     * If you want to expose a single port, you must not set a range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerPortRange() {
        return null;
    }

    /**
     * The port number on the container instance to reserve for your container.
     * <p>
     * If you are using containers in a task with the awsvpc or host network mode,
     * the hostPort can either be left blank or set to the same value as the containerPort.
     * <p>
     * If you are using containers in a task with the bridge network mode,
     * you can specify a non-reserved host port for your container port mapping, or
     * you can omit the hostPort (or set it to 0) while specifying a containerPort and
     * your container automatically receives a port in the ephemeral port range for
     * your container instance operating system and Docker version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHostPort() {
        return null;
    }

    /**
     * The name to give the port mapping.
     * <p>
     * Name is required in order to use the port mapping with ECS Service Connect.
     * This field may only be set when the task definition uses Bridge or Awsvpc network modes.
     * <p>
     * Default: - no port mapping name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The protocol used for the port mapping.
     * <p>
     * Valid values are Protocol.TCP and Protocol.UDP.
     * <p>
     * Default: TCP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.Protocol getProtocol() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PortMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PortMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PortMapping> {
        java.lang.Number containerPort;
        software.amazon.awscdk.services.ecs.AppProtocol appProtocol;
        java.lang.String containerPortRange;
        java.lang.Number hostPort;
        java.lang.String name;
        software.amazon.awscdk.services.ecs.Protocol protocol;

        /**
         * Sets the value of {@link PortMapping#getContainerPort}
         * @param containerPort The port number on the container that is bound to the user-specified or automatically assigned host port. This parameter is required.
         *                      If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
         *                      If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
         *                      your container automatically receives a host port in the ephemeral port range.
         *                      <p>
         *                      For more information, see hostPort.
         *                      Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
         *                      <p>
         *                      If you want to expose a port range, you must specify <code>CONTAINER_PORT_USE_RANGE</code> as container port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPort(java.lang.Number containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        /**
         * Sets the value of {@link PortMapping#getAppProtocol}
         * @param appProtocol The protocol used by Service Connect.
         *                    Valid values are AppProtocol.http, AppProtocol.http2, and
         *                    AppProtocol.grpc. The protocol determines what telemetry will be shown in the ECS Console for
         *                    Service Connect services using this port mapping.
         *                    <p>
         *                    This field may only be set when the task definition uses Bridge or Awsvpc network modes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appProtocol(software.amazon.awscdk.services.ecs.AppProtocol appProtocol) {
            this.appProtocol = appProtocol;
            return this;
        }

        /**
         * Sets the value of {@link PortMapping#getContainerPortRange}
         * @param containerPortRange The port number range on the container that's bound to the dynamically mapped host port range.
         *                           The following rules apply when you specify a <code>containerPortRange</code>:
         *                           <p>
         *                           <ul>
         *                           <li>You must specify <code>CONTAINER_PORT_USE_RANGE</code> as <code>containerPort</code></li>
         *                           <li>You must use either the <code>bridge</code> network mode or the <code>awsvpc</code> network mode.</li>
         *                           <li>The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the <code>ecs-init</code> package</li>
         *                           <li>You can specify a maximum of 100 port ranges per container.</li>
         *                           <li>A port can only be included in one port mapping per container.</li>
         *                           <li>You cannot specify overlapping port ranges.</li>
         *                           <li>The first port in the range must be less than last port in the range.</li>
         *                           </ul>
         *                           <p>
         *                           If you want to expose a single port, you must not set a range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPortRange(java.lang.String containerPortRange) {
            this.containerPortRange = containerPortRange;
            return this;
        }

        /**
         * Sets the value of {@link PortMapping#getHostPort}
         * @param hostPort The port number on the container instance to reserve for your container.
         *                 If you are using containers in a task with the awsvpc or host network mode,
         *                 the hostPort can either be left blank or set to the same value as the containerPort.
         *                 <p>
         *                 If you are using containers in a task with the bridge network mode,
         *                 you can specify a non-reserved host port for your container port mapping, or
         *                 you can omit the hostPort (or set it to 0) while specifying a containerPort and
         *                 your container automatically receives a port in the ephemeral port range for
         *                 your container instance operating system and Docker version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPort(java.lang.Number hostPort) {
            this.hostPort = hostPort;
            return this;
        }

        /**
         * Sets the value of {@link PortMapping#getName}
         * @param name The name to give the port mapping.
         *             Name is required in order to use the port mapping with ECS Service Connect.
         *             This field may only be set when the task definition uses Bridge or Awsvpc network modes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link PortMapping#getProtocol}
         * @param protocol The protocol used for the port mapping.
         *                 Valid values are Protocol.TCP and Protocol.UDP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.ecs.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortMapping}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PortMapping build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PortMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortMapping {
        private final java.lang.Number containerPort;
        private final software.amazon.awscdk.services.ecs.AppProtocol appProtocol;
        private final java.lang.String containerPortRange;
        private final java.lang.Number hostPort;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.ecs.Protocol protocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.appProtocol = software.amazon.jsii.Kernel.get(this, "appProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AppProtocol.class));
            this.containerPortRange = software.amazon.jsii.Kernel.get(this, "containerPortRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostPort = software.amazon.jsii.Kernel.get(this, "hostPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Protocol.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerPort = java.util.Objects.requireNonNull(builder.containerPort, "containerPort is required");
            this.appProtocol = builder.appProtocol;
            this.containerPortRange = builder.containerPortRange;
            this.hostPort = builder.hostPort;
            this.name = builder.name;
            this.protocol = builder.protocol;
        }

        @Override
        public final java.lang.Number getContainerPort() {
            return this.containerPort;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.AppProtocol getAppProtocol() {
            return this.appProtocol;
        }

        @Override
        public final java.lang.String getContainerPortRange() {
            return this.containerPortRange;
        }

        @Override
        public final java.lang.Number getHostPort() {
            return this.hostPort;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerPort", om.valueToTree(this.getContainerPort()));
            if (this.getAppProtocol() != null) {
                data.set("appProtocol", om.valueToTree(this.getAppProtocol()));
            }
            if (this.getContainerPortRange() != null) {
                data.set("containerPortRange", om.valueToTree(this.getContainerPortRange()));
            }
            if (this.getHostPort() != null) {
                data.set("hostPort", om.valueToTree(this.getHostPort()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.PortMapping"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PortMapping.Jsii$Proxy that = (PortMapping.Jsii$Proxy) o;

            if (!containerPort.equals(that.containerPort)) return false;
            if (this.appProtocol != null ? !this.appProtocol.equals(that.appProtocol) : that.appProtocol != null) return false;
            if (this.containerPortRange != null ? !this.containerPortRange.equals(that.containerPortRange) : that.containerPortRange != null) return false;
            if (this.hostPort != null ? !this.hostPort.equals(that.hostPort) : that.hostPort != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerPort.hashCode();
            result = 31 * result + (this.appProtocol != null ? this.appProtocol.hashCode() : 0);
            result = 31 * result + (this.containerPortRange != null ? this.containerPortRange.hashCode() : 0);
            result = 31 * result + (this.hostPort != null ? this.hostPort.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            return result;
        }
    }
}
