package software.amazon.awscdk.services.efs;

/**
 * The <code>AWS::EFS::FileSystem</code> resource creates a new, empty file system in Amazon Elastic File System ( Amazon EFS ).
 * <p>
 * You must create a mount target ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html">AWS::EFS::MountTarget</a> ) to mount your EFS file system on an Amazon EC2 or other AWS cloud compute resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * Object fileSystemPolicy;
 * CfnFileSystem cfnFileSystem = CfnFileSystem.Builder.create(this, "MyCfnFileSystem")
 *         .availabilityZoneName("availabilityZoneName")
 *         .backupPolicy(BackupPolicyProperty.builder()
 *                 .status("status")
 *                 .build())
 *         .bypassPolicyLockoutSafetyCheck(false)
 *         .encrypted(false)
 *         .fileSystemPolicy(fileSystemPolicy)
 *         .fileSystemProtection(FileSystemProtectionProperty.builder()
 *                 .replicationOverwriteProtection("replicationOverwriteProtection")
 *                 .build())
 *         .fileSystemTags(List.of(ElasticFileSystemTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .kmsKeyId("kmsKeyId")
 *         .lifecyclePolicies(List.of(LifecyclePolicyProperty.builder()
 *                 .transitionToArchive("transitionToArchive")
 *                 .transitionToIa("transitionToIa")
 *                 .transitionToPrimaryStorageClass("transitionToPrimaryStorageClass")
 *                 .build()))
 *         .performanceMode("performanceMode")
 *         .provisionedThroughputInMibps(123)
 *         .replicationConfiguration(ReplicationConfigurationProperty.builder()
 *                 .destinations(List.of(ReplicationDestinationProperty.builder()
 *                         .availabilityZoneName("availabilityZoneName")
 *                         .fileSystemId("fileSystemId")
 *                         .kmsKeyId("kmsKeyId")
 *                         .region("region")
 *                         .roleArn("roleArn")
 *                         .status("status")
 *                         .statusMessage("statusMessage")
 *                         .build()))
 *                 .build())
 *         .throughputMode("throughputMode")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.066Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem")
public class CfnFileSystem extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.efs.CfnFileSystem.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.CfnFileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the EFS file system.
     * <p>
     * Example: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-0123456789abcdef8</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the EFS file system.
     * <p>
     * For example: <code>fs-abcdef0123456789a</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "attrFileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * For One Zone file systems, specify the AWS Availability Zone in which to create the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneName() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For One Zone file systems, specify the AWS Availability Zone in which to create the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneName", value);
    }

    /**
     * Use the <code>BackupPolicy</code> to turn automatic backups on or off for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBackupPolicy() {
        return software.amazon.jsii.Kernel.get(this, "backupPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use the <code>BackupPolicy</code> to turn automatic backups on or off for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "backupPolicy", value);
    }

    /**
     * Use the <code>BackupPolicy</code> to turn automatic backups on or off for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.CfnFileSystem.BackupPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "backupPolicy", value);
    }

    /**
     * (Optional) A boolean that specifies whether or not to bypass the <code>FileSystemPolicy</code> lockout safety check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBypassPolicyLockoutSafetyCheck() {
        return software.amazon.jsii.Kernel.get(this, "bypassPolicyLockoutSafetyCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (Optional) A boolean that specifies whether or not to bypass the <code>FileSystemPolicy</code> lockout safety check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBypassPolicyLockoutSafetyCheck(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "bypassPolicyLockoutSafetyCheck", value);
    }

    /**
     * (Optional) A boolean that specifies whether or not to bypass the <code>FileSystemPolicy</code> lockout safety check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBypassPolicyLockoutSafetyCheck(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bypassPolicyLockoutSafetyCheck", value);
    }

    /**
     * A Boolean value that, if true, creates an encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value that, if true, creates an encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "encrypted", value);
    }

    /**
     * A Boolean value that, if true, creates an encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encrypted", value);
    }

    /**
     * The <code>FileSystemPolicy</code> for the EFS file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemPolicy() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <code>FileSystemPolicy</code> for the EFS file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemPolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemPolicy", value);
    }

    /**
     * Describes the protection on the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemProtection() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the protection on the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemProtection", value);
    }

    /**
     * Describes the protection on the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.CfnFileSystem.FileSystemProtectionProperty value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemProtection", value);
    }

    /**
     * Use to create one or more tags associated with the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> getFileSystemTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty>)(software.amazon.jsii.Kernel.get(this, "fileSystemTagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Use to create one or more tags associated with the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemTagsRaw", value);
    }

    /**
     * The ID of the AWS KMS key to be used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS KMS key to be used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLifecyclePolicies() {
        return software.amazon.jsii.Kernel.get(this, "lifecyclePolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecyclePolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lifecyclePolicies", value);
    }

    /**
     * An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecyclePolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.efs.CfnFileSystem.LifecyclePolicyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.efs.CfnFileSystem.LifecyclePolicyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "lifecyclePolicies", value);
    }

    /**
     * The performance mode of the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPerformanceMode() {
        return software.amazon.jsii.Kernel.get(this, "performanceMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The performance mode of the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "performanceMode", value);
    }

    /**
     * The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedThroughputInMibps() {
        return software.amazon.jsii.Kernel.get(this, "provisionedThroughputInMibps", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedThroughputInMibps(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "provisionedThroughputInMibps", value);
    }

    /**
     * Describes the replication configuration for a specific file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplicationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "replicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the replication configuration for a specific file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replicationConfiguration", value);
    }

    /**
     * Describes the replication configuration for a specific file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.CfnFileSystem.ReplicationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "replicationConfiguration", value);
    }

    /**
     * Specifies the throughput mode for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThroughputMode() {
        return software.amazon.jsii.Kernel.get(this, "throughputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the throughput mode for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThroughputMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "throughputMode", value);
    }
    /**
     * The backup policy turns automatic backups for the file system on or off.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * BackupPolicyProperty backupPolicyProperty = BackupPolicyProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.BackupPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(BackupPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BackupPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set the backup policy status for the file system.
         * <p>
         * <ul>
         * <li><em><code>ENABLED</code></em> - Turns automatic backups on for the file system.</li>
         * <li><em><code>DISABLED</code></em> - Turns automatic backups off for the file system.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html#cfn-efs-filesystem-backuppolicy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html#cfn-efs-filesystem-backuppolicy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link BackupPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BackupPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BackupPolicyProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link BackupPolicyProperty#getStatus}
             * @param status Set the backup policy status for the file system. This parameter is required.
             *               <ul>
             *               <li><em><code>ENABLED</code></em> - Turns automatic backups on for the file system.</li>
             *               <li><em><code>DISABLED</code></em> - Turns automatic backups off for the file system.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BackupPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BackupPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BackupPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPolicyProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.BackupPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BackupPolicyProperty.Jsii$Proxy that = (BackupPolicyProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }
    /**
     * A tag is a key-value pair attached to a file system.
     * <p>
     * Allowed characters in the <code>Key</code> and <code>Value</code> properties are letters, white space, and numbers that can be represented in UTF-8, and the following characters: <code>+ - = . _ : /</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * ElasticFileSystemTagProperty elasticFileSystemTagProperty = ElasticFileSystemTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.ElasticFileSystemTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticFileSystemTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticFileSystemTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tag key (String).
         * <p>
         * The key can't start with <code>aws:</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of the tag key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ElasticFileSystemTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticFileSystemTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticFileSystemTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ElasticFileSystemTagProperty#getKey}
             * @param key The tag key (String). This parameter is required.
             *            The key can't start with <code>aws:</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ElasticFileSystemTagProperty#getValue}
             * @param value The value of the tag key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticFileSystemTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticFileSystemTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticFileSystemTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticFileSystemTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.ElasticFileSystemTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticFileSystemTagProperty.Jsii$Proxy that = (ElasticFileSystemTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the protection on the file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * FileSystemProtectionProperty fileSystemProtectionProperty = FileSystemProtectionProperty.builder()
     *         .replicationOverwriteProtection("replicationOverwriteProtection")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-filesystemprotection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-filesystemprotection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.FileSystemProtectionProperty")
    @software.amazon.jsii.Jsii.Proxy(FileSystemProtectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileSystemProtectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status of the file system's replication overwrite protection.
         * <p>
         * <ul>
         * <li><code>ENABLED</code> – The file system cannot be used as the destination file system in a replication configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by default.</li>
         * <li><code>DISABLED</code> – The file system can be used as the destination file system in a replication configuration. The file system is read-only and can only be modified by EFS replication.</li>
         * <li><code>REPLICATING</code> – The file system is being used as the destination file system in a replication configuration. The file system is read-only and is modified only by EFS replication.</li>
         * </ul>
         * <p>
         * If the replication configuration is deleted, the file system's replication overwrite protection is re-enabled, the file system becomes writeable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-filesystemprotection.html#cfn-efs-filesystem-filesystemprotection-replicationoverwriteprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-filesystemprotection.html#cfn-efs-filesystem-filesystemprotection-replicationoverwriteprotection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplicationOverwriteProtection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileSystemProtectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileSystemProtectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileSystemProtectionProperty> {
            java.lang.String replicationOverwriteProtection;

            /**
             * Sets the value of {@link FileSystemProtectionProperty#getReplicationOverwriteProtection}
             * @param replicationOverwriteProtection The status of the file system's replication overwrite protection.
             *                                       <ul>
             *                                       <li><code>ENABLED</code> – The file system cannot be used as the destination file system in a replication configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by default.</li>
             *                                       <li><code>DISABLED</code> – The file system can be used as the destination file system in a replication configuration. The file system is read-only and can only be modified by EFS replication.</li>
             *                                       <li><code>REPLICATING</code> – The file system is being used as the destination file system in a replication configuration. The file system is read-only and is modified only by EFS replication.</li>
             *                                       </ul>
             *                                       <p>
             *                                       If the replication configuration is deleted, the file system's replication overwrite protection is re-enabled, the file system becomes writeable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationOverwriteProtection(java.lang.String replicationOverwriteProtection) {
                this.replicationOverwriteProtection = replicationOverwriteProtection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileSystemProtectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileSystemProtectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileSystemProtectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemProtectionProperty {
            private final java.lang.String replicationOverwriteProtection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replicationOverwriteProtection = software.amazon.jsii.Kernel.get(this, "replicationOverwriteProtection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replicationOverwriteProtection = builder.replicationOverwriteProtection;
            }

            @Override
            public final java.lang.String getReplicationOverwriteProtection() {
                return this.replicationOverwriteProtection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplicationOverwriteProtection() != null) {
                    data.set("replicationOverwriteProtection", om.valueToTree(this.getReplicationOverwriteProtection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.FileSystemProtectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileSystemProtectionProperty.Jsii$Proxy that = (FileSystemProtectionProperty.Jsii$Proxy) o;

                return this.replicationOverwriteProtection != null ? this.replicationOverwriteProtection.equals(that.replicationOverwriteProtection) : that.replicationOverwriteProtection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replicationOverwriteProtection != null ? this.replicationOverwriteProtection.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes a policy used by Lifecycle management that specifies when to transition files into and out of the EFS storage classes.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html">Managing file system storage</a> .
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>Each <code>LifecyclePolicy</code> object can have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> must be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToArchive</code> , <code>TransitionToPrimaryStorageClass</code> .</li>
     * <li>See the AWS::EFS::FileSystem examples for the correct <code>LifecyclePolicy</code> structure. Do not use the syntax shown on this page.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * LifecyclePolicyProperty lifecyclePolicyProperty = LifecyclePolicyProperty.builder()
     *         .transitionToArchive("transitionToArchive")
     *         .transitionToIa("transitionToIa")
     *         .transitionToPrimaryStorageClass("transitionToPrimaryStorageClass")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.LifecyclePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecyclePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecyclePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Archive storage.
         * <p>
         * Metadata operations such as listing the contents of a directory don't count as file access events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoarchive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoarchive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitionToArchive() {
            return null;
        }

        /**
         * The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Infrequent Access (IA) storage.
         * <p>
         * Metadata operations such as listing the contents of a directory don't count as file access events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoia">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoia</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitionToIa() {
            return null;
        }

        /**
         * Whether to move files back to primary (Standard) storage after they are accessed in IA or Archive storage.
         * <p>
         * Metadata operations such as listing the contents of a directory don't count as file access events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoprimarystorageclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoprimarystorageclass</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitionToPrimaryStorageClass() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LifecyclePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecyclePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecyclePolicyProperty> {
            java.lang.String transitionToArchive;
            java.lang.String transitionToIa;
            java.lang.String transitionToPrimaryStorageClass;

            /**
             * Sets the value of {@link LifecyclePolicyProperty#getTransitionToArchive}
             * @param transitionToArchive The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Archive storage.
             *                            Metadata operations such as listing the contents of a directory don't count as file access events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionToArchive(java.lang.String transitionToArchive) {
                this.transitionToArchive = transitionToArchive;
                return this;
            }

            /**
             * Sets the value of {@link LifecyclePolicyProperty#getTransitionToIa}
             * @param transitionToIa The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Infrequent Access (IA) storage.
             *                       Metadata operations such as listing the contents of a directory don't count as file access events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionToIa(java.lang.String transitionToIa) {
                this.transitionToIa = transitionToIa;
                return this;
            }

            /**
             * Sets the value of {@link LifecyclePolicyProperty#getTransitionToPrimaryStorageClass}
             * @param transitionToPrimaryStorageClass Whether to move files back to primary (Standard) storage after they are accessed in IA or Archive storage.
             *                                        Metadata operations such as listing the contents of a directory don't count as file access events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionToPrimaryStorageClass(java.lang.String transitionToPrimaryStorageClass) {
                this.transitionToPrimaryStorageClass = transitionToPrimaryStorageClass;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecyclePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecyclePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LifecyclePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecyclePolicyProperty {
            private final java.lang.String transitionToArchive;
            private final java.lang.String transitionToIa;
            private final java.lang.String transitionToPrimaryStorageClass;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transitionToArchive = software.amazon.jsii.Kernel.get(this, "transitionToArchive", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitionToIa = software.amazon.jsii.Kernel.get(this, "transitionToIa", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitionToPrimaryStorageClass = software.amazon.jsii.Kernel.get(this, "transitionToPrimaryStorageClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transitionToArchive = builder.transitionToArchive;
                this.transitionToIa = builder.transitionToIa;
                this.transitionToPrimaryStorageClass = builder.transitionToPrimaryStorageClass;
            }

            @Override
            public final java.lang.String getTransitionToArchive() {
                return this.transitionToArchive;
            }

            @Override
            public final java.lang.String getTransitionToIa() {
                return this.transitionToIa;
            }

            @Override
            public final java.lang.String getTransitionToPrimaryStorageClass() {
                return this.transitionToPrimaryStorageClass;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTransitionToArchive() != null) {
                    data.set("transitionToArchive", om.valueToTree(this.getTransitionToArchive()));
                }
                if (this.getTransitionToIa() != null) {
                    data.set("transitionToIa", om.valueToTree(this.getTransitionToIa()));
                }
                if (this.getTransitionToPrimaryStorageClass() != null) {
                    data.set("transitionToPrimaryStorageClass", om.valueToTree(this.getTransitionToPrimaryStorageClass()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.LifecyclePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecyclePolicyProperty.Jsii$Proxy that = (LifecyclePolicyProperty.Jsii$Proxy) o;

                if (this.transitionToArchive != null ? !this.transitionToArchive.equals(that.transitionToArchive) : that.transitionToArchive != null) return false;
                if (this.transitionToIa != null ? !this.transitionToIa.equals(that.transitionToIa) : that.transitionToIa != null) return false;
                return this.transitionToPrimaryStorageClass != null ? this.transitionToPrimaryStorageClass.equals(that.transitionToPrimaryStorageClass) : that.transitionToPrimaryStorageClass == null;
            }

            @Override
            public final int hashCode() {
                int result = this.transitionToArchive != null ? this.transitionToArchive.hashCode() : 0;
                result = 31 * result + (this.transitionToIa != null ? this.transitionToIa.hashCode() : 0);
                result = 31 * result + (this.transitionToPrimaryStorageClass != null ? this.transitionToPrimaryStorageClass.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the replication configuration for a specific file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * ReplicationConfigurationProperty replicationConfigurationProperty = ReplicationConfigurationProperty.builder()
     *         .destinations(List.of(ReplicationDestinationProperty.builder()
     *                 .availabilityZoneName("availabilityZoneName")
     *                 .fileSystemId("fileSystemId")
     *                 .kmsKeyId("kmsKeyId")
     *                 .region("region")
     *                 .roleArn("roleArn")
     *                 .status("status")
     *                 .statusMessage("statusMessage")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.ReplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of destination objects.
         * <p>
         * Only one destination object is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationconfiguration.html#cfn-efs-filesystem-replicationconfiguration-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationconfiguration.html#cfn-efs-filesystem-replicationconfiguration-destinations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationConfigurationProperty> {
            java.lang.Object destinations;

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getDestinations}
             * @param destinations An array of destination objects.
             *                     Only one destination object is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationConfigurationProperty#getDestinations}
             * @param destinations An array of destination objects.
             *                     Only one destination object is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationConfigurationProperty {
            private final java.lang.Object destinations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinations = builder.destinations;
            }

            @Override
            public final java.lang.Object getDestinations() {
                return this.destinations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinations() != null) {
                    data.set("destinations", om.valueToTree(this.getDestinations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.ReplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationConfigurationProperty.Jsii$Proxy that = (ReplicationConfigurationProperty.Jsii$Proxy) o;

                return this.destinations != null ? this.destinations.equals(that.destinations) : that.destinations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinations != null ? this.destinations.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the destination file system in the replication configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * ReplicationDestinationProperty replicationDestinationProperty = ReplicationDestinationProperty.builder()
     *         .availabilityZoneName("availabilityZoneName")
     *         .fileSystemId("fileSystemId")
     *         .kmsKeyId("kmsKeyId")
     *         .region("region")
     *         .roleArn("roleArn")
     *         .status("status")
     *         .statusMessage("statusMessage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.ReplicationDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For One Zone file systems, the replication configuration must specify the Availability Zone in which the destination file system is located.
         * <p>
         * Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone file systems, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">EFS file system types</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * One Zone file system type is not available in all Availability Zones in AWS Regions where Amazon EFS is available.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-availabilityzonename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-availabilityzonename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneName() {
            return null;
        }

        /**
         * The ID of the destination Amazon EFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemId() {
            return null;
        }

        /**
         * The ID of an AWS KMS key used to protect the encrypted file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The AWS Region in which the destination file system is located.
         * <p>
         * <blockquote>
         * <p>
         * For One Zone file systems, the replication configuration must specify the AWS Region in which the destination file system is located.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Describes the status of the replication configuration.
         * <p>
         * For more information about replication status, see <a href="https://docs.aws.amazon.com//efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html">Viewing replication details</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * Message that provides details about the <code>PAUSED</code> or <code>ERRROR</code> state of the replication destination configuration.
         * <p>
         * For more information about replication status messages, see <a href="https://docs.aws.amazon.com//efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html">Viewing replication details</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-statusmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-replicationdestination.html#cfn-efs-filesystem-replicationdestination-statusmessage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatusMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationDestinationProperty> {
            java.lang.String availabilityZoneName;
            java.lang.String fileSystemId;
            java.lang.String kmsKeyId;
            java.lang.String region;
            java.lang.String roleArn;
            java.lang.String status;
            java.lang.String statusMessage;

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getAvailabilityZoneName}
             * @param availabilityZoneName For One Zone file systems, the replication configuration must specify the Availability Zone in which the destination file system is located.
             *                             Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone file systems, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">EFS file system types</a> in the <em>Amazon EFS User Guide</em> .
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             One Zone file system type is not available in all Availability Zones in AWS Regions where Amazon EFS is available.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZoneName(java.lang.String availabilityZoneName) {
                this.availabilityZoneName = availabilityZoneName;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getFileSystemId}
             * @param fileSystemId The ID of the destination Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getKmsKeyId}
             * @param kmsKeyId The ID of an AWS KMS key used to protect the encrypted file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getRegion}
             * @param region The AWS Region in which the destination file system is located.
             *               <blockquote>
             *               <p>
             *               For One Zone file systems, the replication configuration must specify the AWS Region in which the destination file system is located.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getStatus}
             * @param status Describes the status of the replication configuration.
             *               For more information about replication status, see <a href="https://docs.aws.amazon.com//efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html">Viewing replication details</a> in the <em>Amazon EFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationDestinationProperty#getStatusMessage}
             * @param statusMessage Message that provides details about the <code>PAUSED</code> or <code>ERRROR</code> state of the replication destination configuration.
             *                      For more information about replication status messages, see <a href="https://docs.aws.amazon.com//efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html">Viewing replication details</a> in the <em>Amazon EFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusMessage(java.lang.String statusMessage) {
                this.statusMessage = statusMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationDestinationProperty {
            private final java.lang.String availabilityZoneName;
            private final java.lang.String fileSystemId;
            private final java.lang.String kmsKeyId;
            private final java.lang.String region;
            private final java.lang.String roleArn;
            private final java.lang.String status;
            private final java.lang.String statusMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZoneName = software.amazon.jsii.Kernel.get(this, "availabilityZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statusMessage = software.amazon.jsii.Kernel.get(this, "statusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZoneName = builder.availabilityZoneName;
                this.fileSystemId = builder.fileSystemId;
                this.kmsKeyId = builder.kmsKeyId;
                this.region = builder.region;
                this.roleArn = builder.roleArn;
                this.status = builder.status;
                this.statusMessage = builder.statusMessage;
            }

            @Override
            public final java.lang.String getAvailabilityZoneName() {
                return this.availabilityZoneName;
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getStatusMessage() {
                return this.statusMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZoneName() != null) {
                    data.set("availabilityZoneName", om.valueToTree(this.getAvailabilityZoneName()));
                }
                if (this.getFileSystemId() != null) {
                    data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getStatusMessage() != null) {
                    data.set("statusMessage", om.valueToTree(this.getStatusMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.ReplicationDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationDestinationProperty.Jsii$Proxy that = (ReplicationDestinationProperty.Jsii$Proxy) o;

                if (this.availabilityZoneName != null ? !this.availabilityZoneName.equals(that.availabilityZoneName) : that.availabilityZoneName != null) return false;
                if (this.fileSystemId != null ? !this.fileSystemId.equals(that.fileSystemId) : that.fileSystemId != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.statusMessage != null ? this.statusMessage.equals(that.statusMessage) : that.statusMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZoneName != null ? this.availabilityZoneName.hashCode() : 0;
                result = 31 * result + (this.fileSystemId != null ? this.fileSystemId.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.statusMessage != null ? this.statusMessage.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.efs.CfnFileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.efs.CfnFileSystem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.efs.CfnFileSystemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * For One Zone file systems, specify the AWS Availability Zone in which to create the file system.
         * <p>
         * Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone file systems, see <a href="https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html#file-system-type">EFS file system types</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * One Zone file systems are not available in all Availability Zones in AWS Regions where Amazon EFS is available.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-availabilityzonename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-availabilityzonename</a>
         * @param availabilityZoneName For One Zone file systems, specify the AWS Availability Zone in which to create the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneName(final java.lang.String availabilityZoneName) {
            this.props().availabilityZoneName(availabilityZoneName);
            return this;
        }

        /**
         * Use the <code>BackupPolicy</code> to turn automatic backups on or off for the file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy</a>
         * @param backupPolicy Use the <code>BackupPolicy</code> to turn automatic backups on or off for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(final software.amazon.awscdk.IResolvable backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }
        /**
         * Use the <code>BackupPolicy</code> to turn automatic backups on or off for the file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy</a>
         * @param backupPolicy Use the <code>BackupPolicy</code> to turn automatic backups on or off for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(final software.amazon.awscdk.services.efs.CfnFileSystem.BackupPolicyProperty backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }

        /**
         * (Optional) A boolean that specifies whether or not to bypass the <code>FileSystemPolicy</code> lockout safety check.
         * <p>
         * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-bypasspolicylockoutsafetycheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-bypasspolicylockoutsafetycheck</a>
         * @param bypassPolicyLockoutSafetyCheck (Optional) A boolean that specifies whether or not to bypass the <code>FileSystemPolicy</code> lockout safety check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(final java.lang.Boolean bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }
        /**
         * (Optional) A boolean that specifies whether or not to bypass the <code>FileSystemPolicy</code> lockout safety check.
         * <p>
         * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-bypasspolicylockoutsafetycheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-bypasspolicylockoutsafetycheck</a>
         * @param bypassPolicyLockoutSafetyCheck (Optional) A boolean that specifies whether or not to bypass the <code>FileSystemPolicy</code> lockout safety check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(final software.amazon.awscdk.IResolvable bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }

        /**
         * A Boolean value that, if true, creates an encrypted file system.
         * <p>
         * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted</a>
         * @param encrypted A Boolean value that, if true, creates an encrypted file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final java.lang.Boolean encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }
        /**
         * A Boolean value that, if true, creates an encrypted file system.
         * <p>
         * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted</a>
         * @param encrypted A Boolean value that, if true, creates an encrypted file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final software.amazon.awscdk.IResolvable encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }

        /**
         * The <code>FileSystemPolicy</code> for the EFS file system.
         * <p>
         * A file system policy is an IAM resource policy used to control NFS access to an EFS file system. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html">Using IAM to control NFS access to Amazon EFS</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy</a>
         * @param fileSystemPolicy The <code>FileSystemPolicy</code> for the EFS file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPolicy(final java.lang.Object fileSystemPolicy) {
            this.props().fileSystemPolicy(fileSystemPolicy);
            return this;
        }

        /**
         * Describes the protection on the file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemprotection</a>
         * @param fileSystemProtection Describes the protection on the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemProtection(final software.amazon.awscdk.IResolvable fileSystemProtection) {
            this.props().fileSystemProtection(fileSystemProtection);
            return this;
        }
        /**
         * Describes the protection on the file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemprotection</a>
         * @param fileSystemProtection Describes the protection on the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemProtection(final software.amazon.awscdk.services.efs.CfnFileSystem.FileSystemProtectionProperty fileSystemProtection) {
            this.props().fileSystemProtection(fileSystemProtection);
            return this;
        }

        /**
         * Use to create one or more tags associated with the file system.
         * <p>
         * Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags</a>
         * @param fileSystemTags Use to create one or more tags associated with the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemTags(final java.util.List<? extends software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags) {
            this.props().fileSystemTags(fileSystemTags);
            return this;
        }

        /**
         * The ID of the AWS KMS key to be used to protect the encrypted file system.
         * <p>
         * This parameter is only required if you want to use a nondefault KMS key . If this parameter is not specified, the default KMS key for Amazon EFS is used. This ID can be in one of the following formats:
         * <p>
         * <ul>
         * <li>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
         * <li>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
         * <li>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code> .</li>
         * <li>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code> .</li>
         * </ul>
         * <p>
         * If <code>KmsKeyId</code> is specified, the <code>Encrypted</code> parameter must be set to true.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid</a>
         * @param kmsKeyId The ID of the AWS KMS key to be used to protect the encrypted file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object.
         * <p>
         * A <code>LifecycleConfiguration</code> object informs Lifecycle management of the following:
         * <p>
         * <ul>
         * <li>When to move files in the file system from primary storage to IA storage.</li>
         * <li>When to move files in the file system from primary storage or IA storage to Archive storage.</li>
         * <li>When to move files that are in IA or Archive storage to primary storage.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToArchive</code> <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies</a>
         * @param lifecyclePolicies An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(final software.amazon.awscdk.IResolvable lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }
        /**
         * An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object.
         * <p>
         * A <code>LifecycleConfiguration</code> object informs Lifecycle management of the following:
         * <p>
         * <ul>
         * <li>When to move files in the file system from primary storage to IA storage.</li>
         * <li>When to move files in the file system from primary storage or IA storage to Archive storage.</li>
         * <li>When to move files that are in IA or Archive storage to primary storage.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToArchive</code> <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies</a>
         * @param lifecyclePolicies An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(final java.util.List<? extends java.lang.Object> lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }

        /**
         * The performance mode of the file system.
         * <p>
         * We recommend <code>generalPurpose</code> performance mode for all file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created. The <code>maxIO</code> mode is not supported on One Zone file systems.
         * <p>
         * <blockquote>
         * <p>
         * Due to the higher per-operation latencies with Max I/O, we recommend using General Purpose performance mode for all file systems.
         * <p>
         * </blockquote>
         * <p>
         * Default is <code>generalPurpose</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode</a>
         * @param performanceMode The performance mode of the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceMode(final java.lang.String performanceMode) {
            this.props().performanceMode(performanceMode);
            return this;
        }

        /**
         * The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating.
         * <p>
         * Required if <code>ThroughputMode</code> is set to <code>provisioned</code> . Valid values are 1-3414 MiBps, with the upper limit depending on Region. To increase this limit, contact Support . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps</a>
         * @param provisionedThroughputInMibps The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughputInMibps(final java.lang.Number provisionedThroughputInMibps) {
            this.props().provisionedThroughputInMibps(provisionedThroughputInMibps);
            return this;
        }

        /**
         * Describes the replication configuration for a specific file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-replicationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-replicationconfiguration</a>
         * @param replicationConfiguration Describes the replication configuration for a specific file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(final software.amazon.awscdk.IResolvable replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }
        /**
         * Describes the replication configuration for a specific file system.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-replicationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-replicationconfiguration</a>
         * @param replicationConfiguration Describes the replication configuration for a specific file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(final software.amazon.awscdk.services.efs.CfnFileSystem.ReplicationConfigurationProperty replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        /**
         * Specifies the throughput mode for the file system.
         * <p>
         * The mode can be <code>bursting</code> , <code>provisioned</code> , or <code>elastic</code> . If you set <code>ThroughputMode</code> to <code>provisioned</code> , you must also set a value for <code>ProvisionedThroughputInMibps</code> . After you create the file system, you can decrease your file system's Provisioned throughput or change between the throughput modes, with certain time restrictions. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * Default is <code>bursting</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode</a>
         * @param throughputMode Specifies the throughput mode for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputMode(final java.lang.String throughputMode) {
            this.props().throughputMode(throughputMode);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.efs.CfnFileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.efs.CfnFileSystem build() {
            return new software.amazon.awscdk.services.efs.CfnFileSystem(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.efs.CfnFileSystemProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.efs.CfnFileSystemProps.Builder();
            }
            return this.props;
        }
    }
}
