package software.amazon.awscdk.services.eks;

/**
 * The AMI type for your node group.
 * <p>
 * GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type, which uses the
 * Amazon EKS-optimized Linux AMI with GPU support or the <code>BOTTLEROCKET_ARM_64_NVIDIA</code> or <code>BOTTLEROCKET_X86_64_NVIDIA</code>
 * AMI types, which uses the Amazon EKS-optimized Linux AMI with Nvidia-GPU support.
 * <p>
 * Non-GPU instances should use the <code>AL2_x86_64</code> AMI type, which uses the Amazon EKS-optimized Linux AMI.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addNodegroupCapacity("BottlerocketNvidiaNG", NodegroupOptions.builder()
 *         .amiType(NodegroupAmiType.BOTTLEROCKET_X86_64_NVIDIA)
 *         .instanceTypes(List.of(new InstanceType("g4dn.xlarge")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.245Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.NodegroupAmiType")
public enum NodegroupAmiType {
    /**
     * Amazon Linux 2 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2_X86_64,
    /**
     * Amazon Linux 2 with GPU support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2_X86_64_GPU,
    /**
     * Amazon Linux 2 (ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2_ARM_64,
    /**
     * Bottlerocket Linux (ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET_ARM_64,
    /**
     * Bottlerocket (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET_X86_64,
    /**
     * Bottlerocket Linux with Nvidia-GPU support (ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET_ARM_64_NVIDIA,
    /**
     * Bottlerocket with Nvidia-GPU support (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET_X86_64_NVIDIA,
    /**
     * Windows Core 2019 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_CORE_2019_X86_64,
    /**
     * Windows Core 2022 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_CORE_2022_X86_64,
    /**
     * Windows Full 2019 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_FULL_2019_X86_64,
    /**
     * Windows Full 2022 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_FULL_2022_X86_64,
    /**
     * Amazon Linux 2023 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2023_X86_64_STANDARD,
    /**
     * Amazon Linux 2023 with AWS Neuron drivers (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2023_X86_64_NEURON,
    /**
     * Amazon Linux 2023 with NVIDIA drivers (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2023_X86_64_NVIDIA,
    /**
     * Amazon Linux 2023 (ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2023_ARM_64_STANDARD,
}
