package software.amazon.awscdk.services.eks;

/**
 * Effect types of kubernetes node taint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addNodegroupCapacity("custom-node-group", NodegroupOptions.builder()
 *         .instanceTypes(List.of(new InstanceType("m5.large")))
 *         .taints(List.of(TaintSpec.builder()
 *                 .effect(TaintEffect.NO_SCHEDULE)
 *                 .key("foo")
 *                 .value("bar")
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.251Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.TaintEffect")
public enum TaintEffect {
    /**
     * NoSchedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NO_SCHEDULE,
    /**
     * PreferNoSchedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PREFER_NO_SCHEDULE,
    /**
     * NoExecute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NO_EXECUTE,
}
