package software.amazon.awscdk.services.elasticache;

/**
 * Properties for defining a <code>CfnCacheCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnCacheClusterProps cfnCacheClusterProps = CfnCacheClusterProps.builder()
 *         .cacheNodeType("cacheNodeType")
 *         .engine("engine")
 *         .numCacheNodes(123)
 *         // the properties below are optional
 *         .autoMinorVersionUpgrade(false)
 *         .azMode("azMode")
 *         .cacheParameterGroupName("cacheParameterGroupName")
 *         .cacheSecurityGroupNames(List.of("cacheSecurityGroupNames"))
 *         .cacheSubnetGroupName("cacheSubnetGroupName")
 *         .clusterName("clusterName")
 *         .engineVersion("engineVersion")
 *         .ipDiscovery("ipDiscovery")
 *         .logDeliveryConfigurations(List.of(LogDeliveryConfigurationRequestProperty.builder()
 *                 .destinationDetails(DestinationDetailsProperty.builder()
 *                         .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .build())
 *                 .destinationType("destinationType")
 *                 .logFormat("logFormat")
 *                 .logType("logType")
 *                 .build()))
 *         .networkType("networkType")
 *         .notificationTopicArn("notificationTopicArn")
 *         .port(123)
 *         .preferredAvailabilityZone("preferredAvailabilityZone")
 *         .preferredAvailabilityZones(List.of("preferredAvailabilityZones"))
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .snapshotArns(List.of("snapshotArns"))
 *         .snapshotName("snapshotName")
 *         .snapshotRetentionLimit(123)
 *         .snapshotWindow("snapshotWindow")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitEncryptionEnabled(false)
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.258Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnCacheClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnCacheClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCacheClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts. Changing the CacheNodeType of a Memcached instance is currently not supported. If you need to scale using Memcached, we recommend forcing a replacement update by changing the <code>LogicalResourceId</code> of the resource.
     * <p>
     * <ul>
     * <li>General purpose:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.8xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.16xlarge</code> , <code>cache.m6g.24xlarge</code>
     * <p>
     * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
     * <p>
     * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
     * <p>
     * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
     * <p>
     * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
     * <p>
     * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>T1 node types:</em> <code>cache.t1.micro</code>
     * <p>
     * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
     * <p>
     * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
     * <p>
     * <ul>
     * <li>Compute optimized:</li>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
     * <p>
     * <ul>
     * <li>Memory optimized:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
     * <p>
     * </blockquote>
     * <p>
     * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.8xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.16xlarge</code> , <code>cache.r6g.24xlarge</code>
     * <p>
     * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
     * <p>
     * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
     * <p>
     * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
     * <p>
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Region</a>
     * <p>
     * <em>Additional node type info</em>
     * <p>
     * <ul>
     * <li>All current generation instance types are created in Amazon VPC by default.</li>
     * <li>Valkey and Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</li>
     * <li>Valkey and Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</li>
     * <li>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cachenodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cachenodetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCacheNodeType();

    /**
     * The name of the cache engine to be used for this cluster.
     * <p>
     * Valid values for this parameter are: <code>memcached</code> | valkey | <code>redis</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngine();

    /**
     * The number of cache nodes that the cache cluster should have.
     * <p>
     * <blockquote>
     * <p>
     * However, if the <code>PreferredAvailabilityZone</code> and <code>PreferredAvailabilityZones</code> properties were not previously specified and you don't specify any new values, an update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-numcachenodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-numcachenodes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getNumCacheNodes();

    /**
     * If you are running Valkey 7.2 or later, or Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-autominorversionupgrade</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.
     * <p>
     * This parameter is only supported for Memcached clusters.
     * <p>
     * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-azmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-azmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAzMode() {
        return null;
    }

    /**
     * The name of the parameter group to associate with this cluster.
     * <p>
     * If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cacheparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cacheparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheParameterGroupName() {
        return null;
    }

    /**
     * A list of security group names to associate with this cluster.
     * <p>
     * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cachesecuritygroupnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cachesecuritygroupnames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheSecurityGroupNames() {
        return null;
    }

    /**
     * The name of the subnet group to be used for the cluster.
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * <p>
     * <blockquote>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <code>[AWS::ElastiCache::SubnetGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html) .</code>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cachesubnetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-cachesubnetgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheSubnetGroupName() {
        return null;
    }

    /**
     * A name for the cache cluster.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the cache cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * The name must contain 1 to 50 alphanumeric characters or hyphens. The name must start with a letter and cannot end with a hyphen or contain two consecutive hyphens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * The version number of the cache engine to be used for this cluster.
     * <p>
     * To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
     * <p>
     * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code> .
     * <p>
     * IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 and Memcached engine version 1.6.6 and above on all instances built on the <a href="https://docs.aws.amazon.com/ec2/nitro/">Nitro system</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-ipdiscovery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-ipdiscovery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpDiscovery() {
        return null;
    }

    /**
     * Specifies the destination, format and type of the logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-logdeliveryconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-logdeliveryconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogDeliveryConfigurations() {
        return null;
    }

    /**
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code> .
     * <p>
     * IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 and Memcached engine version 1.6.6 and above on all instances built on the <a href="https://docs.aws.amazon.com/ec2/nitro/">Nitro system</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-networktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-networktype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkType() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-notificationtopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-notificationtopicarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotificationTopicArn() {
        return null;
    }

    /**
     * The port number on which each of the cache nodes accepts connections.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The EC2 Availability Zone in which the cluster is created.
     * <p>
     * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code> .
     * <p>
     * Default: System chosen Availability Zone.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-preferredavailabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-preferredavailabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredAvailabilityZone() {
        return null;
    }

    /**
     * A list of the Availability Zones in which cache nodes are created.
     * <p>
     * The order of the zones in the list is not important.
     * <p>
     * This option is only supported on Memcached.
     * <p>
     * <blockquote>
     * <p>
     * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code> .
     * <p>
     * </blockquote>
     * <p>
     * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.
     * <p>
     * Default: System chosen Availability Zones.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-preferredavailabilityzones">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-preferredavailabilityzones</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreferredAvailabilityZones() {
        return null;
    }

    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed.
     * <p>
     * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * <p>
     * Valid values for <code>ddd</code> are:
     * <p>
     * <ul>
     * <li><code>sun</code></li>
     * <li><code>mon</code></li>
     * <li><code>tue</code></li>
     * <li><code>wed</code></li>
     * <li><code>thu</code></li>
     * <li><code>fri</code></li>
     * <li><code>sat</code></li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Valkey or Redis OSS RDB snapshot file stored in Amazon S3.
     * <p>
     * The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnapshotArns() {
        return null;
    }

    /**
     * The name of a Valkey or Redis OSS snapshot from which to restore data into the new node group (shard).
     * <p>
     * The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
        return null;
    }

    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them.
     * <p>
     * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotretentionlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotretentionlimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotRetentionLimit() {
        return null;
    }

    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * <p>
     * Example: <code>05:00-09:00</code>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-snapshotwindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotWindow() {
        return null;
    }

    /**
     * A list of tags to be added to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A flag that enables in-transit encryption when set to true.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-transitencryptionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-transitencryptionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTransitEncryptionEnabled() {
        return null;
    }

    /**
     * One or more VPC security groups associated with the cluster.
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-vpcsecuritygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-cachecluster.html#cfn-elasticache-cachecluster-vpcsecuritygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCacheClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCacheClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCacheClusterProps> {
        java.lang.String cacheNodeType;
        java.lang.String engine;
        java.lang.Number numCacheNodes;
        java.lang.Object autoMinorVersionUpgrade;
        java.lang.String azMode;
        java.lang.String cacheParameterGroupName;
        java.util.List<java.lang.String> cacheSecurityGroupNames;
        java.lang.String cacheSubnetGroupName;
        java.lang.String clusterName;
        java.lang.String engineVersion;
        java.lang.String ipDiscovery;
        java.lang.Object logDeliveryConfigurations;
        java.lang.String networkType;
        java.lang.String notificationTopicArn;
        java.lang.Number port;
        java.lang.String preferredAvailabilityZone;
        java.util.List<java.lang.String> preferredAvailabilityZones;
        java.lang.String preferredMaintenanceWindow;
        java.util.List<java.lang.String> snapshotArns;
        java.lang.String snapshotName;
        java.lang.Number snapshotRetentionLimit;
        java.lang.String snapshotWindow;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object transitEncryptionEnabled;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnCacheClusterProps#getCacheNodeType}
         * @param cacheNodeType The compute and memory capacity of the nodes in the node group (shard). This parameter is required.
         *                      The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts. Changing the CacheNodeType of a Memcached instance is currently not supported. If you need to scale using Memcached, we recommend forcing a replacement update by changing the <code>LogicalResourceId</code> of the resource.
         *                      <p>
         *                      <ul>
         *                      <li>General purpose:</li>
         *                      <li>Current generation:</li>
         *                      </ul>
         *                      <p>
         *                      <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.8xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.16xlarge</code> , <code>cache.m6g.24xlarge</code>
         *                      <p>
         *                      <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
         *                      <p>
         *                      <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
         *                      <p>
         *                      <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
         *                      <p>
         *                      <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
         *                      <p>
         *                      <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
         *                      <p>
         *                      <ul>
         *                      <li>Previous generation: (not recommended)</li>
         *                      </ul>
         *                      <p>
         *                      <em>T1 node types:</em> <code>cache.t1.micro</code>
         *                      <p>
         *                      <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
         *                      <p>
         *                      <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
         *                      <p>
         *                      <ul>
         *                      <li>Compute optimized:</li>
         *                      <li>Previous generation: (not recommended)</li>
         *                      </ul>
         *                      <p>
         *                      <em>C1 node types:</em> <code>cache.c1.xlarge</code>
         *                      <p>
         *                      <ul>
         *                      <li>Memory optimized:</li>
         *                      <li>Current generation:</li>
         *                      </ul>
         *                      <p>
         *                      <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.8xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.16xlarge</code> , <code>cache.r6g.24xlarge</code>
         *                      <p>
         *                      <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
         *                      <p>
         *                      <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
         *                      <p>
         *                      <ul>
         *                      <li>Previous generation: (not recommended)</li>
         *                      </ul>
         *                      <p>
         *                      <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
         *                      <p>
         *                      <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
         *                      <p>
         *                      For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Region</a>
         *                      <p>
         *                      <em>Additional node type info</em>
         *                      <p>
         *                      <ul>
         *                      <li>All current generation instance types are created in Amazon VPC by default.</li>
         *                      <li>Valkey and Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</li>
         *                      <li>Valkey and Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</li>
         *                      <li>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNodeType(java.lang.String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getEngine}
         * @param engine The name of the cache engine to be used for this cluster. This parameter is required.
         *               Valid values for this parameter are: <code>memcached</code> | valkey | <code>redis</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getNumCacheNodes}
         * @param numCacheNodes The number of cache nodes that the cache cluster should have. This parameter is required.
         *                      <blockquote>
         *                      <p>
         *                      However, if the <code>PreferredAvailabilityZone</code> and <code>PreferredAvailabilityZones</code> properties were not previously specified and you don't specify any new values, an update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numCacheNodes(java.lang.Number numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade If you are running Valkey 7.2 or later, or Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade If you are running Valkey 7.2 or later, or Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getAzMode}
         * @param azMode Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.
         *               This parameter is only supported for Memcached clusters.
         *               <p>
         *               If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azMode(java.lang.String azMode) {
            this.azMode = azMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getCacheParameterGroupName}
         * @param cacheParameterGroupName The name of the parameter group to associate with this cluster.
         *                                If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheParameterGroupName(java.lang.String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getCacheSecurityGroupNames}
         * @param cacheSecurityGroupNames A list of security group names to associate with this cluster.
         *                                Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSecurityGroupNames(java.util.List<java.lang.String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = cacheSecurityGroupNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getCacheSubnetGroupName}
         * @param cacheSubnetGroupName The name of the subnet group to be used for the cluster.
         *                             Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <code>[AWS::ElastiCache::SubnetGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html) .</code>
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSubnetGroupName(java.lang.String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getClusterName}
         * @param clusterName A name for the cache cluster.
         *                    If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the cache cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                    <p>
         *                    The name must contain 1 to 50 alphanumeric characters or hyphens. The name must start with a letter and cannot end with a hyphen or contain two consecutive hyphens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getEngineVersion}
         * @param engineVersion The version number of the cache engine to be used for this cluster.
         *                      To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
         *                      <p>
         *                      <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getIpDiscovery}
         * @param ipDiscovery The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code> .
         *                    IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 and Memcached engine version 1.6.6 and above on all instances built on the <a href="https://docs.aws.amazon.com/ec2/nitro/">Nitro system</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipDiscovery(java.lang.String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getLogDeliveryConfigurations}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(software.amazon.awscdk.IResolvable logDeliveryConfigurations) {
            this.logDeliveryConfigurations = logDeliveryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getLogDeliveryConfigurations}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(java.util.List<? extends java.lang.Object> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = logDeliveryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getNetworkType}
         * @param networkType Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code> .
         *                    IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 and Memcached engine version 1.6.6 and above on all instances built on the <a href="https://docs.aws.amazon.com/ec2/nitro/">Nitro system</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(java.lang.String networkType) {
            this.networkType = networkType;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getNotificationTopicArn}
         * @param notificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
         *                             <blockquote>
         *                             <p>
         *                             The Amazon SNS topic owner must be the same as the cluster owner.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopicArn(java.lang.String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getPort}
         * @param port The port number on which each of the cache nodes accepts connections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getPreferredAvailabilityZone}
         * @param preferredAvailabilityZone The EC2 Availability Zone in which the cluster is created.
         *                                  All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code> .
         *                                  <p>
         *                                  Default: System chosen Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredAvailabilityZone(java.lang.String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getPreferredAvailabilityZones}
         * @param preferredAvailabilityZones A list of the Availability Zones in which cache nodes are created.
         *                                   The order of the zones in the list is not important.
         *                                   <p>
         *                                   This option is only supported on Memcached.
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.
         *                                   <p>
         *                                   The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code> .
         *                                   <p>
         *                                   </blockquote>
         *                                   <p>
         *                                   If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.
         *                                   <p>
         *                                   Default: System chosen Availability Zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredAvailabilityZones(java.util.List<java.lang.String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = preferredAvailabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster is performed.
         *                                   It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         *                                   <p>
         *                                   Valid values for <code>ddd</code> are:
         *                                   <p>
         *                                   <ul>
         *                                   <li><code>sun</code></li>
         *                                   <li><code>mon</code></li>
         *                                   <li><code>tue</code></li>
         *                                   <li><code>wed</code></li>
         *                                   <li><code>thu</code></li>
         *                                   <li><code>fri</code></li>
         *                                   <li><code>sat</code></li>
         *                                   </ul>
         *                                   <p>
         *                                   Example: <code>sun:23:00-mon:01:30</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getSnapshotArns}
         * @param snapshotArns A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Valkey or Redis OSS RDB snapshot file stored in Amazon S3.
         *                     The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         *                     <p>
         *                     </blockquote>
         *                     <p>
         *                     Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArns(java.util.List<java.lang.String> snapshotArns) {
            this.snapshotArns = snapshotArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getSnapshotName}
         * @param snapshotName The name of a Valkey or Redis OSS snapshot from which to restore data into the new node group (shard).
         *                     The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotName(java.lang.String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getSnapshotRetentionLimit}
         * @param snapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots before deleting them.
         *                               For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.
         *                               <p>
         *                               <blockquote>
         *                               <p>
         *                               This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         *                               <p>
         *                               </blockquote>
         *                               <p>
         *                               Default: 0 (i.e., automatic backups are disabled for this cache cluster).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotRetentionLimit(java.lang.Number snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getSnapshotWindow}
         * @param snapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
         *                       Example: <code>05:00-09:00</code>
         *                       <p>
         *                       If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotWindow(java.lang.String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getTags}
         * @param tags A list of tags to be added to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getTransitEncryptionEnabled}
         * @param transitEncryptionEnabled A flag that enables in-transit encryption when set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(java.lang.Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getTransitEncryptionEnabled}
         * @param transitEncryptionEnabled A flag that enables in-transit encryption when set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(software.amazon.awscdk.IResolvable transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCacheClusterProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds One or more VPC security groups associated with the cluster.
         *                            Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCacheClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCacheClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCacheClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCacheClusterProps {
        private final java.lang.String cacheNodeType;
        private final java.lang.String engine;
        private final java.lang.Number numCacheNodes;
        private final java.lang.Object autoMinorVersionUpgrade;
        private final java.lang.String azMode;
        private final java.lang.String cacheParameterGroupName;
        private final java.util.List<java.lang.String> cacheSecurityGroupNames;
        private final java.lang.String cacheSubnetGroupName;
        private final java.lang.String clusterName;
        private final java.lang.String engineVersion;
        private final java.lang.String ipDiscovery;
        private final java.lang.Object logDeliveryConfigurations;
        private final java.lang.String networkType;
        private final java.lang.String notificationTopicArn;
        private final java.lang.Number port;
        private final java.lang.String preferredAvailabilityZone;
        private final java.util.List<java.lang.String> preferredAvailabilityZones;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.util.List<java.lang.String> snapshotArns;
        private final java.lang.String snapshotName;
        private final java.lang.Number snapshotRetentionLimit;
        private final java.lang.String snapshotWindow;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object transitEncryptionEnabled;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cacheNodeType = software.amazon.jsii.Kernel.get(this, "cacheNodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numCacheNodes = software.amazon.jsii.Kernel.get(this, "numCacheNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.azMode = software.amazon.jsii.Kernel.get(this, "azMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheParameterGroupName = software.amazon.jsii.Kernel.get(this, "cacheParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheSecurityGroupNames = software.amazon.jsii.Kernel.get(this, "cacheSecurityGroupNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheSubnetGroupName = software.amazon.jsii.Kernel.get(this, "cacheSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipDiscovery = software.amazon.jsii.Kernel.get(this, "ipDiscovery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDeliveryConfigurations = software.amazon.jsii.Kernel.get(this, "logDeliveryConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkType = software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationTopicArn = software.amazon.jsii.Kernel.get(this, "notificationTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredAvailabilityZone = software.amazon.jsii.Kernel.get(this, "preferredAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredAvailabilityZones = software.amazon.jsii.Kernel.get(this, "preferredAvailabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotArns = software.amazon.jsii.Kernel.get(this, "snapshotArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.snapshotName = software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotRetentionLimit = software.amazon.jsii.Kernel.get(this, "snapshotRetentionLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.snapshotWindow = software.amazon.jsii.Kernel.get(this, "snapshotWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transitEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "transitEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cacheNodeType = java.util.Objects.requireNonNull(builder.cacheNodeType, "cacheNodeType is required");
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.numCacheNodes = java.util.Objects.requireNonNull(builder.numCacheNodes, "numCacheNodes is required");
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.azMode = builder.azMode;
            this.cacheParameterGroupName = builder.cacheParameterGroupName;
            this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
            this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
            this.clusterName = builder.clusterName;
            this.engineVersion = builder.engineVersion;
            this.ipDiscovery = builder.ipDiscovery;
            this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
            this.networkType = builder.networkType;
            this.notificationTopicArn = builder.notificationTopicArn;
            this.port = builder.port;
            this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
            this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.snapshotArns = builder.snapshotArns;
            this.snapshotName = builder.snapshotName;
            this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
            this.snapshotWindow = builder.snapshotWindow;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.Number getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final java.lang.Object getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getAzMode() {
            return this.azMode;
        }

        @Override
        public final java.lang.String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final java.util.List<java.lang.String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final java.lang.String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getIpDiscovery() {
            return this.ipDiscovery;
        }

        @Override
        public final java.lang.Object getLogDeliveryConfigurations() {
            return this.logDeliveryConfigurations;
        }

        @Override
        public final java.lang.String getNetworkType() {
            return this.networkType;
        }

        @Override
        public final java.lang.String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        @Override
        public final java.util.List<java.lang.String> getPreferredAvailabilityZones() {
            return this.preferredAvailabilityZones;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.util.List<java.lang.String> getSnapshotArns() {
            return this.snapshotArns;
        }

        @Override
        public final java.lang.String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final java.lang.Number getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final java.lang.String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cacheNodeType", om.valueToTree(this.getCacheNodeType()));
            data.set("engine", om.valueToTree(this.getEngine()));
            data.set("numCacheNodes", om.valueToTree(this.getNumCacheNodes()));
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAzMode() != null) {
                data.set("azMode", om.valueToTree(this.getAzMode()));
            }
            if (this.getCacheParameterGroupName() != null) {
                data.set("cacheParameterGroupName", om.valueToTree(this.getCacheParameterGroupName()));
            }
            if (this.getCacheSecurityGroupNames() != null) {
                data.set("cacheSecurityGroupNames", om.valueToTree(this.getCacheSecurityGroupNames()));
            }
            if (this.getCacheSubnetGroupName() != null) {
                data.set("cacheSubnetGroupName", om.valueToTree(this.getCacheSubnetGroupName()));
            }
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getIpDiscovery() != null) {
                data.set("ipDiscovery", om.valueToTree(this.getIpDiscovery()));
            }
            if (this.getLogDeliveryConfigurations() != null) {
                data.set("logDeliveryConfigurations", om.valueToTree(this.getLogDeliveryConfigurations()));
            }
            if (this.getNetworkType() != null) {
                data.set("networkType", om.valueToTree(this.getNetworkType()));
            }
            if (this.getNotificationTopicArn() != null) {
                data.set("notificationTopicArn", om.valueToTree(this.getNotificationTopicArn()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredAvailabilityZone() != null) {
                data.set("preferredAvailabilityZone", om.valueToTree(this.getPreferredAvailabilityZone()));
            }
            if (this.getPreferredAvailabilityZones() != null) {
                data.set("preferredAvailabilityZones", om.valueToTree(this.getPreferredAvailabilityZones()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getSnapshotArns() != null) {
                data.set("snapshotArns", om.valueToTree(this.getSnapshotArns()));
            }
            if (this.getSnapshotName() != null) {
                data.set("snapshotName", om.valueToTree(this.getSnapshotName()));
            }
            if (this.getSnapshotRetentionLimit() != null) {
                data.set("snapshotRetentionLimit", om.valueToTree(this.getSnapshotRetentionLimit()));
            }
            if (this.getSnapshotWindow() != null) {
                data.set("snapshotWindow", om.valueToTree(this.getSnapshotWindow()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitEncryptionEnabled() != null) {
                data.set("transitEncryptionEnabled", om.valueToTree(this.getTransitEncryptionEnabled()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnCacheClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCacheClusterProps.Jsii$Proxy that = (CfnCacheClusterProps.Jsii$Proxy) o;

            if (!cacheNodeType.equals(that.cacheNodeType)) return false;
            if (!engine.equals(that.engine)) return false;
            if (!numCacheNodes.equals(that.numCacheNodes)) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.azMode != null ? !this.azMode.equals(that.azMode) : that.azMode != null) return false;
            if (this.cacheParameterGroupName != null ? !this.cacheParameterGroupName.equals(that.cacheParameterGroupName) : that.cacheParameterGroupName != null) return false;
            if (this.cacheSecurityGroupNames != null ? !this.cacheSecurityGroupNames.equals(that.cacheSecurityGroupNames) : that.cacheSecurityGroupNames != null) return false;
            if (this.cacheSubnetGroupName != null ? !this.cacheSubnetGroupName.equals(that.cacheSubnetGroupName) : that.cacheSubnetGroupName != null) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.ipDiscovery != null ? !this.ipDiscovery.equals(that.ipDiscovery) : that.ipDiscovery != null) return false;
            if (this.logDeliveryConfigurations != null ? !this.logDeliveryConfigurations.equals(that.logDeliveryConfigurations) : that.logDeliveryConfigurations != null) return false;
            if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) return false;
            if (this.notificationTopicArn != null ? !this.notificationTopicArn.equals(that.notificationTopicArn) : that.notificationTopicArn != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredAvailabilityZone != null ? !this.preferredAvailabilityZone.equals(that.preferredAvailabilityZone) : that.preferredAvailabilityZone != null) return false;
            if (this.preferredAvailabilityZones != null ? !this.preferredAvailabilityZones.equals(that.preferredAvailabilityZones) : that.preferredAvailabilityZones != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.snapshotArns != null ? !this.snapshotArns.equals(that.snapshotArns) : that.snapshotArns != null) return false;
            if (this.snapshotName != null ? !this.snapshotName.equals(that.snapshotName) : that.snapshotName != null) return false;
            if (this.snapshotRetentionLimit != null ? !this.snapshotRetentionLimit.equals(that.snapshotRetentionLimit) : that.snapshotRetentionLimit != null) return false;
            if (this.snapshotWindow != null ? !this.snapshotWindow.equals(that.snapshotWindow) : that.snapshotWindow != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transitEncryptionEnabled != null ? !this.transitEncryptionEnabled.equals(that.transitEncryptionEnabled) : that.transitEncryptionEnabled != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cacheNodeType.hashCode();
            result = 31 * result + (this.engine.hashCode());
            result = 31 * result + (this.numCacheNodes.hashCode());
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.azMode != null ? this.azMode.hashCode() : 0);
            result = 31 * result + (this.cacheParameterGroupName != null ? this.cacheParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.cacheSecurityGroupNames != null ? this.cacheSecurityGroupNames.hashCode() : 0);
            result = 31 * result + (this.cacheSubnetGroupName != null ? this.cacheSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.ipDiscovery != null ? this.ipDiscovery.hashCode() : 0);
            result = 31 * result + (this.logDeliveryConfigurations != null ? this.logDeliveryConfigurations.hashCode() : 0);
            result = 31 * result + (this.networkType != null ? this.networkType.hashCode() : 0);
            result = 31 * result + (this.notificationTopicArn != null ? this.notificationTopicArn.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredAvailabilityZone != null ? this.preferredAvailabilityZone.hashCode() : 0);
            result = 31 * result + (this.preferredAvailabilityZones != null ? this.preferredAvailabilityZones.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.snapshotArns != null ? this.snapshotArns.hashCode() : 0);
            result = 31 * result + (this.snapshotName != null ? this.snapshotName.hashCode() : 0);
            result = 31 * result + (this.snapshotRetentionLimit != null ? this.snapshotRetentionLimit.hashCode() : 0);
            result = 31 * result + (this.snapshotWindow != null ? this.snapshotWindow.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitEncryptionEnabled != null ? this.transitEncryptionEnabled.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
