package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an Application Load Balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
 * AutoScalingGroup asg;
 * Vpc vpc;
 * // Create the load balancer in a VPC. 'internetFacing' is 'false'
 * // by default, which creates an internal load balancer.
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * // Add a listener and open up the load balancer's security group
 * // to the world.
 * ApplicationListener listener = lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(80)
 *         // 'open: true' is the default, you can leave it out if you want. Set it
 *         // to 'false' and use `listener.connections` if you want to be selective
 *         // about who can access the load balancer.
 *         .open(true)
 *         .build());
 * // Create an AutoScaling group and add it as a load balancing
 * // target to the listener.
 * listener.addTargets("ApplicationFleet", AddApplicationTargetsProps.builder()
 *         .port(8080)
 *         .targets(List.of(asg))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.381Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer")
public class ApplicationLoadBalancer extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer {

    protected ApplicationLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationLoadBalancer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing Application Load Balancer.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer fromApplicationLoadBalancerAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer.class, "fromApplicationLoadBalancerAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Look up an application load balancer.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a new listener to this load balancer.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener addListener(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps props) {
        return software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a redirection listener to this load balancer.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener addRedirect(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerRedirectConfig props) {
        return software.amazon.jsii.Kernel.call(this, "addRedirect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class), new Object[] { props });
    }

    /**
     * Add a redirection listener to this load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener addRedirect() {
        return software.amazon.jsii.Kernel.call(this, "addRedirect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class));
    }

    /**
     * Add a security group to this load balancer.
     * <p>
     * @param securityGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Enable access logging for this load balancer.
     * <p>
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks. See https://docs.aws.amazon.com/cdk/latest/guide/environments.html
     * <p>
     * @param bucket This parameter is required.
     * @param prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void logAccessLogs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        software.amazon.jsii.Kernel.call(this, "logAccessLogs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), prefix });
    }

    /**
     * Enable access logging for this load balancer.
     * <p>
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks. See https://docs.aws.amazon.com/cdk/latest/guide/environments.html
     * <p>
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void logAccessLogs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        software.amazon.jsii.Kernel.call(this, "logAccessLogs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Enable connection logging for this load balancer.
     * <p>
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cdk/latest/guide/environments.html">https://docs.aws.amazon.com/cdk/latest/guide/environments.html</a>
     * @param bucket This parameter is required.
     * @param prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logConnectionLogs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        software.amazon.jsii.Kernel.call(this, "logConnectionLogs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), prefix });
    }

    /**
     * Enable connection logging for this load balancer.
     * <p>
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cdk/latest/guide/environments.html">https://docs.aws.amazon.com/cdk/latest/guide/environments.html</a>
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logConnectionLogs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        software.amazon.jsii.Kernel.call(this, "logConnectionLogs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * (deprecated) Return the given named metric for this Application Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.custom</code> instead
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * (deprecated) Return the given named metric for this Application Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.custom</code> instead
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (deprecated) The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.activeConnectionCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricActiveConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.activeConnectionCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveConnectionCount() {
        return software.amazon.jsii.Kernel.call(this, "metricActiveConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * <p>
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.clientTlsNegotiationErrorCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientTlsNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClientTlsNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * <p>
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.clientTlsNegotiationErrorCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientTlsNegotiationErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricClientTlsNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.consumedLCUs</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.consumedLCUs</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs() {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of user authentications that could not be completed.
     * <p>
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthError</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of user authentications that could not be completed.
     * <p>
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthError</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthError() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthFailure</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthFailure</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthFailure() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * <p>
     * If one or more of these operations fail, this is the time to failure.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthLatency</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * <p>
     * If one or more of these operations fail, this is the time to failure.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthLatency</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of authenticate actions that were successful.
     * <p>
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthSuccess</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of authenticate actions that were successful.
     * <p>
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.elbAuthSuccess</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthSuccess() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * <p>
     * This does not include any response codes generated by the targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpCodeElb</code> instead
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeElb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * (deprecated) The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * <p>
     * This does not include any response codes generated by the targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpCodeElb</code> instead
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeElb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * (deprecated) The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpCodeTarget</code> instead
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * (deprecated) The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpCodeTarget</code> instead
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * (deprecated) The number of fixed-response actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpFixedResponseCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpFixedResponseCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpFixedResponseCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of fixed-response actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpFixedResponseCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpFixedResponseCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHttpFixedResponseCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of redirect actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpRedirectCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of redirect actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpRedirectCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpRedirectUrlLimitExceededCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectUrlLimitExceededCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectUrlLimitExceededCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.httpRedirectUrlLimitExceededCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectUrlLimitExceededCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectUrlLimitExceededCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of bytes processed by the load balancer over IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.ipv6ProcessedBytes</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6ProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6ProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of bytes processed by the load balancer over IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.ipv6ProcessedBytes</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6ProcessedBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6ProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of IPv6 requests received by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.ipv6RequestCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of IPv6 requests received by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.ipv6RequestCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount() {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.newConnectionCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNewConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.newConnectionCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewConnectionCount() {
        return software.amazon.jsii.Kernel.call(this, "metricNewConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.processedBytes</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.processedBytes</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.rejectedConnectionCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRejectedConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRejectedConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.rejectedConnectionCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRejectedConnectionCount() {
        return software.amazon.jsii.Kernel.call(this, "metricRejectedConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.requestCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.requestCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount() {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of rules processed by the load balancer given a request rate averaged over an hour.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.ruleEvaluations</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRuleEvaluations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRuleEvaluations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of rules processed by the load balancer given a request rate averaged over an hour.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.ruleEvaluations</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRuleEvaluations() {
        return software.amazon.jsii.Kernel.call(this, "metricRuleEvaluations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.targetConnectionErrorCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.targetConnectionErrorCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.targetResponseTime</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.targetResponseTime</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.targetTLSNegotiationErrorCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationLoadBalancer.metrics.targetTLSNegotiationErrorCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * A list of listeners that have been added to the load balancer.
     * <p>
     * This list is only valid for owned constructs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener> getListeners() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class))));
    }

    /**
     * All metrics available for this load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerMetrics getMetrics() {
        return software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerMetrics.class));
    }

    /**
     * The IP Address Type for this load balancer.
     * <p>
     * If the <code>&#64;aws-cdk/aws-elasticloadbalancingV2:albDualstackWithoutPublicIpv4SecurityGroupRulesDefault</code>
     * feature flag is set (the default for new projects), and <code>addListener()</code> is called with <code>open: true</code>,
     * the load balancer's security group will automatically include both IPv4 and IPv6 ingress rules
     * when using <code>IpAddressType.DUAL_STACK_WITHOUT_PUBLIC_IPV4</code>.
     * <p>
     * For existing projects that only have IPv4 rules, you can opt-in to IPv6 ingress rules
     * by enabling the feature flag in your cdk.json file. Note that enabling this feature flag
     * will modify existing security group rules.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps.Builder();
        }

        /**
         * The VPC network to place the load balancer in.
         * <p>
         * @return {@code this}
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Indicates whether cross-zone load balancing is enabled.
         * <p>
         * Default: - false for Network Load Balancers and true for Application Load Balancers.
         * This can not be `false` for Application Load Balancers.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattribute.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattribute.html</a>
         * @param crossZoneEnabled Indicates whether cross-zone load balancing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZoneEnabled(final java.lang.Boolean crossZoneEnabled) {
            this.props.crossZoneEnabled(crossZoneEnabled);
            return this;
        }

        /**
         * Indicates whether deletion protection is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether deletion protection is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Indicates whether the load balancer blocks traffic through the Internet Gateway (IGW).
         * <p>
         * Default: - false for internet-facing load balancers and true for internal load balancers
         * <p>
         * @return {@code this}
         * @param denyAllIgwTraffic Indicates whether the load balancer blocks traffic through the Internet Gateway (IGW). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder denyAllIgwTraffic(final java.lang.Boolean denyAllIgwTraffic) {
            this.props.denyAllIgwTraffic(denyAllIgwTraffic);
            return this;
        }

        /**
         * Whether the load balancer has an internet-routable address.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param internetFacing Whether the load balancer has an internet-routable address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(final java.lang.Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        /**
         * Name of the load balancer.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param loadBalancerName Name of the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * Which subnets place the load balancer in.
         * <p>
         * Default: - the Vpc default strategy.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The client keep alive duration.
         * <p>
         * The valid range is 60 to 604800 seconds (1 minute to 7 days).
         * <p>
         * Default: - Duration.seconds(3600)
         * <p>
         * @return {@code this}
         * @param clientKeepAlive The client keep alive duration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientKeepAlive(final software.amazon.awscdk.Duration clientKeepAlive) {
            this.props.clientKeepAlive(clientKeepAlive);
            return this;
        }

        /**
         * Determines how the load balancer handles requests that might pose a security risk to your application.
         * <p>
         * Default: DesyncMitigationMode.DEFENSIVE
         * <p>
         * @return {@code this}
         * @param desyncMitigationMode Determines how the load balancer handles requests that might pose a security risk to your application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desyncMitigationMode(final software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode desyncMitigationMode) {
            this.props.desyncMitigationMode(desyncMitigationMode);
            return this;
        }

        /**
         * Indicates whether HTTP headers with invalid header fields are removed by the load balancer (true) or routed to targets (false).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param dropInvalidHeaderFields Indicates whether HTTP headers with invalid header fields are removed by the load balancer (true) or routed to targets (false). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dropInvalidHeaderFields(final java.lang.Boolean dropInvalidHeaderFields) {
            this.props.dropInvalidHeaderFields(dropInvalidHeaderFields);
            return this;
        }

        /**
         * Indicates whether HTTP/2 is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param http2Enabled Indicates whether HTTP/2 is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder http2Enabled(final java.lang.Boolean http2Enabled) {
            this.props.http2Enabled(http2Enabled);
            return this;
        }

        /**
         * The load balancer idle timeout, in seconds.
         * <p>
         * Default: 60
         * <p>
         * @return {@code this}
         * @param idleTimeout The load balancer idle timeout, in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(final software.amazon.awscdk.Duration idleTimeout) {
            this.props.idleTimeout(idleTimeout);
            return this;
        }

        /**
         * The type of IP addresses to use.
         * <p>
         * Default: IpAddressType.IPV4
         * <p>
         * @return {@code this}
         * @param ipAddressType The type of IP addresses to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        /**
         * Indicates whether the Application Load Balancer should preserve the host header in the HTTP request and send it to the target without any change.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param preserveHostHeader Indicates whether the Application Load Balancer should preserve the host header in the HTTP request and send it to the target without any change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveHostHeader(final java.lang.Boolean preserveHostHeader) {
            this.props.preserveHostHeader(preserveHostHeader);
            return this;
        }

        /**
         * Indicates whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param preserveXffClientPort Indicates whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveXffClientPort(final java.lang.Boolean preserveXffClientPort) {
            this.props.preserveXffClientPort(preserveXffClientPort);
            return this;
        }

        /**
         * Security group to associate with this load balancer.
         * <p>
         * Default: A security group is created
         * <p>
         * @return {@code this}
         * @param securityGroup Security group to associate with this load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param wafFailOpen Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wafFailOpen(final java.lang.Boolean wafFailOpen) {
            this.props.wafFailOpen(wafFailOpen);
            return this;
        }

        /**
         * Indicates whether the two headers (x-amzn-tls-version and x-amzn-tls-cipher-suite), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target.
         * <p>
         * The x-amzn-tls-version header has information about the TLS protocol version negotiated with the client,
         * and the x-amzn-tls-cipher-suite header has information about the cipher suite negotiated with the client.
         * <p>
         * Both headers are in OpenSSL format.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param xAmznTlsVersionAndCipherSuiteHeaders Indicates whether the two headers (x-amzn-tls-version and x-amzn-tls-cipher-suite), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xAmznTlsVersionAndCipherSuiteHeaders(final java.lang.Boolean xAmznTlsVersionAndCipherSuiteHeaders) {
            this.props.xAmznTlsVersionAndCipherSuiteHeaders(xAmznTlsVersionAndCipherSuiteHeaders);
            return this;
        }

        /**
         * Enables you to modify, preserve, or remove the X-Forwarded-For header in the HTTP request before the Application Load Balancer sends the request to the target.
         * <p>
         * Default: XffHeaderProcessingMode.APPEND
         * <p>
         * @return {@code this}
         * @param xffHeaderProcessingMode Enables you to modify, preserve, or remove the X-Forwarded-For header in the HTTP request before the Application Load Balancer sends the request to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xffHeaderProcessingMode(final software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode xffHeaderProcessingMode) {
            this.props.xffHeaderProcessingMode(xffHeaderProcessingMode);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
