package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a <code>CfnTrustStore</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnTrustStoreProps cfnTrustStoreProps = CfnTrustStoreProps.builder()
 *         .caCertificatesBundleS3Bucket("caCertificatesBundleS3Bucket")
 *         .caCertificatesBundleS3Key("caCertificatesBundleS3Key")
 *         .caCertificatesBundleS3ObjectVersion("caCertificatesBundleS3ObjectVersion")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.458Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnTrustStoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrustStoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrustStoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon S3 bucket for the ca certificates bundle.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-cacertificatesbundles3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-cacertificatesbundles3bucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaCertificatesBundleS3Bucket() {
        return null;
    }

    /**
     * The Amazon S3 path for the ca certificates bundle.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-cacertificatesbundles3key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-cacertificatesbundles3key</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaCertificatesBundleS3Key() {
        return null;
    }

    /**
     * The Amazon S3 object version for the ca certificates bundle.
     * <p>
     * If undefined the current version is used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-cacertificatesbundles3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-cacertificatesbundles3objectversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaCertificatesBundleS3ObjectVersion() {
        return null;
    }

    /**
     * The name of the trust store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags to assign to the trust store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-truststore.html#cfn-elasticloadbalancingv2-truststore-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrustStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrustStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrustStoreProps> {
        java.lang.String caCertificatesBundleS3Bucket;
        java.lang.String caCertificatesBundleS3Key;
        java.lang.String caCertificatesBundleS3ObjectVersion;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTrustStoreProps#getCaCertificatesBundleS3Bucket}
         * @param caCertificatesBundleS3Bucket The Amazon S3 bucket for the ca certificates bundle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificatesBundleS3Bucket(java.lang.String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrustStoreProps#getCaCertificatesBundleS3Key}
         * @param caCertificatesBundleS3Key The Amazon S3 path for the ca certificates bundle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificatesBundleS3Key(java.lang.String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrustStoreProps#getCaCertificatesBundleS3ObjectVersion}
         * @param caCertificatesBundleS3ObjectVersion The Amazon S3 object version for the ca certificates bundle.
         *                                            If undefined the current version is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificatesBundleS3ObjectVersion(java.lang.String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrustStoreProps#getName}
         * @param name The name of the trust store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrustStoreProps#getTags}
         * @param tags The tags to assign to the trust store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrustStoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrustStoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrustStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrustStoreProps {
        private final java.lang.String caCertificatesBundleS3Bucket;
        private final java.lang.String caCertificatesBundleS3Key;
        private final java.lang.String caCertificatesBundleS3ObjectVersion;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.caCertificatesBundleS3Bucket = software.amazon.jsii.Kernel.get(this, "caCertificatesBundleS3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caCertificatesBundleS3Key = software.amazon.jsii.Kernel.get(this, "caCertificatesBundleS3Key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caCertificatesBundleS3ObjectVersion = software.amazon.jsii.Kernel.get(this, "caCertificatesBundleS3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.caCertificatesBundleS3Bucket = builder.caCertificatesBundleS3Bucket;
            this.caCertificatesBundleS3Key = builder.caCertificatesBundleS3Key;
            this.caCertificatesBundleS3ObjectVersion = builder.caCertificatesBundleS3ObjectVersion;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCaCertificatesBundleS3Bucket() {
            return this.caCertificatesBundleS3Bucket;
        }

        @Override
        public final java.lang.String getCaCertificatesBundleS3Key() {
            return this.caCertificatesBundleS3Key;
        }

        @Override
        public final java.lang.String getCaCertificatesBundleS3ObjectVersion() {
            return this.caCertificatesBundleS3ObjectVersion;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCaCertificatesBundleS3Bucket() != null) {
                data.set("caCertificatesBundleS3Bucket", om.valueToTree(this.getCaCertificatesBundleS3Bucket()));
            }
            if (this.getCaCertificatesBundleS3Key() != null) {
                data.set("caCertificatesBundleS3Key", om.valueToTree(this.getCaCertificatesBundleS3Key()));
            }
            if (this.getCaCertificatesBundleS3ObjectVersion() != null) {
                data.set("caCertificatesBundleS3ObjectVersion", om.valueToTree(this.getCaCertificatesBundleS3ObjectVersion()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnTrustStoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrustStoreProps.Jsii$Proxy that = (CfnTrustStoreProps.Jsii$Proxy) o;

            if (this.caCertificatesBundleS3Bucket != null ? !this.caCertificatesBundleS3Bucket.equals(that.caCertificatesBundleS3Bucket) : that.caCertificatesBundleS3Bucket != null) return false;
            if (this.caCertificatesBundleS3Key != null ? !this.caCertificatesBundleS3Key.equals(that.caCertificatesBundleS3Key) : that.caCertificatesBundleS3Key != null) return false;
            if (this.caCertificatesBundleS3ObjectVersion != null ? !this.caCertificatesBundleS3ObjectVersion.equals(that.caCertificatesBundleS3ObjectVersion) : that.caCertificatesBundleS3ObjectVersion != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.caCertificatesBundleS3Bucket != null ? this.caCertificatesBundleS3Bucket.hashCode() : 0;
            result = 31 * result + (this.caCertificatesBundleS3Key != null ? this.caCertificatesBundleS3Key.hashCode() : 0);
            result = 31 * result + (this.caCertificatesBundleS3ObjectVersion != null ? this.caCertificatesBundleS3ObjectVersion.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
