package software.amazon.awscdk.services.entityresolution;

/**
 * Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be run.
 * <p>
 * It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.entityresolution.*;
 * CfnMatchingWorkflow cfnMatchingWorkflow = CfnMatchingWorkflow.Builder.create(this, "MyCfnMatchingWorkflow")
 *         .inputSourceConfig(List.of(InputSourceProperty.builder()
 *                 .inputSourceArn("inputSourceArn")
 *                 .schemaArn("schemaArn")
 *                 // the properties below are optional
 *                 .applyNormalization(false)
 *                 .build()))
 *         .outputSourceConfig(List.of(OutputSourceProperty.builder()
 *                 .output(List.of(OutputAttributeProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .hashed(false)
 *                         .build()))
 *                 .outputS3Path("outputS3Path")
 *                 // the properties below are optional
 *                 .applyNormalization(false)
 *                 .kmsArn("kmsArn")
 *                 .build()))
 *         .resolutionTechniques(ResolutionTechniquesProperty.builder()
 *                 .providerProperties(ProviderPropertiesProperty.builder()
 *                         .providerServiceArn("providerServiceArn")
 *                         // the properties below are optional
 *                         .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
 *                                 .intermediateS3Path("intermediateS3Path")
 *                                 .build())
 *                         .providerConfiguration(Map.of(
 *                                 "providerConfigurationKey", "providerConfiguration"))
 *                         .build())
 *                 .resolutionType("resolutionType")
 *                 .ruleBasedProperties(RuleBasedPropertiesProperty.builder()
 *                         .attributeMatchingModel("attributeMatchingModel")
 *                         .rules(List.of(RuleProperty.builder()
 *                                 .matchingKeys(List.of("matchingKeys"))
 *                                 .ruleName("ruleName")
 *                                 .build()))
 *                         // the properties below are optional
 *                         .matchPurpose("matchPurpose")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         .workflowName("workflowName")
 *         // the properties below are optional
 *         .description("description")
 *         .incrementalRunConfig(IncrementalRunConfigProperty.builder()
 *                 .incrementalRunType("incrementalRunType")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.690Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow")
public class CfnMatchingWorkflow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnMatchingWorkflow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMatchingWorkflow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMatchingWorkflow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time of this MatchingWorkflow got created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time of this MatchingWorkflow got last updated at.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default MatchingWorkflow arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkflowArn() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkflowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputSourceConfig() {
        return software.amazon.jsii.Kernel.get(this, "inputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSourceConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputSourceConfig", java.util.Objects.requireNonNull(value, "inputSourceConfig is required"));
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSourceConfig(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.InputSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.InputSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inputSourceConfig", java.util.Objects.requireNonNull(value, "inputSourceConfig is required"));
    }

    /**
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutputSourceConfig() {
        return software.amazon.jsii.Kernel.get(this, "outputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputSourceConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputSourceConfig", java.util.Objects.requireNonNull(value, "outputSourceConfig is required"));
    }

    /**
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputSourceConfig(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.OutputSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.OutputSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "outputSourceConfig", java.util.Objects.requireNonNull(value, "outputSourceConfig is required"));
    }

    /**
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResolutionTechniques() {
        return software.amazon.jsii.Kernel.get(this, "resolutionTechniques", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResolutionTechniques(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resolutionTechniques", java.util.Objects.requireNonNull(value, "resolutionTechniques is required"));
    }

    /**
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResolutionTechniques(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.ResolutionTechniquesProperty value) {
        software.amazon.jsii.Kernel.set(this, "resolutionTechniques", java.util.Objects.requireNonNull(value, "resolutionTechniques is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The name of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWorkflowName() {
        return software.amazon.jsii.Kernel.get(this, "workflowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workflowName", java.util.Objects.requireNonNull(value, "workflowName is required"));
    }

    /**
     * A description of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIncrementalRunConfig() {
        return software.amazon.jsii.Kernel.get(this, "incrementalRunConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncrementalRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "incrementalRunConfig", value);
    }

    /**
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncrementalRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.IncrementalRunConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "incrementalRunConfig", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IncrementalRunConfigProperty incrementalRunConfigProperty = IncrementalRunConfigProperty.builder()
     *         .incrementalRunType("incrementalRunType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-incrementalrunconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-incrementalrunconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.IncrementalRunConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IncrementalRunConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncrementalRunConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of incremental run.
         * <p>
         * It takes only one value: <code>IMMEDIATE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-incrementalrunconfig.html#cfn-entityresolution-matchingworkflow-incrementalrunconfig-incrementalruntype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-incrementalrunconfig.html#cfn-entityresolution-matchingworkflow-incrementalrunconfig-incrementalruntype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIncrementalRunType();

        /**
         * @return a {@link Builder} of {@link IncrementalRunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncrementalRunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncrementalRunConfigProperty> {
            java.lang.String incrementalRunType;

            /**
             * Sets the value of {@link IncrementalRunConfigProperty#getIncrementalRunType}
             * @param incrementalRunType The type of incremental run. This parameter is required.
             *                           It takes only one value: <code>IMMEDIATE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalRunType(java.lang.String incrementalRunType) {
                this.incrementalRunType = incrementalRunType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncrementalRunConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncrementalRunConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncrementalRunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncrementalRunConfigProperty {
            private final java.lang.String incrementalRunType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.incrementalRunType = software.amazon.jsii.Kernel.get(this, "incrementalRunType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.incrementalRunType = java.util.Objects.requireNonNull(builder.incrementalRunType, "incrementalRunType is required");
            }

            @Override
            public final java.lang.String getIncrementalRunType() {
                return this.incrementalRunType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("incrementalRunType", om.valueToTree(this.getIncrementalRunType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.IncrementalRunConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncrementalRunConfigProperty.Jsii$Proxy that = (IncrementalRunConfigProperty.Jsii$Proxy) o;

                return this.incrementalRunType.equals(that.incrementalRunType);
            }

            @Override
            public final int hashCode() {
                int result = this.incrementalRunType.hashCode();
                return result;
            }
        }
    }
    /**
     * An object containing <code>InputSourceARN</code> , <code>SchemaName</code> , and <code>ApplyNormalization</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * InputSourceProperty inputSourceProperty = InputSourceProperty.builder()
     *         .inputSourceArn("inputSourceArn")
     *         .schemaArn("schemaArn")
     *         // the properties below are optional
     *         .applyNormalization(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.InputSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(InputSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object containing <code>InputSourceARN</code> , <code>SchemaName</code> , and <code>ApplyNormalization</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html#cfn-entityresolution-matchingworkflow-inputsource-inputsourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html#cfn-entityresolution-matchingworkflow-inputsource-inputsourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputSourceArn();

        /**
         * The name of the schema.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html#cfn-entityresolution-matchingworkflow-inputsource-schemaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html#cfn-entityresolution-matchingworkflow-inputsource-schemaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSchemaArn();

        /**
         * Normalizes the attributes defined in the schema in the input data.
         * <p>
         * For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code> , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html#cfn-entityresolution-matchingworkflow-inputsource-applynormalization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-inputsource.html#cfn-entityresolution-matchingworkflow-inputsource-applynormalization</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplyNormalization() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputSourceProperty> {
            java.lang.String inputSourceArn;
            java.lang.String schemaArn;
            java.lang.Object applyNormalization;

            /**
             * Sets the value of {@link InputSourceProperty#getInputSourceArn}
             * @param inputSourceArn An object containing <code>InputSourceARN</code> , <code>SchemaName</code> , and <code>ApplyNormalization</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSourceArn(java.lang.String inputSourceArn) {
                this.inputSourceArn = inputSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link InputSourceProperty#getSchemaArn}
             * @param schemaArn The name of the schema. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaArn(java.lang.String schemaArn) {
                this.schemaArn = schemaArn;
                return this;
            }

            /**
             * Sets the value of {@link InputSourceProperty#getApplyNormalization}
             * @param applyNormalization Normalizes the attributes defined in the schema in the input data.
             *                           For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code> , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyNormalization(java.lang.Boolean applyNormalization) {
                this.applyNormalization = applyNormalization;
                return this;
            }

            /**
             * Sets the value of {@link InputSourceProperty#getApplyNormalization}
             * @param applyNormalization Normalizes the attributes defined in the schema in the input data.
             *                           For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code> , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyNormalization(software.amazon.awscdk.IResolvable applyNormalization) {
                this.applyNormalization = applyNormalization;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputSourceProperty {
            private final java.lang.String inputSourceArn;
            private final java.lang.String schemaArn;
            private final java.lang.Object applyNormalization;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputSourceArn = software.amazon.jsii.Kernel.get(this, "inputSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaArn = software.amazon.jsii.Kernel.get(this, "schemaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applyNormalization = software.amazon.jsii.Kernel.get(this, "applyNormalization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputSourceArn = java.util.Objects.requireNonNull(builder.inputSourceArn, "inputSourceArn is required");
                this.schemaArn = java.util.Objects.requireNonNull(builder.schemaArn, "schemaArn is required");
                this.applyNormalization = builder.applyNormalization;
            }

            @Override
            public final java.lang.String getInputSourceArn() {
                return this.inputSourceArn;
            }

            @Override
            public final java.lang.String getSchemaArn() {
                return this.schemaArn;
            }

            @Override
            public final java.lang.Object getApplyNormalization() {
                return this.applyNormalization;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputSourceArn", om.valueToTree(this.getInputSourceArn()));
                data.set("schemaArn", om.valueToTree(this.getSchemaArn()));
                if (this.getApplyNormalization() != null) {
                    data.set("applyNormalization", om.valueToTree(this.getApplyNormalization()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.InputSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputSourceProperty.Jsii$Proxy that = (InputSourceProperty.Jsii$Proxy) o;

                if (!inputSourceArn.equals(that.inputSourceArn)) return false;
                if (!schemaArn.equals(that.schemaArn)) return false;
                return this.applyNormalization != null ? this.applyNormalization.equals(that.applyNormalization) : that.applyNormalization == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputSourceArn.hashCode();
                result = 31 * result + (this.schemaArn.hashCode());
                result = 31 * result + (this.applyNormalization != null ? this.applyNormalization.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 location that temporarily stores your data while it processes.
     * <p>
     * Your information won't be saved permanently.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IntermediateSourceConfigurationProperty intermediateSourceConfigurationProperty = IntermediateSourceConfigurationProperty.builder()
     *         .intermediateS3Path("intermediateS3Path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-intermediatesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-intermediatesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.IntermediateSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IntermediateSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntermediateSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 location (bucket and prefix).
         * <p>
         * For example: <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-intermediatesourceconfiguration.html#cfn-entityresolution-matchingworkflow-intermediatesourceconfiguration-intermediates3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-intermediatesourceconfiguration.html#cfn-entityresolution-matchingworkflow-intermediatesourceconfiguration-intermediates3path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntermediateS3Path();

        /**
         * @return a {@link Builder} of {@link IntermediateSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntermediateSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntermediateSourceConfigurationProperty> {
            java.lang.String intermediateS3Path;

            /**
             * Sets the value of {@link IntermediateSourceConfigurationProperty#getIntermediateS3Path}
             * @param intermediateS3Path The Amazon S3 location (bucket and prefix). This parameter is required.
             *                           For example: <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateS3Path(java.lang.String intermediateS3Path) {
                this.intermediateS3Path = intermediateS3Path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntermediateSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntermediateSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntermediateSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntermediateSourceConfigurationProperty {
            private final java.lang.String intermediateS3Path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intermediateS3Path = software.amazon.jsii.Kernel.get(this, "intermediateS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intermediateS3Path = java.util.Objects.requireNonNull(builder.intermediateS3Path, "intermediateS3Path is required");
            }

            @Override
            public final java.lang.String getIntermediateS3Path() {
                return this.intermediateS3Path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("intermediateS3Path", om.valueToTree(this.getIntermediateS3Path()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.IntermediateSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntermediateSourceConfigurationProperty.Jsii$Proxy that = (IntermediateSourceConfigurationProperty.Jsii$Proxy) o;

                return this.intermediateS3Path.equals(that.intermediateS3Path);
            }

            @Override
            public final int hashCode() {
                int result = this.intermediateS3Path.hashCode();
                return result;
            }
        }
    }
    /**
     * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code> .
     * <p>
     * Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * OutputAttributeProperty outputAttributeProperty = OutputAttributeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .hashed(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.OutputAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name of a column to be written to the output.
         * <p>
         * This must be an <code>InputField</code> name in the schema mapping.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputattribute.html#cfn-entityresolution-matchingworkflow-outputattribute-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputattribute.html#cfn-entityresolution-matchingworkflow-outputattribute-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Enables the ability to hash the column values in the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputattribute.html#cfn-entityresolution-matchingworkflow-outputattribute-hashed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputattribute.html#cfn-entityresolution-matchingworkflow-outputattribute-hashed</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHashed() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputAttributeProperty> {
            java.lang.String name;
            java.lang.Object hashed;

            /**
             * Sets the value of {@link OutputAttributeProperty#getName}
             * @param name A name of a column to be written to the output. This parameter is required.
             *             This must be an <code>InputField</code> name in the schema mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OutputAttributeProperty#getHashed}
             * @param hashed Enables the ability to hash the column values in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashed(java.lang.Boolean hashed) {
                this.hashed = hashed;
                return this;
            }

            /**
             * Sets the value of {@link OutputAttributeProperty#getHashed}
             * @param hashed Enables the ability to hash the column values in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashed(software.amazon.awscdk.IResolvable hashed) {
                this.hashed = hashed;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputAttributeProperty {
            private final java.lang.String name;
            private final java.lang.Object hashed;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashed = software.amazon.jsii.Kernel.get(this, "hashed", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.hashed = builder.hashed;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getHashed() {
                return this.hashed;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getHashed() != null) {
                    data.set("hashed", om.valueToTree(this.getHashed()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.OutputAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputAttributeProperty.Jsii$Proxy that = (OutputAttributeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.hashed != null ? this.hashed.equals(that.hashed) : that.hashed == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.hashed != null ? this.hashed.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code> .
     * <p>
     * Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * OutputSourceProperty outputSourceProperty = OutputSourceProperty.builder()
     *         .output(List.of(OutputAttributeProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .hashed(false)
     *                 .build()))
     *         .outputS3Path("outputS3Path")
     *         // the properties below are optional
     *         .applyNormalization(false)
     *         .kmsArn("kmsArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.OutputSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code> .
         * <p>
         * Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutput();

        /**
         * The S3 path to which AWS Entity Resolution will write the output table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-outputs3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-outputs3path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputS3Path();

        /**
         * Normalizes the attributes defined in the schema in the input data.
         * <p>
         * For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code> , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-applynormalization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-applynormalization</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplyNormalization() {
            return null;
        }

        /**
         * Customer KMS ARN for encryption at rest.
         * <p>
         * If not provided, system will use an AWS Entity Resolution managed KMS key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-kmsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-outputsource.html#cfn-entityresolution-matchingworkflow-outputsource-kmsarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputSourceProperty> {
            java.lang.Object output;
            java.lang.String outputS3Path;
            java.lang.Object applyNormalization;
            java.lang.String kmsArn;

            /**
             * Sets the value of {@link OutputSourceProperty#getOutput}
             * @param output A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code> . This parameter is required.
             *               Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder output(software.amazon.awscdk.IResolvable output) {
                this.output = output;
                return this;
            }

            /**
             * Sets the value of {@link OutputSourceProperty#getOutput}
             * @param output A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code> . This parameter is required.
             *               Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder output(java.util.List<? extends java.lang.Object> output) {
                this.output = output;
                return this;
            }

            /**
             * Sets the value of {@link OutputSourceProperty#getOutputS3Path}
             * @param outputS3Path The S3 path to which AWS Entity Resolution will write the output table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3Path(java.lang.String outputS3Path) {
                this.outputS3Path = outputS3Path;
                return this;
            }

            /**
             * Sets the value of {@link OutputSourceProperty#getApplyNormalization}
             * @param applyNormalization Normalizes the attributes defined in the schema in the input data.
             *                           For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code> , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyNormalization(java.lang.Boolean applyNormalization) {
                this.applyNormalization = applyNormalization;
                return this;
            }

            /**
             * Sets the value of {@link OutputSourceProperty#getApplyNormalization}
             * @param applyNormalization Normalizes the attributes defined in the schema in the input data.
             *                           For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code> , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyNormalization(software.amazon.awscdk.IResolvable applyNormalization) {
                this.applyNormalization = applyNormalization;
                return this;
            }

            /**
             * Sets the value of {@link OutputSourceProperty#getKmsArn}
             * @param kmsArn Customer KMS ARN for encryption at rest.
             *               If not provided, system will use an AWS Entity Resolution managed KMS key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsArn(java.lang.String kmsArn) {
                this.kmsArn = kmsArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputSourceProperty {
            private final java.lang.Object output;
            private final java.lang.String outputS3Path;
            private final java.lang.Object applyNormalization;
            private final java.lang.String kmsArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputS3Path = software.amazon.jsii.Kernel.get(this, "outputS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applyNormalization = software.amazon.jsii.Kernel.get(this, "applyNormalization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsArn = software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
                this.outputS3Path = java.util.Objects.requireNonNull(builder.outputS3Path, "outputS3Path is required");
                this.applyNormalization = builder.applyNormalization;
                this.kmsArn = builder.kmsArn;
            }

            @Override
            public final java.lang.Object getOutput() {
                return this.output;
            }

            @Override
            public final java.lang.String getOutputS3Path() {
                return this.outputS3Path;
            }

            @Override
            public final java.lang.Object getApplyNormalization() {
                return this.applyNormalization;
            }

            @Override
            public final java.lang.String getKmsArn() {
                return this.kmsArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("output", om.valueToTree(this.getOutput()));
                data.set("outputS3Path", om.valueToTree(this.getOutputS3Path()));
                if (this.getApplyNormalization() != null) {
                    data.set("applyNormalization", om.valueToTree(this.getApplyNormalization()));
                }
                if (this.getKmsArn() != null) {
                    data.set("kmsArn", om.valueToTree(this.getKmsArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.OutputSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputSourceProperty.Jsii$Proxy that = (OutputSourceProperty.Jsii$Proxy) o;

                if (!output.equals(that.output)) return false;
                if (!outputS3Path.equals(that.outputS3Path)) return false;
                if (this.applyNormalization != null ? !this.applyNormalization.equals(that.applyNormalization) : that.applyNormalization != null) return false;
                return this.kmsArn != null ? this.kmsArn.equals(that.kmsArn) : that.kmsArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.output.hashCode();
                result = 31 * result + (this.outputS3Path.hashCode());
                result = 31 * result + (this.applyNormalization != null ? this.applyNormalization.hashCode() : 0);
                result = 31 * result + (this.kmsArn != null ? this.kmsArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing the <code>providerServiceARN</code> , <code>intermediateSourceConfiguration</code> , and <code>providerConfiguration</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * ProviderPropertiesProperty providerPropertiesProperty = ProviderPropertiesProperty.builder()
     *         .providerServiceArn("providerServiceArn")
     *         // the properties below are optional
     *         .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
     *                 .intermediateS3Path("intermediateS3Path")
     *                 .build())
     *         .providerConfiguration(Map.of(
     *                 "providerConfigurationKey", "providerConfiguration"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.ProviderPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ProviderPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProviderPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the provider service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html#cfn-entityresolution-matchingworkflow-providerproperties-providerservicearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html#cfn-entityresolution-matchingworkflow-providerproperties-providerservicearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderServiceArn();

        /**
         * The Amazon S3 location that temporarily stores your data while it processes.
         * <p>
         * Your information won't be saved permanently.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html#cfn-entityresolution-matchingworkflow-providerproperties-intermediatesourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html#cfn-entityresolution-matchingworkflow-providerproperties-intermediatesourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntermediateSourceConfiguration() {
            return null;
        }

        /**
         * The required configuration fields to use with the provider service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html#cfn-entityresolution-matchingworkflow-providerproperties-providerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-providerproperties.html#cfn-entityresolution-matchingworkflow-providerproperties-providerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProviderConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProviderPropertiesProperty> {
            java.lang.String providerServiceArn;
            java.lang.Object intermediateSourceConfiguration;
            java.lang.Object providerConfiguration;

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getProviderServiceArn}
             * @param providerServiceArn The ARN of the provider service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerServiceArn(java.lang.String providerServiceArn) {
                this.providerServiceArn = providerServiceArn;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getIntermediateSourceConfiguration}
             * @param intermediateSourceConfiguration The Amazon S3 location that temporarily stores your data while it processes.
             *                                        Your information won't be saved permanently.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateSourceConfiguration(software.amazon.awscdk.IResolvable intermediateSourceConfiguration) {
                this.intermediateSourceConfiguration = intermediateSourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getIntermediateSourceConfiguration}
             * @param intermediateSourceConfiguration The Amazon S3 location that temporarily stores your data while it processes.
             *                                        Your information won't be saved permanently.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateSourceConfiguration(software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.IntermediateSourceConfigurationProperty intermediateSourceConfiguration) {
                this.intermediateSourceConfiguration = intermediateSourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getProviderConfiguration}
             * @param providerConfiguration The required configuration fields to use with the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerConfiguration(java.util.Map<java.lang.String, java.lang.String> providerConfiguration) {
                this.providerConfiguration = providerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getProviderConfiguration}
             * @param providerConfiguration The required configuration fields to use with the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerConfiguration(software.amazon.awscdk.IResolvable providerConfiguration) {
                this.providerConfiguration = providerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProviderPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProviderPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProviderPropertiesProperty {
            private final java.lang.String providerServiceArn;
            private final java.lang.Object intermediateSourceConfiguration;
            private final java.lang.Object providerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerServiceArn = software.amazon.jsii.Kernel.get(this, "providerServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.intermediateSourceConfiguration = software.amazon.jsii.Kernel.get(this, "intermediateSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.providerConfiguration = software.amazon.jsii.Kernel.get(this, "providerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerServiceArn = java.util.Objects.requireNonNull(builder.providerServiceArn, "providerServiceArn is required");
                this.intermediateSourceConfiguration = builder.intermediateSourceConfiguration;
                this.providerConfiguration = builder.providerConfiguration;
            }

            @Override
            public final java.lang.String getProviderServiceArn() {
                return this.providerServiceArn;
            }

            @Override
            public final java.lang.Object getIntermediateSourceConfiguration() {
                return this.intermediateSourceConfiguration;
            }

            @Override
            public final java.lang.Object getProviderConfiguration() {
                return this.providerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("providerServiceArn", om.valueToTree(this.getProviderServiceArn()));
                if (this.getIntermediateSourceConfiguration() != null) {
                    data.set("intermediateSourceConfiguration", om.valueToTree(this.getIntermediateSourceConfiguration()));
                }
                if (this.getProviderConfiguration() != null) {
                    data.set("providerConfiguration", om.valueToTree(this.getProviderConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.ProviderPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProviderPropertiesProperty.Jsii$Proxy that = (ProviderPropertiesProperty.Jsii$Proxy) o;

                if (!providerServiceArn.equals(that.providerServiceArn)) return false;
                if (this.intermediateSourceConfiguration != null ? !this.intermediateSourceConfiguration.equals(that.intermediateSourceConfiguration) : that.intermediateSourceConfiguration != null) return false;
                return this.providerConfiguration != null ? this.providerConfiguration.equals(that.providerConfiguration) : that.providerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.providerServiceArn.hashCode();
                result = 31 * result + (this.intermediateSourceConfiguration != null ? this.intermediateSourceConfiguration.hashCode() : 0);
                result = 31 * result + (this.providerConfiguration != null ? this.providerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * ResolutionTechniquesProperty resolutionTechniquesProperty = ResolutionTechniquesProperty.builder()
     *         .providerProperties(ProviderPropertiesProperty.builder()
     *                 .providerServiceArn("providerServiceArn")
     *                 // the properties below are optional
     *                 .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
     *                         .intermediateS3Path("intermediateS3Path")
     *                         .build())
     *                 .providerConfiguration(Map.of(
     *                         "providerConfigurationKey", "providerConfiguration"))
     *                 .build())
     *         .resolutionType("resolutionType")
     *         .ruleBasedProperties(RuleBasedPropertiesProperty.builder()
     *                 .attributeMatchingModel("attributeMatchingModel")
     *                 .rules(List.of(RuleProperty.builder()
     *                         .matchingKeys(List.of("matchingKeys"))
     *                         .ruleName("ruleName")
     *                         .build()))
     *                 // the properties below are optional
     *                 .matchPurpose("matchPurpose")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.ResolutionTechniquesProperty")
    @software.amazon.jsii.Jsii.Proxy(ResolutionTechniquesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResolutionTechniquesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties of the provider service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html#cfn-entityresolution-matchingworkflow-resolutiontechniques-providerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html#cfn-entityresolution-matchingworkflow-resolutiontechniques-providerproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProviderProperties() {
            return null;
        }

        /**
         * The type of matching.
         * <p>
         * There are three types of matching: <code>RULE_MATCHING</code> , <code>ML_MATCHING</code> , and <code>PROVIDER</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html#cfn-entityresolution-matchingworkflow-resolutiontechniques-resolutiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html#cfn-entityresolution-matchingworkflow-resolutiontechniques-resolutiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolutionType() {
            return null;
        }

        /**
         * An object which defines the list of matching rules to run and has a field <code>Rules</code> , which is a list of rule objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html#cfn-entityresolution-matchingworkflow-resolutiontechniques-rulebasedproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-resolutiontechniques.html#cfn-entityresolution-matchingworkflow-resolutiontechniques-rulebasedproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleBasedProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResolutionTechniquesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResolutionTechniquesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResolutionTechniquesProperty> {
            java.lang.Object providerProperties;
            java.lang.String resolutionType;
            java.lang.Object ruleBasedProperties;

            /**
             * Sets the value of {@link ResolutionTechniquesProperty#getProviderProperties}
             * @param providerProperties The properties of the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerProperties(software.amazon.awscdk.IResolvable providerProperties) {
                this.providerProperties = providerProperties;
                return this;
            }

            /**
             * Sets the value of {@link ResolutionTechniquesProperty#getProviderProperties}
             * @param providerProperties The properties of the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerProperties(software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.ProviderPropertiesProperty providerProperties) {
                this.providerProperties = providerProperties;
                return this;
            }

            /**
             * Sets the value of {@link ResolutionTechniquesProperty#getResolutionType}
             * @param resolutionType The type of matching.
             *                       There are three types of matching: <code>RULE_MATCHING</code> , <code>ML_MATCHING</code> , and <code>PROVIDER</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolutionType(java.lang.String resolutionType) {
                this.resolutionType = resolutionType;
                return this;
            }

            /**
             * Sets the value of {@link ResolutionTechniquesProperty#getRuleBasedProperties}
             * @param ruleBasedProperties An object which defines the list of matching rules to run and has a field <code>Rules</code> , which is a list of rule objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleBasedProperties(software.amazon.awscdk.IResolvable ruleBasedProperties) {
                this.ruleBasedProperties = ruleBasedProperties;
                return this;
            }

            /**
             * Sets the value of {@link ResolutionTechniquesProperty#getRuleBasedProperties}
             * @param ruleBasedProperties An object which defines the list of matching rules to run and has a field <code>Rules</code> , which is a list of rule objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleBasedProperties(software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.RuleBasedPropertiesProperty ruleBasedProperties) {
                this.ruleBasedProperties = ruleBasedProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResolutionTechniquesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResolutionTechniquesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResolutionTechniquesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResolutionTechniquesProperty {
            private final java.lang.Object providerProperties;
            private final java.lang.String resolutionType;
            private final java.lang.Object ruleBasedProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerProperties = software.amazon.jsii.Kernel.get(this, "providerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resolutionType = software.amazon.jsii.Kernel.get(this, "resolutionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleBasedProperties = software.amazon.jsii.Kernel.get(this, "ruleBasedProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerProperties = builder.providerProperties;
                this.resolutionType = builder.resolutionType;
                this.ruleBasedProperties = builder.ruleBasedProperties;
            }

            @Override
            public final java.lang.Object getProviderProperties() {
                return this.providerProperties;
            }

            @Override
            public final java.lang.String getResolutionType() {
                return this.resolutionType;
            }

            @Override
            public final java.lang.Object getRuleBasedProperties() {
                return this.ruleBasedProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProviderProperties() != null) {
                    data.set("providerProperties", om.valueToTree(this.getProviderProperties()));
                }
                if (this.getResolutionType() != null) {
                    data.set("resolutionType", om.valueToTree(this.getResolutionType()));
                }
                if (this.getRuleBasedProperties() != null) {
                    data.set("ruleBasedProperties", om.valueToTree(this.getRuleBasedProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.ResolutionTechniquesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResolutionTechniquesProperty.Jsii$Proxy that = (ResolutionTechniquesProperty.Jsii$Proxy) o;

                if (this.providerProperties != null ? !this.providerProperties.equals(that.providerProperties) : that.providerProperties != null) return false;
                if (this.resolutionType != null ? !this.resolutionType.equals(that.resolutionType) : that.resolutionType != null) return false;
                return this.ruleBasedProperties != null ? this.ruleBasedProperties.equals(that.ruleBasedProperties) : that.ruleBasedProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.providerProperties != null ? this.providerProperties.hashCode() : 0;
                result = 31 * result + (this.resolutionType != null ? this.resolutionType.hashCode() : 0);
                result = 31 * result + (this.ruleBasedProperties != null ? this.ruleBasedProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object which defines the list of matching rules to run in a matching workflow.
     * <p>
     * RuleBasedProperties contain a <code>Rules</code> field, which is a list of rule objects.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * RuleBasedPropertiesProperty ruleBasedPropertiesProperty = RuleBasedPropertiesProperty.builder()
     *         .attributeMatchingModel("attributeMatchingModel")
     *         .rules(List.of(RuleProperty.builder()
     *                 .matchingKeys(List.of("matchingKeys"))
     *                 .ruleName("ruleName")
     *                 .build()))
     *         // the properties below are optional
     *         .matchPurpose("matchPurpose")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.RuleBasedPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleBasedPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleBasedPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code> .
         * <p>
         * If you choose <code>MANY_TO_MANY</code> , the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A and the value of <code>BusinessEmail</code> field of Profile B matches, the two profiles are matched on the <code>Email</code> attribute type.
         * <p>
         * If you choose <code>ONE_TO_ONE</code> , the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html#cfn-entityresolution-matchingworkflow-rulebasedproperties-attributematchingmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html#cfn-entityresolution-matchingworkflow-rulebasedproperties-attributematchingmodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeMatchingModel();

        /**
         * A list of <code>Rule</code> objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html#cfn-entityresolution-matchingworkflow-rulebasedproperties-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html#cfn-entityresolution-matchingworkflow-rulebasedproperties-rules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * An indicator of whether to generate IDs and index the data or not.
         * <p>
         * If you choose <code>IDENTIFIER_GENERATION</code> , the process generates IDs and indexes the data.
         * <p>
         * If you choose <code>INDEXING</code> , the process indexes the data without generating IDs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html#cfn-entityresolution-matchingworkflow-rulebasedproperties-matchpurpose">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rulebasedproperties.html#cfn-entityresolution-matchingworkflow-rulebasedproperties-matchpurpose</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMatchPurpose() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleBasedPropertiesProperty> {
            java.lang.String attributeMatchingModel;
            java.lang.Object rules;
            java.lang.String matchPurpose;

            /**
             * Sets the value of {@link RuleBasedPropertiesProperty#getAttributeMatchingModel}
             * @param attributeMatchingModel The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code> . This parameter is required.
             *                               If you choose <code>MANY_TO_MANY</code> , the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A and the value of <code>BusinessEmail</code> field of Profile B matches, the two profiles are matched on the <code>Email</code> attribute type.
             *                               <p>
             *                               If you choose <code>ONE_TO_ONE</code> , the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeMatchingModel(java.lang.String attributeMatchingModel) {
                this.attributeMatchingModel = attributeMatchingModel;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedPropertiesProperty#getRules}
             * @param rules A list of <code>Rule</code> objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedPropertiesProperty#getRules}
             * @param rules A list of <code>Rule</code> objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedPropertiesProperty#getMatchPurpose}
             * @param matchPurpose An indicator of whether to generate IDs and index the data or not.
             *                     If you choose <code>IDENTIFIER_GENERATION</code> , the process generates IDs and indexes the data.
             *                     <p>
             *                     If you choose <code>INDEXING</code> , the process indexes the data without generating IDs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPurpose(java.lang.String matchPurpose) {
                this.matchPurpose = matchPurpose;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleBasedPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleBasedPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleBasedPropertiesProperty {
            private final java.lang.String attributeMatchingModel;
            private final java.lang.Object rules;
            private final java.lang.String matchPurpose;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeMatchingModel = software.amazon.jsii.Kernel.get(this, "attributeMatchingModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchPurpose = software.amazon.jsii.Kernel.get(this, "matchPurpose", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeMatchingModel = java.util.Objects.requireNonNull(builder.attributeMatchingModel, "attributeMatchingModel is required");
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
                this.matchPurpose = builder.matchPurpose;
            }

            @Override
            public final java.lang.String getAttributeMatchingModel() {
                return this.attributeMatchingModel;
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public final java.lang.String getMatchPurpose() {
                return this.matchPurpose;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeMatchingModel", om.valueToTree(this.getAttributeMatchingModel()));
                data.set("rules", om.valueToTree(this.getRules()));
                if (this.getMatchPurpose() != null) {
                    data.set("matchPurpose", om.valueToTree(this.getMatchPurpose()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.RuleBasedPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleBasedPropertiesProperty.Jsii$Proxy that = (RuleBasedPropertiesProperty.Jsii$Proxy) o;

                if (!attributeMatchingModel.equals(that.attributeMatchingModel)) return false;
                if (!rules.equals(that.rules)) return false;
                return this.matchPurpose != null ? this.matchPurpose.equals(that.matchPurpose) : that.matchPurpose == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeMatchingModel.hashCode();
                result = 31 * result + (this.rules.hashCode());
                result = 31 * result + (this.matchPurpose != null ? this.matchPurpose.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing <code>RuleName</code> , and <code>MatchingKeys</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .matchingKeys(List.of("matchingKeys"))
     *         .ruleName("ruleName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of <code>MatchingKeys</code> .
         * <p>
         * The <code>MatchingKeys</code> must have been defined in the <code>SchemaMapping</code> . Two records are considered to match according to this rule if all of the <code>MatchingKeys</code> match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rule.html#cfn-entityresolution-matchingworkflow-rule-matchingkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rule.html#cfn-entityresolution-matchingworkflow-rule-matchingkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchingKeys();

        /**
         * A name for the matching rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rule.html#cfn-entityresolution-matchingworkflow-rule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-matchingworkflow-rule.html#cfn-entityresolution-matchingworkflow-rule-rulename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.util.List<java.lang.String> matchingKeys;
            java.lang.String ruleName;

            /**
             * Sets the value of {@link RuleProperty#getMatchingKeys}
             * @param matchingKeys A list of <code>MatchingKeys</code> . This parameter is required.
             *                     The <code>MatchingKeys</code> must have been defined in the <code>SchemaMapping</code> . Two records are considered to match according to this rule if all of the <code>MatchingKeys</code> match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingKeys(java.util.List<java.lang.String> matchingKeys) {
                this.matchingKeys = matchingKeys;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getRuleName}
             * @param ruleName A name for the matching rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleName(java.lang.String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.util.List<java.lang.String> matchingKeys;
            private final java.lang.String ruleName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchingKeys = software.amazon.jsii.Kernel.get(this, "matchingKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchingKeys = java.util.Objects.requireNonNull(builder.matchingKeys, "matchingKeys is required");
                this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
            }

            @Override
            public final java.util.List<java.lang.String> getMatchingKeys() {
                return this.matchingKeys;
            }

            @Override
            public final java.lang.String getRuleName() {
                return this.ruleName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchingKeys", om.valueToTree(this.getMatchingKeys()));
                data.set("ruleName", om.valueToTree(this.getRuleName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflow.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!matchingKeys.equals(that.matchingKeys)) return false;
                return this.ruleName.equals(that.ruleName);
            }

            @Override
            public final int hashCode() {
                int result = this.matchingKeys.hashCode();
                result = 31 * result + (this.ruleName.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflowProps.Builder();
        }

        /**
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-inputsourceconfig</a>
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(final software.amazon.awscdk.IResolvable inputSourceConfig) {
            this.props.inputSourceConfig(inputSourceConfig);
            return this;
        }
        /**
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-inputsourceconfig</a>
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(final java.util.List<? extends java.lang.Object> inputSourceConfig) {
            this.props.inputSourceConfig(inputSourceConfig);
            return this;
        }

        /**
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-outputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-outputsourceconfig</a>
         * @param outputSourceConfig A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(final software.amazon.awscdk.IResolvable outputSourceConfig) {
            this.props.outputSourceConfig(outputSourceConfig);
            return this;
        }
        /**
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-outputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-outputsourceconfig</a>
         * @param outputSourceConfig A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(final java.util.List<? extends java.lang.Object> outputSourceConfig) {
            this.props.outputSourceConfig(outputSourceConfig);
            return this;
        }

        /**
         * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-resolutiontechniques">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-resolutiontechniques</a>
         * @param resolutionTechniques An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolutionTechniques(final software.amazon.awscdk.IResolvable resolutionTechniques) {
            this.props.resolutionTechniques(resolutionTechniques);
            return this;
        }
        /**
         * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-resolutiontechniques">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-resolutiontechniques</a>
         * @param resolutionTechniques An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolutionTechniques(final software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.ResolutionTechniquesProperty resolutionTechniques) {
            this.props.resolutionTechniques(resolutionTechniques);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         * <p>
         * AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The name of the workflow.
         * <p>
         * There can't be multiple <code>MatchingWorkflows</code> with the same name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-workflowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-workflowname</a>
         * @param workflowName The name of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowName(final java.lang.String workflowName) {
            this.props.workflowName(workflowName);
            return this;
        }

        /**
         * A description of the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-description</a>
         * @param description A description of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-incrementalrunconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-incrementalrunconfig</a>
         * @param incrementalRunConfig An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder incrementalRunConfig(final software.amazon.awscdk.IResolvable incrementalRunConfig) {
            this.props.incrementalRunConfig(incrementalRunConfig);
            return this;
        }
        /**
         * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-incrementalrunconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-incrementalrunconfig</a>
         * @param incrementalRunConfig An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder incrementalRunConfig(final software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.IncrementalRunConfigProperty incrementalRunConfig) {
            this.props.incrementalRunConfig(incrementalRunConfig);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow build() {
            return new software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
